/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.BVal;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.Statement;

public final class AsyncQueryPartition
extends AsyncMultiCommand {
    private final AsyncMultiExecutor parent;
    private final RecordSequenceListener listener;
    private final Statement statement;
    private final long taskId;
    private final PartitionTracker tracker;
    private final PartitionTracker.NodePartitions nodePartitions;

    public AsyncQueryPartition(AsyncMultiExecutor parent, QueryPolicy policy, RecordSequenceListener listener, Statement statement, long taskId, PartitionTracker tracker, PartitionTracker.NodePartitions nodePartitions) {
        super(nodePartitions.node, policy, tracker.socketTimeout, tracker.totalTimeout);
        this.parent = parent;
        this.listener = listener;
        this.statement = statement;
        this.taskId = taskId;
        this.tracker = tracker;
        this.nodePartitions = nodePartitions;
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.QUERY;
    }

    @Override
    protected void writeBuffer() {
        this.setQuery(this.parent.cluster, this.policy, this.statement, this.taskId, false, this.nodePartitions);
    }

    @Override
    protected void parseRow() {
        BVal bval = new BVal();
        Key key = this.parseKey(this.fieldCount, bval);
        if ((this.info3 & 4) != 0) {
            if (this.resultCode != 0) {
                this.tracker.partitionUnavailable(this.nodePartitions, this.generation);
            }
            return;
        }
        if (this.resultCode != 0) {
            throw new AerospikeException(this.resultCode);
        }
        Record record = this.parseRecord();
        if (this.tracker.allowRecord(this.nodePartitions)) {
            this.listener.onRecord(key, record);
            this.tracker.setLast(this.nodePartitions, key, bval.val);
        }
    }

    @Override
    protected void onSuccess() {
        this.parent.childSuccess(this.node);
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        if (this.tracker.shouldRetry(this.nodePartitions, ae)) {
            this.parent.childSuccess(this.node);
            return;
        }
        this.parent.childFailure(ae);
    }
}

