/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncConnector;
import com.aerospike.client.async.INioCommand;
import com.aerospike.client.async.NioConnection;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public final class NioConnector
extends AsyncConnector
implements INioCommand {
    private final NioEventLoop eventLoop;
    private ByteBuffer byteBuffer;
    private NioConnection conn;

    public NioConnector(NioEventLoop eventLoop, Cluster cluster, Node node, AsyncConnector.Listener listener) {
        super(eventLoop, cluster, node, listener);
        this.eventLoop = eventLoop;
    }

    @Override
    public void createConnection() {
        this.state = 4;
        this.conn = new NioConnection(this.node.getAddress());
        this.node.connectionOpened(this.eventLoop.index);
        this.conn.registerConnect(this.eventLoop, this);
    }

    @Override
    public void processEvent(SelectionKey key) {
        try {
            int ops = key.readyOps();
            if ((ops & 1) != 0) {
                this.read();
            } else if ((ops & 4) != 0) {
                this.write();
            } else if ((ops & 8) != 0) {
                this.finishConnect();
            }
        }
        catch (AerospikeException ae) {
            this.fail(ae);
        }
        catch (Throwable e) {
            this.fail(new AerospikeException(e));
        }
    }

    protected final void finishConnect() throws IOException {
        byte[] token;
        this.conn.finishConnect();
        if (this.cluster.authEnabled && (token = this.node.getSessionToken()) != null) {
            this.writeAuth(token);
            return;
        }
        this.finish();
    }

    private final void writeAuth(byte[] token) throws IOException {
        this.state = 6;
        byte[] dataBuffer = new byte[256];
        AdminCommand admin = new AdminCommand(dataBuffer);
        int dataOffset = admin.setAuthenticate(this.cluster, token);
        this.byteBuffer = this.eventLoop.getByteBuffer();
        this.byteBuffer.clear();
        this.byteBuffer.put(dataBuffer, 0, dataOffset);
        this.byteBuffer.flip();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 7;
            this.conn.registerRead();
        } else {
            this.state = 6;
            this.conn.registerWrite();
        }
    }

    protected final void write() throws IOException {
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 7;
            this.conn.registerRead();
        }
    }

    protected final void read() throws IOException {
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        switch (this.state) {
            case 7: {
                this.readAuthHeader();
                if (!this.conn.read(this.byteBuffer)) {
                    return;
                }
            }
            case 8: {
                this.readAuthBody();
                this.finish();
            }
        }
    }

    private final void readAuthHeader() {
        this.byteBuffer.position(0);
        int receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (receiveSize < 2 || receiveSize > this.byteBuffer.capacity()) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + receiveSize);
        }
        this.byteBuffer.clear();
        this.byteBuffer.limit(receiveSize);
        this.state = 8;
    }

    private final void readAuthBody() {
        int resultCode = this.byteBuffer.get(1) & 0xFF;
        if (resultCode != 0 && resultCode != 52) {
            this.node.signalLogin();
            throw new AerospikeException(resultCode);
        }
    }

    private final void finish() {
        this.conn.unregister();
        this.conn.updateLastUsed();
        this.putByteBuffer();
        this.success();
    }

    private final void putByteBuffer() {
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
            this.byteBuffer = null;
        }
    }

    @Override
    final boolean addConnection() {
        boolean ret = this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.conn = null;
        return ret;
    }

    @Override
    final void closeConnection() {
        this.putByteBuffer();
        if (this.conn != null) {
            this.node.closeAsyncConnection(this.conn, this.eventLoop.index);
            this.conn = null;
        } else {
            this.node.decrAsyncConnection(this.eventLoop.index);
        }
    }
}

