/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventLoopStats;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.Monitor;
import com.aerospike.client.async.NettyTlsContext;
import com.aerospike.client.async.NioEventLoops;
import com.aerospike.client.cluster.ClusterStats;
import com.aerospike.client.cluster.ConnectionRecover;
import com.aerospike.client.cluster.ConnectionStats;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeStats;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.cluster.ThreadDaemonFactory;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.ClusterStatsListener;
import com.aerospike.client.metrics.MetricsListener;
import com.aerospike.client.metrics.MetricsPolicy;
import com.aerospike.client.metrics.MetricsWriter;
import com.aerospike.client.policy.AuthMode;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.TCPKeepAlive;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Cluster
implements Runnable,
Closeable {
    public final AerospikeClient client;
    protected final String clusterName;
    private volatile Host[] seeds;
    protected final HashMap<Host, Node> aliases;
    protected final HashMap<String, Node> nodesMap;
    private volatile Node[] nodes;
    public volatile HashMap<String, Partitions> partitionMap;
    protected final Map<String, String> ipMap;
    public final TlsPolicy tlsPolicy;
    public final NettyTlsContext nettyTlsContext;
    public final AuthMode authMode;
    protected final byte[] user;
    private byte[] password;
    private byte[] passwordHash;
    private final AtomicInteger nodeIndex;
    final AtomicInteger replicaIndex;
    private final AtomicInteger recoverCount;
    private final ConcurrentLinkedDeque<ConnectionRecover> recoverQueue;
    private final ExecutorService threadPool;
    public final TCPKeepAlive keepAlive;
    public final EventLoops eventLoops;
    public final EventState[] eventState;
    private final long maxSocketIdleNanosTran;
    private final long maxSocketIdleNanosTrim;
    protected final int minConnsPerNode;
    protected final int maxConnsPerNode;
    protected final int asyncMinConnsPerNode;
    protected final int asyncMaxConnsPerNode;
    protected final int connPoolsPerNode;
    int maxErrorRate;
    int errorRateWindow;
    public final int connectTimeout;
    public final int loginTimeout;
    public final int closeTimeout;
    public final int[] rackIds;
    private volatile int invalidNodeCount;
    private final int tendInterval;
    private int tendCount;
    private AtomicBoolean closed;
    private Thread tendThread;
    protected volatile boolean tendValid;
    private final boolean sharedThreadPool;
    protected final boolean useServicesAlternate;
    final boolean rackAware;
    public final boolean validateClusterName;
    public final boolean authEnabled;
    public boolean hasPartitionQuery;
    private boolean asyncComplete;
    public boolean metricsEnabled;
    MetricsPolicy metricsPolicy;
    private volatile MetricsListener metricsListener;
    private final AtomicLong retryCount = new AtomicLong();
    private final AtomicLong tranCount = new AtomicLong();
    private final AtomicLong delayQueueTimeoutCount = new AtomicLong();

    public Cluster(AerospikeClient client, ClientPolicy policy, Host[] hosts) {
        int i;
        this.client = client;
        this.clusterName = policy.clusterName;
        this.validateClusterName = policy.validateClusterName;
        this.tlsPolicy = policy.tlsPolicy;
        this.authMode = policy.authMode;
        if (this.tlsPolicy != null) {
            boolean useClusterName = this.clusterName != null && this.clusterName.length() > 0;
            for (i = 0; i < hosts.length; ++i) {
                Host host = hosts[i];
                if (host.tlsName != null) continue;
                String tlsName = useClusterName ? this.clusterName : host.name;
                hosts[i] = new Host(host.name, tlsName, host.port);
            }
        } else if (this.authMode == AuthMode.EXTERNAL || this.authMode == AuthMode.PKI) {
            throw new AerospikeException("TLS is required for authentication mode: " + (Object)((Object)this.authMode));
        }
        this.seeds = hosts;
        if (policy.authMode == AuthMode.PKI) {
            this.authEnabled = true;
            this.user = null;
        } else if (policy.user != null && policy.user.length() > 0) {
            String pass;
            this.authEnabled = true;
            this.user = Buffer.stringToUtf8(policy.user);
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = Buffer.stringToUtf8(policy.password);
            }
            if ((pass = policy.password) == null) {
                pass = "";
            }
            pass = AdminCommand.hashPassword(pass);
            this.passwordHash = Buffer.stringToUtf8(pass);
        } else {
            this.authEnabled = false;
            this.user = null;
        }
        if (policy.maxSocketIdle < 0) {
            throw new AerospikeException("Invalid maxSocketIdle: " + policy.maxSocketIdle);
        }
        if (policy.maxSocketIdle == 0) {
            this.maxSocketIdleNanosTran = 0L;
            this.maxSocketIdleNanosTrim = TimeUnit.SECONDS.toNanos(55L);
        } else {
            this.maxSocketIdleNanosTrim = this.maxSocketIdleNanosTran = TimeUnit.SECONDS.toNanos(policy.maxSocketIdle);
        }
        this.minConnsPerNode = policy.minConnsPerNode;
        this.maxConnsPerNode = policy.maxConnsPerNode;
        if (this.minConnsPerNode > this.maxConnsPerNode) {
            throw new AerospikeException("Invalid connection range: " + this.minConnsPerNode + " - " + this.maxConnsPerNode);
        }
        this.asyncMinConnsPerNode = policy.asyncMinConnsPerNode;
        int n = this.asyncMaxConnsPerNode = policy.asyncMaxConnsPerNode >= 0 ? policy.asyncMaxConnsPerNode : policy.maxConnsPerNode;
        if (this.asyncMinConnsPerNode > this.asyncMaxConnsPerNode) {
            throw new AerospikeException("Invalid async connection range: " + this.asyncMinConnsPerNode + " - " + this.asyncMaxConnsPerNode);
        }
        this.connPoolsPerNode = policy.connPoolsPerNode;
        this.maxErrorRate = policy.maxErrorRate;
        this.errorRateWindow = policy.errorRateWindow;
        this.connectTimeout = policy.timeout;
        this.loginTimeout = policy.loginTimeout;
        this.closeTimeout = policy.closeTimeout;
        this.tendInterval = policy.tendInterval;
        this.ipMap = policy.ipMap;
        this.keepAlive = policy.keepAlive;
        this.threadPool = policy.threadPool == null ? Executors.newCachedThreadPool(new ThreadDaemonFactory()) : policy.threadPool;
        this.sharedThreadPool = policy.sharedThreadPool;
        this.useServicesAlternate = policy.useServicesAlternate;
        this.rackAware = policy.rackAware;
        if (policy.rackIds != null && policy.rackIds.size() > 0) {
            List<Integer> list = policy.rackIds;
            int max2 = list.size();
            this.rackIds = new int[max2];
            for (int i2 = 0; i2 < max2; ++i2) {
                this.rackIds[i2] = list.get(i2);
            }
        } else {
            this.rackIds = new int[]{policy.rackId};
        }
        this.aliases = new HashMap();
        this.nodesMap = new HashMap();
        this.nodes = new Node[0];
        this.partitionMap = new HashMap();
        this.nodeIndex = new AtomicInteger();
        this.replicaIndex = new AtomicInteger();
        this.recoverCount = new AtomicInteger();
        this.recoverQueue = new ConcurrentLinkedDeque();
        this.closed = new AtomicBoolean();
        this.eventLoops = policy.eventLoops;
        if (this.eventLoops != null) {
            EventLoop[] loops = this.eventLoops.getArray();
            if (this.asyncMaxConnsPerNode < loops.length) {
                throw new AerospikeException("asyncMaxConnsPerNode " + this.asyncMaxConnsPerNode + " must be >= event loop count " + loops.length);
            }
            this.eventState = new EventState[loops.length];
            for (i = 0; i < loops.length; ++i) {
                this.eventState[i] = loops[i].createState();
            }
            if (policy.tlsPolicy != null) {
                if (this.eventLoops instanceof NioEventLoops) {
                    throw new AerospikeException("TLS not supported in direct NIO event loops");
                }
                this.nettyTlsContext = policy.tlsPolicy.nettyContext != null ? policy.tlsPolicy.nettyContext : new NettyTlsContext(policy.tlsPolicy);
            } else {
                this.nettyTlsContext = null;
            }
        } else {
            this.eventState = null;
            this.nettyTlsContext = null;
        }
        if (policy.forceSingleNode) {
            try {
                this.forceSingleNode();
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        } else {
            this.initTendThread(policy.failIfNotConnected);
        }
    }

    public void forceSingleNode() {
        this.tendValid = true;
        this.tendThread = new Thread(this);
        Host seed = this.seeds[0];
        NodeValidator nv = new NodeValidator();
        Node node = null;
        try {
            node = nv.seedNode(this, seed, null);
        }
        catch (Throwable e) {
            throw new AerospikeException("Seed " + seed + " failed: " + e.getMessage(), e);
        }
        node.createMinConnections();
        HashMap<String, Node> nodesToAdd = new HashMap<String, Node>(1);
        nodesToAdd.put(node.getName(), node);
        this.addNodes(nodesToAdd);
        Peers peers = new Peers(this.nodes.length + 16);
        node.refreshPartitions(peers);
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max2 = nodeArray.length();
                for (int i = 0; i < max2; ++i) {
                    nodeArray.set(i, node);
                }
            }
        }
    }

    public void initTendThread(boolean failIfNotConnected) {
        this.waitTillStabilized(failIfNotConnected);
        if (Log.debugEnabled()) {
            for (Host host : this.seeds) {
                Log.debug("Add seed " + host);
            }
        }
        ArrayList<Host> seedsToAdd = new ArrayList<Host>(this.nodes.length);
        for (Node node : this.nodes) {
            Host host = node.getHost();
            if (this.findSeed(host)) continue;
            seedsToAdd.add(host);
        }
        if (seedsToAdd.size() > 0) {
            this.addSeeds(seedsToAdd.toArray(new Host[seedsToAdd.size()]));
        }
        this.tendValid = true;
        this.tendThread = new Thread(this);
        this.tendThread.setName("tend");
        this.tendThread.setDaemon(true);
        this.tendThread.start();
    }

    public final void addSeeds(Host[] hosts) {
        Host[] seedArray = new Host[this.seeds.length + hosts.length];
        int count = 0;
        for (Host seed : this.seeds) {
            seedArray[count++] = seed;
        }
        for (Host host : hosts) {
            if (Log.debugEnabled()) {
                Log.debug("Add seed " + host);
            }
            seedArray[count++] = host;
        }
        this.seeds = seedArray;
    }

    private final boolean findSeed(Host search) {
        for (Host seed : this.seeds) {
            if (!seed.equals(search)) continue;
            return true;
        }
        return false;
    }

    private final void waitTillStabilized(boolean failIfNotConnected) {
        this.tend(failIfNotConnected, true);
        if (this.nodes.length == 0) {
            String message = "Cluster seed(s) failed";
            if (failIfNotConnected) {
                throw new AerospikeException(message);
            }
            Log.warn(message);
        }
    }

    @Override
    public final void run() {
        while (this.tendValid) {
            block3: {
                try {
                    this.tend(false, false);
                }
                catch (Throwable e) {
                    if (!Log.warnEnabled()) break block3;
                    Log.warn("Cluster tend failed: " + Util.getErrorMessage(e));
                }
            }
            Util.sleep(this.tendInterval);
        }
    }

    private final void tend(boolean failIfNotConnected, boolean isInit) {
        Peers peers = new Peers(this.nodes.length + 16);
        for (Node node : this.nodes) {
            node.referenceCount = 0;
            node.partitionChanged = false;
            node.rebalanceChanged = false;
        }
        if (this.nodes.length == 0) {
            this.seedNode(peers, failIfNotConnected);
            if (isInit && failIfNotConnected && this.nodes.length == 1 && peers.getInvalidCount() > 0) {
                peers.clusterInitError();
            }
        } else {
            for (Node node : this.nodes) {
                node.refresh(peers);
            }
            if (peers.genChanged) {
                peers.refreshCount = 0;
                for (Node node : this.nodes) {
                    node.refreshPeers(peers);
                }
                ArrayList<Node> removeList = this.findNodesToRemove(peers.refreshCount);
                if (removeList.size() > 0) {
                    this.removeNodes(removeList);
                }
            }
            if (peers.nodes.size() > 0) {
                this.addNodes(peers.nodes);
                this.refreshPeers(peers);
            }
        }
        this.invalidNodeCount += peers.getInvalidCount();
        for (Node node : this.nodes) {
            if (node.partitionChanged) {
                node.refreshPartitions(peers);
            }
            if (!node.rebalanceChanged) continue;
            node.refreshRacks();
        }
        ++this.tendCount;
        if (this.tendCount % 30 == 0) {
            for (Node node : this.nodes) {
                node.balanceConnections();
            }
            if (this.eventState != null) {
                for (EventState eventState : this.eventState) {
                    final EventLoop eventLoop = eventState.eventLoop;
                    eventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    Node[] nodeArray;
                                    for (Node node : nodeArray = Cluster.this.nodes) {
                                        node.balanceAsyncConnections(eventLoop);
                                    }
                                }
                                catch (Throwable e) {
                                    if (!Log.warnEnabled()) break block3;
                                    Log.warn("balanceAsyncConnections failed: " + Util.getErrorMessage(e));
                                }
                            }
                        }
                    });
                }
            }
        }
        if (this.maxErrorRate > 0 && this.tendCount % this.errorRateWindow == 0) {
            for (Node node : this.nodes) {
                node.resetErrorRate();
            }
        }
        if (this.metricsEnabled && this.tendCount % this.metricsPolicy.interval == 0) {
            this.metricsListener.onSnapshot(this);
        }
        this.processRecoverQueue();
    }

    private final boolean seedNode(Peers peers, boolean failIfNotConnected) {
        Host[] seedArray = this.seeds;
        Exception[] exceptions = null;
        NodeValidator nv = new NodeValidator();
        for (int i = 0; i < seedArray.length; ++i) {
            Host seed = seedArray[i];
            try {
                Node node = nv.seedNode(this, seed, peers);
                if (node == null) continue;
                this.addSeedAndPeers(node, peers);
                return true;
            }
            catch (Throwable e) {
                peers.fail(seed);
                if (seed.tlsName != null && this.tlsPolicy == null) {
                    throw new AerospikeException.Connection("Seed host tlsName '" + seed.tlsName + "' defined but client tlsPolicy not enabled", e);
                }
                if (failIfNotConnected) {
                    if (exceptions == null) {
                        exceptions = new Exception[seedArray.length];
                    }
                    exceptions[i] = e;
                    continue;
                }
                if (!Log.warnEnabled()) continue;
                Log.warn("Seed " + seed + " failed: " + Util.getErrorMessage(e));
            }
        }
        if (nv.fallback != null) {
            peers.refreshCount = 1;
            this.addSeedAndPeers(nv.fallback, peers);
            return true;
        }
        if (failIfNotConnected) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("Failed to connect to [" + seedArray.length + "] host(s): ");
            sb.append(System.lineSeparator());
            for (int i = 0; i < seedArray.length; ++i) {
                Exception ex;
                sb.append(seedArray[i]);
                sb.append(' ');
                Exception exception = ex = exceptions == null ? null : exceptions[i];
                if (ex == null) continue;
                sb.append(ex.getMessage());
                sb.append(System.lineSeparator());
            }
            throw new AerospikeException.Connection(sb.toString());
        }
        return false;
    }

    private void addSeedAndPeers(Node seed, Peers peers) {
        seed.createMinConnections();
        this.nodesMap.clear();
        this.addNodes(seed, peers);
        if (peers.nodes.size() > 0) {
            this.refreshPeers(peers);
        }
    }

    private void refreshPeers(Peers peers) {
        while (true) {
            Node[] nodeArray = new Node[peers.nodes.size()];
            int count = 0;
            for (Node node : peers.nodes.values()) {
                nodeArray[count++] = node;
            }
            peers.nodes.clear();
            for (Node node : nodeArray) {
                node.refreshPeers(peers);
            }
            if (peers.nodes.size() <= 0) break;
            this.addNodes(peers.nodes);
        }
    }

    protected Node createNode(NodeValidator nv) {
        Node node = new Node(this, nv);
        node.createMinConnections();
        return node;
    }

    private final ArrayList<Node> findNodesToRemove(int refreshCount) {
        ArrayList<Node> removeList = new ArrayList<Node>();
        for (Node node : this.nodes) {
            if (!node.isActive()) {
                removeList.add(node);
                continue;
            }
            if (refreshCount == 0 && node.failures >= 5) {
                removeList.add(node);
                continue;
            }
            if (this.nodes.length <= 1 || refreshCount < 1 || node.referenceCount != 0) continue;
            if (node.failures == 0) {
                if (this.findNodeInPartitionMap(node)) continue;
                removeList.add(node);
                continue;
            }
            removeList.add(node);
        }
        return removeList;
    }

    private final boolean findNodeInPartitionMap(Node filter) {
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max2 = nodeArray.length();
                for (int i = 0; i < max2; ++i) {
                    Node node = nodeArray.get(i);
                    if (node != filter) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void addNodes(Node seed, Peers peers) {
        Node[] nodeArray = new Node[peers.nodes.size() + 1];
        int count = 0;
        nodeArray[count++] = seed;
        this.addNode(seed);
        for (Node peer : peers.nodes.values()) {
            nodeArray[count++] = peer;
            this.addNode(peer);
        }
        this.hasPartitionQuery = Cluster.supportsPartitionQuery(nodeArray);
        this.nodes = nodeArray;
    }

    private final void addNodes(HashMap<String, Node> nodesToAdd) {
        Node[] nodeArray = new Node[this.nodes.length + nodesToAdd.size()];
        int count = 0;
        for (Node node : this.nodes) {
            nodeArray[count++] = node;
        }
        for (Node node : nodesToAdd.values()) {
            nodeArray[count++] = node;
            this.addNode(node);
        }
        this.hasPartitionQuery = Cluster.supportsPartitionQuery(nodeArray);
        this.nodes = nodeArray;
    }

    private final void addNode(Node node) {
        if (Log.infoEnabled()) {
            Log.info("Add node " + node);
        }
        this.nodesMap.put(node.getName(), node);
        for (Host alias : node.aliases) {
            this.aliases.put(alias, node);
        }
    }

    private final void removeNodes(List<Node> nodesToRemove) {
        for (Node node : nodesToRemove) {
            this.nodesMap.remove(node.getName());
            for (Host alias : node.aliases) {
                this.aliases.remove(alias);
            }
            if (this.metricsEnabled) {
                try {
                    this.metricsListener.onNodeClose(node);
                }
                catch (Throwable e) {
                    Log.warn("Write metrics failed on " + node + ": " + Util.getErrorMessage(e));
                }
            }
            node.close();
        }
        this.removeNodesCopy(nodesToRemove);
    }

    private final void removeNodesCopy(List<Node> nodesToRemove) {
        Node[] nodeArray = new Node[this.nodes.length - nodesToRemove.size()];
        int count = 0;
        for (Node node : this.nodes) {
            if (Cluster.findNode(node, nodesToRemove)) {
                if (!Log.infoEnabled()) continue;
                Log.info("Remove node " + node);
                continue;
            }
            nodeArray[count++] = node;
        }
        if (count < nodeArray.length) {
            if (Log.warnEnabled()) {
                Log.warn("Node remove mismatch. Expected " + nodeArray.length + " Received " + count);
            }
            Node[] nodeArray2 = new Node[count];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, count);
            nodeArray = nodeArray2;
        }
        this.hasPartitionQuery = Cluster.supportsPartitionQuery(nodeArray);
        this.nodes = nodeArray;
    }

    private static final boolean findNode(Node search, List<Node> nodeList) {
        for (Node node : nodeList) {
            if (!node.equals(search)) continue;
            return true;
        }
        return false;
    }

    public final boolean isConnected() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length > 0 && this.tendValid) {
            for (Node node : nodeArray) {
                if (!node.active || node.failures >= 5) continue;
                return true;
            }
        }
        return false;
    }

    public final Node getRandomNode() throws AerospikeException.InvalidNode {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length > 0) {
            int index2 = Math.abs(this.nodeIndex.getAndIncrement() % nodeArray.length);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[index2];
                if (node.isActive()) {
                    return node;
                }
                ++index2;
                index2 %= nodeArray.length;
            }
        }
        throw new AerospikeException.InvalidNode("Cluster is empty");
    }

    public final Node[] getNodes() {
        Node[] nodeArray = this.nodes;
        return nodeArray;
    }

    public final Node[] validateNodes() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length == 0) {
            throw new AerospikeException(-8, "Cluster is empty");
        }
        return nodeArray;
    }

    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        Node node = this.findNode(nodeName);
        if (node == null) {
            throw new AerospikeException.InvalidNode("Invalid node name: " + nodeName);
        }
        return node;
    }

    protected final Node findNode(String nodeName) {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public final boolean isConnCurrentTran(long lastUsed) {
        return this.maxSocketIdleNanosTran == 0L || System.nanoTime() - lastUsed <= this.maxSocketIdleNanosTran;
    }

    public final boolean isConnCurrentTrim(long lastUsed) {
        return System.nanoTime() - lastUsed <= this.maxSocketIdleNanosTrim;
    }

    public final void recoverConnection(ConnectionRecover cs) {
        if (cs.isComplete()) {
            return;
        }
        if (this.recoverCount.getAndIncrement() < 10000) {
            this.recoverQueue.offerLast(cs);
        } else {
            this.recoverCount.getAndDecrement();
            cs.abort();
        }
    }

    private void processRecoverQueue() {
        ConnectionRecover cs;
        byte[] buf = ThreadLocalData.getBuffer();
        ConnectionRecover last = this.recoverQueue.peekLast();
        while ((cs = this.recoverQueue.pollFirst()) != null) {
            if (cs.drain(buf)) {
                this.recoverCount.getAndDecrement();
            } else {
                this.recoverQueue.offerLast(cs);
            }
            if (cs != last) continue;
            break;
        }
    }

    public final void enableMetrics(MetricsPolicy policy) {
        Node[] nodeArray;
        MetricsListener listener;
        if (this.metricsEnabled) {
            this.metricsListener.onDisable(this);
        }
        if ((listener = policy.listener) == null) {
            listener = new MetricsWriter(policy.reportDir);
        }
        this.metricsListener = listener;
        this.metricsPolicy = policy;
        for (Node node : nodeArray = this.nodes) {
            node.enableMetrics(policy);
        }
        listener.onEnable(this, policy);
        this.metricsEnabled = true;
    }

    public final void disableMetrics() {
        if (this.metricsEnabled) {
            this.metricsEnabled = false;
            this.metricsListener.onDisable(this);
        }
    }

    public EventLoop[] getEventLoopArray() {
        if (this.eventLoops == null) {
            return null;
        }
        return this.eventLoops.getArray();
    }

    public final ClusterStats getStats() {
        final Node[] nodeArray = this.nodes;
        NodeStats[] nodeStats = new NodeStats[nodeArray.length];
        int count = 0;
        for (Node node : nodeArray) {
            nodeStats[count++] = new NodeStats(node);
        }
        EventLoopStats[] eventLoopStats = null;
        if (this.eventLoops != null) {
            EventLoop[] eventLoopArray;
            for (EventLoop eventLoop : eventLoopArray = this.eventLoops.getArray()) {
                int i;
                if (!eventLoop.inEventLoop()) continue;
                eventLoopStats = new EventLoopStats[eventLoopArray.length];
                for (i = 0; i < eventLoopArray.length; ++i) {
                    eventLoopStats[i] = new EventLoopStats(eventLoopArray[i]);
                }
                for (i = 0; i < nodeArray.length; ++i) {
                    nodeStats[i].async = nodeArray[i].getAsyncConnectionStats();
                }
                return new ClusterStats(this, nodeStats, eventLoopStats);
            }
            final EventLoopStats[] loopStats = new EventLoopStats[eventLoopArray.length];
            final ConnectionStats[][] connStats = new ConnectionStats[nodeArray.length][eventLoopArray.length];
            final AtomicInteger eventLoopCount = new AtomicInteger(eventLoopArray.length);
            final Monitor monitor = new Monitor();
            for (final EventLoop eventLoop : eventLoopArray) {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        int index2 = eventLoop.getIndex();
                        loopStats[index2] = new EventLoopStats(eventLoop);
                        for (int i = 0; i < nodeArray.length; ++i) {
                            Node.AsyncPool pool = nodeArray[i].getAsyncPool(index2);
                            int inPool = pool.queue.size();
                            connStats[i][index2] = new ConnectionStats(pool.total - inPool, inPool, pool.opened, pool.closed);
                        }
                        if (eventLoopCount.decrementAndGet() == 0) {
                            monitor.notifyComplete();
                        }
                    }
                });
            }
            monitor.waitTillComplete();
            eventLoopStats = loopStats;
            for (int i = 0; i < nodeArray.length; ++i) {
                int inUse = 0;
                int inPool = 0;
                int opened = 0;
                int closed = 0;
                for (EventLoop eventLoop : eventLoopArray) {
                    ConnectionStats cs = connStats[i][eventLoop.getIndex()];
                    inUse += cs.inUse;
                    inPool += cs.inPool;
                    opened += cs.opened;
                    closed += cs.closed;
                }
                nodeStats[i].async = new ConnectionStats(inUse, inPool, opened, closed);
            }
        }
        return new ClusterStats(this, nodeStats, eventLoopStats);
    }

    public final void getStats(final ClusterStatsListener listener) {
        try {
            final Node[] nodeArray = this.nodes;
            final NodeStats[] nodeStats = new NodeStats[nodeArray.length];
            int count = 0;
            for (Node node : nodeArray) {
                nodeStats[count++] = new NodeStats(node);
            }
            if (this.eventLoops == null) {
                try {
                    listener.onSuccess(new ClusterStats(this, nodeStats, null));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            final EventLoop[] eventLoopArray = this.eventLoops.getArray();
            final EventLoopStats[] loopStats = new EventLoopStats[eventLoopArray.length];
            final ConnectionStats[][] connStats = new ConnectionStats[nodeArray.length][eventLoopArray.length];
            final AtomicInteger eventLoopCount = new AtomicInteger(eventLoopArray.length);
            final Cluster cluster = this;
            for (final EventLoop eventLoop : eventLoopArray) {
                Runnable fetch = new Runnable(){

                    @Override
                    public void run() {
                        int inPool;
                        int i;
                        int index2 = eventLoop.getIndex();
                        loopStats[index2] = new EventLoopStats(eventLoop);
                        for (i = 0; i < nodeArray.length; ++i) {
                            Node.AsyncPool pool = nodeArray[i].getAsyncPool(index2);
                            inPool = pool.queue.size();
                            connStats[i][index2] = new ConnectionStats(pool.total - inPool, inPool, pool.opened, pool.closed);
                        }
                        if (eventLoopCount.decrementAndGet() == 0) {
                            for (i = 0; i < nodeArray.length; ++i) {
                                int inUse = 0;
                                inPool = 0;
                                int opened = 0;
                                int closed = 0;
                                for (EventLoop eventLoop2 : eventLoopArray) {
                                    ConnectionStats cs = connStats[i][eventLoop2.getIndex()];
                                    inUse += cs.inUse;
                                    inPool += cs.inPool;
                                    opened += cs.opened;
                                    closed += cs.closed;
                                }
                                nodeStats[i].async = new ConnectionStats(inUse, inPool, opened, closed);
                            }
                            try {
                                listener.onSuccess(new ClusterStats(cluster, nodeStats, loopStats));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                };
                if (eventLoop.inEventLoop()) {
                    fetch.run();
                    continue;
                }
                eventLoop.execute(fetch);
            }
        }
        catch (AerospikeException ae) {
            listener.onFailure(ae);
        }
        catch (Throwable e) {
            listener.onFailure(new AerospikeException(e));
        }
    }

    public final void interruptTendSleep() {
        this.tendThread.interrupt();
    }

    public final void printPartitionMap() {
        for (Map.Entry<String, Partitions> entry : this.partitionMap.entrySet()) {
            String namespace = entry.getKey();
            Partitions partitions = entry.getValue();
            AtomicReferenceArray<Node>[] replicas = partitions.replicas;
            for (int i = 0; i < replicas.length; ++i) {
                AtomicReferenceArray<Node> nodeArray = replicas[i];
                int max2 = nodeArray.length();
                for (int j = 0; j < max2; ++j) {
                    Node node = nodeArray.get(j);
                    if (node == null) continue;
                    Log.info(namespace + ',' + i + ',' + j + ',' + node);
                }
            }
        }
    }

    public void changePassword(byte[] user, byte[] password, byte[] passwordHash) {
        if (this.user != null && Arrays.equals(user, this.user)) {
            this.passwordHash = passwordHash;
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = password;
            }
        }
    }

    public final void setMaxErrorRate(int rate) {
        this.maxErrorRate = rate;
    }

    public final void setErrorRateWindow(int window) {
        this.errorRateWindow = window;
    }

    private static boolean supportsPartitionQuery(Node[] nodes) {
        if (nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (node.hasPartitionQuery()) continue;
            return false;
        }
        return true;
    }

    public final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean validateClusterName() {
        return this.validateClusterName && this.clusterName != null && this.clusterName.length() > 0;
    }

    public final byte[] getUser() {
        return this.user;
    }

    public final byte[] getPassword() {
        return this.password;
    }

    public final byte[] getPasswordHash() {
        return this.passwordHash;
    }

    public final boolean isActive() {
        return this.tendValid;
    }

    public final void addTran() {
        if (this.metricsEnabled) {
            this.tranCount.getAndIncrement();
        }
    }

    public final long getTranCount() {
        return this.tranCount.get();
    }

    public final void addRetry() {
        this.retryCount.getAndIncrement();
    }

    public final void addRetries(int count) {
        this.retryCount.getAndAdd(count);
    }

    public final long getRetryCount() {
        return this.retryCount.get();
    }

    public final void addDelayQueueTimeout() {
        this.delayQueueTimeoutCount.getAndIncrement();
    }

    public final long getDelayQueueTimeoutCount() {
        return this.delayQueueTimeoutCount.get();
    }

    public final int getThreadsInUse() {
        if (this.threadPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.threadPool;
            return tpe.getActiveCount();
        }
        return 0;
    }

    public final int getRecoverQueueSize() {
        return this.recoverCount.get();
    }

    public final int getInvalidNodeCount() {
        return this.invalidNodeCount;
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.tendValid = false;
        this.tendThread.interrupt();
        if (!this.sharedThreadPool) {
            this.threadPool.shutdown();
        }
        try {
            this.disableMetrics();
        }
        catch (Throwable e) {
            Log.warn("DisableMetrics failed: " + Util.getErrorMessage(e));
        }
        if (this.eventLoops == null) {
            Node[] nodeArray;
            for (Node node : nodeArray = this.nodes) {
                node.closeSyncConnections();
            }
        } else {
            final long deadline = this.closeTimeout > 0 ? System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.closeTimeout) : 0L;
            final AtomicInteger eventLoopCount = new AtomicInteger(this.eventState.length);
            final AtomicBoolean closedWithPending = new AtomicBoolean();
            boolean inEventLoop = false;
            for (final EventState state : this.eventState) {
                if (state.eventLoop.inEventLoop()) {
                    inEventLoop = true;
                }
                state.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (state.closed) {
                            return;
                        }
                        if (state.pending > 0) {
                            if (Cluster.this.closeTimeout >= 0 && (Cluster.this.closeTimeout == 0 || deadline - System.nanoTime() > 0L)) {
                                state.eventLoop.schedule(this, 200L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            closedWithPending.set(true);
                        }
                        Cluster.this.closeEventLoop(eventLoopCount, state);
                    }
                });
            }
            if (!inEventLoop) {
                this.waitAsyncComplete();
            }
            if (closedWithPending.get()) {
                Log.warn("Cluster closed with pending async commands");
            }
        }
    }

    private final void closeEventLoop(AtomicInteger eventLoopCount, EventState state) {
        Node[] nodeArray;
        state.closed = true;
        for (Node node : nodeArray = this.nodes) {
            node.closeAsyncConnections(state.index);
        }
        if (eventLoopCount.decrementAndGet() == 0) {
            for (Node node : nodeArray) {
                node.closeSyncConnections();
            }
            this.notifyAsyncComplete();
        }
    }

    private synchronized void waitAsyncComplete() {
        while (!this.asyncComplete) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyAsyncComplete() {
        this.asyncComplete = true;
        super.notify();
    }
}

