/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.Log;

public final class ThreadLocalData {
    public static int DefaultBufferSize = 8192;
    private static final int THREAD_LOCAL_CUTOFF = 131072;
    private static final ThreadLocal<byte[]> BufferThreadLocal = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[DefaultBufferSize];
        }
    };

    public static byte[] getBuffer() {
        return BufferThreadLocal.get();
    }

    public static byte[] resizeBuffer(int size) {
        if (size > 131072) {
            if (Log.debugEnabled()) {
                Log.debug("Thread " + Thread.currentThread().getName() + " allocate buffer on heap " + size);
            }
            return new byte[size];
        }
        if (Log.debugEnabled()) {
            Log.debug("Thread " + Thread.currentThread().getName() + " resize buffer to " + size);
        }
        BufferThreadLocal.set(new byte[size]);
        return BufferThreadLocal.get();
    }
}

