/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.InfoPolicy;

public final class Version {
    private final int major;
    private final int minor;
    private final int revision;
    private final String extension;

    public static Version getServerVersion(IAerospikeClient client, InfoPolicy policy) {
        Node node = client.getCluster().getRandomNode();
        return Version.getServerVersion(policy, node);
    }

    public static Version getServerVersion(InfoPolicy policy, Node node) {
        String response = Info.request(policy, node, "build");
        return new Version(response);
    }

    public Version(String version) {
        int begin;
        int i;
        int max2 = version.length();
        for (i = begin = 0; i < max2 && Character.isDigit(version.charAt(i)); ++i) {
        }
        this.major = i > begin ? Integer.parseInt(version.substring(begin, i)) : 0;
        begin = ++i;
        while (i < max2 && Character.isDigit(version.charAt(i))) {
            ++i;
        }
        this.minor = i > begin ? Integer.parseInt(version.substring(begin, i)) : 0;
        begin = ++i;
        while (i < max2 && Character.isDigit(version.charAt(i))) {
            ++i;
        }
        this.revision = i > begin ? Integer.parseInt(version.substring(begin, i)) : 0;
        begin = i;
        this.extension = begin < max2 ? version.substring(begin) : "";
    }

    public boolean isGreaterEqual(int v1, int v2, int v3) {
        return this.major > v1 || this.major == v1 && (this.minor > v2 || this.minor == v2 && this.revision >= v3);
    }

    public boolean isLess(int v1, int v2, int v3) {
        return this.major < v1 || this.major == v1 && (this.minor < v2 || this.minor == v2 && this.revision < v3);
    }

    public String toString() {
        return Integer.toString(this.major) + "." + this.minor + "." + this.revision + this.extension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.major == other.major && this.minor == other.minor && this.revision == other.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.revision;
        return result;
    }
}

