/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncBatch;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchOperateListListener;
import com.aerospike.client.listener.BatchRecordArrayListener;
import com.aerospike.client.listener.BatchRecordSequenceListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordSequenceListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AsyncBatchExecutor
implements BatchNodeList.IBatchStatus {
    final EventLoop eventLoop;
    final Cluster cluster;
    private ArrayList<AerospikeException> subExceptions;
    private AerospikeException exception;
    private AsyncCommand[] commands;
    private int completedCount;
    private final boolean hasResultCode;
    boolean done;
    boolean error;

    protected AsyncBatchExecutor(EventLoop eventLoop, Cluster cluster, boolean hasResultCode) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
        this.hasResultCode = hasResultCode;
        cluster.addTran();
    }

    public void execute(AsyncCommand[] cmds) {
        this.commands = cmds;
        for (AsyncCommand cmd : cmds) {
            this.eventLoop.execute(this.cluster, cmd);
        }
    }

    public void executeBatchRetry(AsyncBatch.AsyncBatchCommand[] cmds, AsyncBatch.AsyncBatchCommand orig, Runnable other, long deadline) {
        AsyncCommand[] target = new AsyncCommand[this.commands.length + cmds.length - 1];
        int count = 0;
        for (AsyncCommand asyncCommand : this.commands) {
            if (asyncCommand == orig) continue;
            target[count++] = asyncCommand;
        }
        for (AsyncCommand asyncCommand : cmds) {
            target[count++] = asyncCommand;
        }
        this.commands = target;
        for (AsyncCommand asyncCommand : cmds) {
            this.eventLoop.executeBatchRetry(other, asyncCommand, deadline);
        }
    }

    final void childSuccess() {
        if (++this.completedCount == this.commands.length && !this.done) {
            this.done = true;
            if (this.exception == null) {
                this.onSuccess();
            } else {
                this.exception.setSubExceptions(this.subExceptions);
                this.onFailure(this.exception);
            }
        }
    }

    final void childFailure(AerospikeException ae) {
        if (this.exception == null) {
            this.exception = ae;
        }
        this.childSuccess();
    }

    @Override
    public void batchKeyError(Key key, int index2, AerospikeException ae, boolean inDoubt, boolean hasWrite) {
    }

    @Override
    public void batchKeyError(AerospikeException e) {
        this.error = true;
        if (!this.hasResultCode && this.exception == null) {
            this.exception = e;
        }
    }

    public void setRowError() {
        this.error = true;
    }

    public void addSubException(AerospikeException ae) {
        if (this.subExceptions == null) {
            this.subExceptions = new ArrayList();
        }
        this.subExceptions.add(ae);
    }

    public boolean getStatus() {
        return !this.error;
    }

    abstract void onSuccess();

    abstract void onFailure(AerospikeException var1);

    public static final class OperateSequence
    extends AsyncBatchExecutor {
        private final BatchRecordSequenceListener listener;

        public OperateSequence(EventLoop eventLoop, Cluster cluster, BatchRecordSequenceListener listener) {
            super(eventLoop, cluster, true);
            this.listener = listener;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class OperateList
    extends AsyncBatchExecutor {
        private final BatchOperateListListener listener;
        private final List<BatchRecord> records;

        public OperateList(EventLoop eventLoop, Cluster cluster, BatchOperateListListener listener, List<BatchRecord> records) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records, this.getStatus());
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class GetSequence
    extends AsyncBatchExecutor {
        private final RecordSequenceListener listener;

        public GetSequence(EventLoop eventLoop, Cluster cluster, RecordSequenceListener listener) {
            super(eventLoop, cluster, false);
            this.listener = listener;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class GetArray
    extends AsyncBatchExecutor {
        private final RecordArrayListener listener;
        private final Key[] keys;
        private final Record[] records;

        public GetArray(EventLoop eventLoop, Cluster cluster, RecordArrayListener listener, Key[] keys, Record[] records) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            this.keys = keys;
            this.records = records;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.records);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(new AerospikeException.BatchRecords(this.records, (Throwable)ae));
        }
    }

    public static final class ReadSequence
    extends AsyncBatchExecutor {
        private final BatchSequenceListener listener;

        public ReadSequence(EventLoop eventLoop, Cluster cluster, BatchSequenceListener listener) {
            super(eventLoop, cluster, true);
            this.listener = listener;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class ReadList
    extends AsyncBatchExecutor {
        private final BatchListListener listener;
        private final List<BatchRead> records;

        public ReadList(EventLoop eventLoop, Cluster cluster, BatchListListener listener, List<BatchRead> records) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class ExistsSequence
    extends AsyncBatchExecutor {
        private final ExistsSequenceListener listener;

        public ExistsSequence(EventLoop eventLoop, Cluster cluster, ExistsSequenceListener listener) {
            super(eventLoop, cluster, false);
            this.listener = listener;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class ExistsArray
    extends AsyncBatchExecutor {
        private final ExistsArrayListener listener;
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArray(EventLoop eventLoop, Cluster cluster, ExistsArrayListener listener, Key[] keys, boolean[] existsArray) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.existsArray);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(new AerospikeException.BatchExists(this.existsArray, (Throwable)ae));
        }
    }

    public static final class BatchRecordSequence
    extends AsyncBatchExecutor {
        private final BatchRecordSequenceListener listener;
        private final boolean[] sent;

        public BatchRecordSequence(EventLoop eventLoop, Cluster cluster, BatchRecordSequenceListener listener, boolean[] sent) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.sent = sent;
        }

        public void setSent(int index2) {
            this.sent[index2] = true;
        }

        public boolean exchangeSent(int index2) {
            boolean prev = this.sent[index2];
            this.sent[index2] = true;
            return prev;
        }

        @Override
        public void batchKeyError(Key key, int index2, AerospikeException ae, boolean inDoubt, boolean hasWrite) {
            this.sent[index2] = true;
            BatchRecord record = new BatchRecord(key, null, ae.getResultCode(), inDoubt, hasWrite);
            AsyncBatch.onRecord(this.listener, record, index2);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class BatchRecordArray
    extends AsyncBatchExecutor {
        private final BatchRecordArrayListener listener;
        private final BatchRecord[] records;

        public BatchRecordArray(EventLoop eventLoop, Cluster cluster, BatchRecordArrayListener listener, BatchRecord[] records) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records, this.getStatus());
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(this.records, ae);
        }
    }
}

