/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Statement;

public final class AsyncQuery
extends AsyncMultiCommand {
    private final AsyncMultiExecutor parent;
    private final RecordSequenceListener listener;
    private final Statement statement;
    private final long taskId;

    public AsyncQuery(AsyncMultiExecutor parent, Node node, QueryPolicy policy, RecordSequenceListener listener, Statement statement, long taskId) {
        super(node, policy, policy.socketTimeout, policy.totalTimeout);
        this.parent = parent;
        this.listener = listener;
        this.statement = statement;
        this.taskId = taskId;
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.QUERY;
    }

    @Override
    protected void writeBuffer() {
        this.setQuery(this.parent.cluster, this.policy, this.statement, this.taskId, false, null);
    }

    @Override
    protected void parseRow() {
        Key key = this.parseKey(this.fieldCount, null);
        if (this.resultCode != 0) {
            throw new AerospikeException(this.resultCode);
        }
        Record record = this.parseRecord();
        this.listener.onRecord(key, record);
    }

    @Override
    protected void onSuccess() {
        this.parent.childSuccess(this.node);
    }

    @Override
    protected void onFailure(AerospikeException e) {
        this.parent.childFailure(e);
    }
}

