/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.WritePolicy;

public final class AsyncTouch
extends AsyncCommand {
    private final WriteListener listener;
    private final WritePolicy writePolicy;
    private final Key key;
    private final Partition partition;

    public AsyncTouch(Cluster cluster, WriteListener listener, WritePolicy writePolicy, Key key) {
        super(writePolicy, true);
        this.listener = listener;
        this.writePolicy = writePolicy;
        this.key = key;
        this.partition = Partition.write(cluster, writePolicy, key);
        cluster.addTran();
    }

    @Override
    boolean isWrite() {
        return true;
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.partition.getNodeWrite(cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.WRITE;
    }

    @Override
    protected void writeBuffer() {
        this.setTouch(this.writePolicy, this.key);
    }

    @Override
    protected boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[5] & 0xFF;
        if (resultCode == 0) {
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

