/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.EventLoopType;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.NettyEventLoop;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public final class NettyEventLoops
implements EventLoops {
    private final Map<EventExecutor, NettyEventLoop> eventLoopMap;
    private final NettyEventLoop[] eventLoopArray;
    private final EventLoopGroup group;
    final EventLoopType eventLoopType;
    private int eventIter;

    public NettyEventLoops(EventLoopGroup group) {
        this(new EventPolicy(), group);
    }

    public NettyEventLoops(EventPolicy policy, EventLoopGroup group) {
        this(policy, group, NettyEventLoops.getEventLoopType(group));
    }

    public NettyEventLoops(EventPolicy policy, EventLoopGroup group, EventLoopType type2) {
        if (policy.minTimeout < 5) {
            throw new AerospikeException("Invalid minTimeout " + policy.minTimeout + ". Must be at least 5ms.");
        }
        this.group = group;
        this.eventLoopType = type2;
        ArrayList<NettyEventLoop> list = new ArrayList<NettyEventLoop>();
        Iterator iter = group.iterator();
        int count = 0;
        while (iter.hasNext()) {
            EventExecutor eventExecutor = (EventExecutor)iter.next();
            list.add(new NettyEventLoop(policy, (EventLoop)eventExecutor, this, count++));
        }
        this.eventLoopArray = list.toArray(new NettyEventLoop[count]);
        this.eventLoopMap = new IdentityHashMap<EventExecutor, NettyEventLoop>(count);
        for (final NettyEventLoop eventLoop : this.eventLoopArray) {
            this.eventLoopMap.put((EventExecutor)eventLoop.eventLoop, eventLoop);
        }
        for (final NettyEventLoop eventLoop : this.eventLoopArray) {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    eventLoop.timer.start();
                }
            });
        }
    }

    private static EventLoopType getEventLoopType(EventLoopGroup group) {
        try {
            if (group instanceof NioEventLoopGroup) {
                return EventLoopType.NETTY_NIO;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (group instanceof EpollEventLoopGroup) {
                return EventLoopType.NETTY_EPOLL;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (group instanceof KQueueEventLoopGroup) {
                return EventLoopType.NETTY_KQUEUE;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (group instanceof IOUringEventLoopGroup) {
                return EventLoopType.NETTY_IOURING;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        throw new AerospikeException("Unexpected EventLoopGroup");
    }

    public Class<? extends SocketChannel> getSocketChannelClass() {
        switch (this.eventLoopType) {
            default: {
                return NioSocketChannel.class;
            }
            case NETTY_EPOLL: {
                return EpollSocketChannel.class;
            }
            case NETTY_KQUEUE: {
                return KQueueSocketChannel.class;
            }
            case NETTY_IOURING: 
        }
        return IOUringSocketChannel.class;
    }

    public NettyEventLoop get(EventExecutor eventExecutor) {
        return this.eventLoopMap.get(eventExecutor);
    }

    public NettyEventLoop[] getArray() {
        return this.eventLoopArray;
    }

    @Override
    public int getSize() {
        return this.eventLoopArray.length;
    }

    @Override
    public NettyEventLoop get(int index2) {
        return this.eventLoopArray[index2];
    }

    @Override
    public NettyEventLoop next() {
        int iter = this.eventIter++;
        if ((iter %= this.eventLoopArray.length) < 0) {
            iter += this.eventLoopArray.length;
        }
        return this.eventLoopArray[iter];
    }

    @Override
    public void close() {
        this.group.shutdownGracefully();
    }
}

