/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Replica;
import java.util.ArrayList;
import java.util.List;

public final class BatchNodeList {
    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, Key[] keys, BatchRecord[] records, boolean hasWrite, IBatchStatus status2) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = keys.length / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException except = null;
        for (int i = 0; i < keys.length; ++i) {
            Key key = keys[i];
            try {
                Node node = hasWrite ? Partition.getNodeBatchWrite(cluster, key, replica, null, 0) : Partition.getNodeBatchRead(cluster, key, replica, replicaSC, null, 0, 0);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, i));
                    continue;
                }
                batchNode.addKey(i);
                continue;
            }
            catch (AerospikeException ae) {
                if (records != null) {
                    records[i].setError(ae.getResultCode(), false);
                } else {
                    status2.batchKeyError(key, i, ae, false, hasWrite);
                }
                if (except != null) continue;
                except = ae;
            }
        }
        if (except != null) {
            if (batchNodes.size() == 0) {
                throw except;
            }
            status2.batchKeyError(except);
        }
        return batchNodes;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, Key[] keys, BatchRecord[] records, int sequenceAP, int sequenceSC, BatchNode batchSeed, boolean hasWrite, IBatchStatus status2) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException except = null;
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            if (records[offset].resultCode != -15) continue;
            Key key = keys[offset];
            try {
                Node node = hasWrite ? Partition.getNodeBatchWrite(cluster, key, replica, batchSeed.node, sequenceAP) : Partition.getNodeBatchRead(cluster, key, replica, replicaSC, batchSeed.node, sequenceAP, sequenceSC);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, offset));
                    continue;
                }
                batchNode.addKey(offset);
                continue;
            }
            catch (AerospikeException ae) {
                records[offset].setError(ae.getResultCode(), Command.batchInDoubt(hasWrite, 2));
                if (except != null) continue;
                except = ae;
            }
        }
        if (except != null) {
            status2.batchKeyError(except);
        }
        return batchNodes;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, Key[] keys, boolean[] sent, int sequenceAP, int sequenceSC, BatchNode batchSeed, boolean hasWrite, IBatchStatus status2) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException except = null;
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            if (sent[offset]) continue;
            Key key = keys[offset];
            try {
                Node node = hasWrite ? Partition.getNodeBatchWrite(cluster, key, replica, batchSeed.node, sequenceAP) : Partition.getNodeBatchRead(cluster, key, replica, replicaSC, batchSeed.node, sequenceAP, sequenceSC);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, offset));
                    continue;
                }
                batchNode.addKey(offset);
                continue;
            }
            catch (AerospikeException ae) {
                status2.batchKeyError(key, offset, ae, Command.batchInDoubt(hasWrite, 2), hasWrite);
                if (except != null) continue;
                except = ae;
            }
        }
        if (except != null) {
            status2.batchKeyError(except);
        }
        return batchNodes;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, Key[] keys, int sequenceAP, int sequenceSC, BatchNode batchSeed, boolean hasWrite, IBatchStatus status2) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException except = null;
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            Key key = keys[offset];
            try {
                Node node = hasWrite ? Partition.getNodeBatchWrite(cluster, key, replica, batchSeed.node, sequenceAP) : Partition.getNodeBatchRead(cluster, key, replica, replicaSC, batchSeed.node, sequenceAP, sequenceSC);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, offset));
                    continue;
                }
                batchNode.addKey(offset);
                continue;
            }
            catch (AerospikeException ae) {
                if (except != null) continue;
                except = ae;
            }
        }
        if (except != null) {
            status2.batchKeyError(except);
        }
        return batchNodes;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, List<? extends BatchRecord> records, IBatchStatus status2) {
        Node[] nodes = cluster.validateNodes();
        int max2 = records.size();
        int keysPerNode = max2 / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException except = null;
        for (int i = 0; i < max2; ++i) {
            BatchRecord b = records.get(i);
            try {
                b.prepare();
                Node node = b.hasWrite ? Partition.getNodeBatchWrite(cluster, b.key, replica, null, 0) : Partition.getNodeBatchRead(cluster, b.key, replica, replicaSC, null, 0, 0);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, i));
                    continue;
                }
                batchNode.addKey(i);
                continue;
            }
            catch (AerospikeException ae) {
                b.setError(ae.getResultCode(), false);
                if (except != null) continue;
                except = ae;
            }
        }
        if (except != null) {
            if (batchNodes.size() == 0) {
                throw except;
            }
            status2.batchKeyError(except);
        }
        return batchNodes;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, List<? extends BatchRecord> records, int sequenceAP, int sequenceSC, BatchNode batchSeed, IBatchStatus status2) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException except = null;
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            BatchRecord b = records.get(offset);
            if (b.resultCode != -15) continue;
            try {
                Node node = b.hasWrite ? Partition.getNodeBatchWrite(cluster, b.key, replica, batchSeed.node, sequenceAP) : Partition.getNodeBatchRead(cluster, b.key, replica, replicaSC, batchSeed.node, sequenceAP, sequenceSC);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, offset));
                    continue;
                }
                batchNode.addKey(offset);
                continue;
            }
            catch (AerospikeException ae) {
                b.setError(ae.getResultCode(), Command.batchInDoubt(b.hasWrite, 2));
                if (except != null) continue;
                except = ae;
            }
        }
        if (except != null) {
            status2.batchKeyError(except);
        }
        return batchNodes;
    }

    private static BatchNode findBatchNode(List<BatchNode> nodes, Node node) {
        for (BatchNode batchNode : nodes) {
            if (batchNode.node != node) continue;
            return batchNode;
        }
        return null;
    }

    public static interface IBatchStatus {
        public void batchKeyError(Key var1, int var2, AerospikeException var3, boolean var4, boolean var5);

        public void batchKeyError(AerospikeException var1);
    }
}

