/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class DeleteCommand
extends SyncCommand {
    private final WritePolicy writePolicy;
    private final Key key;
    private final Partition partition;
    private boolean existed;

    public DeleteCommand(Cluster cluster, WritePolicy writePolicy, Key key) {
        super(cluster, writePolicy);
        this.writePolicy = writePolicy;
        this.key = key;
        this.partition = Partition.write(cluster, writePolicy, key);
        cluster.addTran();
    }

    @Override
    protected boolean isWrite() {
        return true;
    }

    @Override
    protected Node getNode() {
        return this.partition.getNodeWrite(this.cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.WRITE;
    }

    @Override
    protected void writeBuffer() {
        this.setDelete(this.writePolicy, this.key);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        RecordParser rp = new RecordParser(conn, this.dataBuffer);
        if (rp.resultCode == 0) {
            this.existed = true;
            return;
        }
        if (rp.resultCode == 2) {
            this.existed = false;
            return;
        }
        if (rp.resultCode == 27) {
            if (this.writePolicy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            this.existed = true;
            return;
        }
        throw new AerospikeException(rp.resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }

    public boolean existed() {
        return this.existed;
    }
}

