/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.exp;

import com.aerospike.client.command.Command;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.util.Crypto;
import com.aerospike.client.util.Packer;
import java.io.Serializable;
import java.util.Arrays;

public final class Expression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] bytes;

    Expression(Exp exp2) {
        Packer packer = new Packer();
        exp2.pack(packer);
        this.bytes = packer.toByteArray();
    }

    Expression(byte[] bytes) {
        this.bytes = bytes;
    }

    public static Expression fromBytes(byte[] bytes) {
        return new Expression(bytes);
    }

    public static Expression fromBase64(byte[] bytes) {
        return Expression.fromBytes(Crypto.decodeBase64(bytes, 0, bytes.length));
    }

    public static Expression fromBase64(String s) {
        return Expression.fromBase64(s.getBytes());
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getBase64() {
        return Crypto.encodeBase64(this.bytes);
    }

    public int size() {
        return this.bytes.length + 5;
    }

    public void write(Command cmd) {
        cmd.writeExpHeader(this.bytes.length);
        System.arraycopy(this.bytes, 0, cmd.dataBuffer, cmd.dataOffset, this.bytes.length);
        cmd.dataOffset += this.bytes.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

