/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaData;
import com.aerospike.client.lua.LuaInstance;
import org.luaj.vm2.LuaUserdata;

public final class LuaBytes
extends LuaUserdata
implements LuaData {
    private LuaInstance instance;
    private byte[] bytes;
    private int length;
    private int type;

    public LuaBytes(LuaInstance instance, int capacity) {
        super(new byte[capacity]);
        this.instance = instance;
        this.bytes = (byte[])this.m_instance;
        this.setmetatable(instance.getPackage("Bytes"));
    }

    public LuaBytes(LuaInstance instance, byte[] bytes) {
        this(instance, bytes, 4);
    }

    public LuaBytes(LuaInstance instance, byte[] bytes, int type2) {
        super(bytes);
        this.bytes = bytes;
        this.length = bytes.length;
        this.type = type2;
        this.setmetatable(instance.getPackage("Bytes"));
    }

    public int size() {
        return this.length;
    }

    @Override
    public String toString() {
        return Buffer.bytesToHexString(this.bytes, 0, this.length);
    }

    public byte getByte(int offset) {
        return offset >= 0 && offset < this.length ? this.bytes[offset] : (byte)0;
    }

    public void setByte(int offset, byte b) {
        int capacity = offset + 1;
        this.ensureCapacity(capacity);
        this.bytes[offset] = b;
        this.resetSize(capacity);
    }

    public void setCapacity(int capacity) {
        if (this.bytes.length == capacity) {
            return;
        }
        byte[] target = new byte[capacity];
        if (this.length > capacity) {
            this.length = capacity;
        }
        System.arraycopy(this.bytes, 0, target, 0, this.length);
        this.bytes = target;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    public String getString(int offset, int len2) {
        if (offset < 0 || offset >= this.length) {
            return "";
        }
        if (offset + len2 > this.length) {
            len2 = this.length - offset;
        }
        return Buffer.utf8ToString(this.bytes, offset, len2);
    }

    public LuaBytes getBytes(int offset, int len2) {
        if (offset < 0 || offset >= this.length) {
            return new LuaBytes(this.instance, new byte[0]);
        }
        if (offset + len2 > this.length) {
            len2 = this.length - offset;
        }
        byte[] target = new byte[len2];
        System.arraycopy(this.bytes, offset, target, 0, len2);
        return new LuaBytes(this.instance, target);
    }

    public int getBigInt16(int offset) {
        if (offset < 0 || offset > this.length) {
            return 0;
        }
        return Buffer.bytesToShort(this.bytes, offset);
    }

    public int getLittleInt16(int offset) {
        if (offset < 0 || offset > this.length) {
            return 0;
        }
        return Buffer.littleBytesToShort(this.bytes, offset);
    }

    public int getBigInt32(int offset) {
        if (offset < 0 || offset + 4 > this.length) {
            return 0;
        }
        return Buffer.bytesToInt(this.bytes, offset);
    }

    public int getLittleInt32(int offset) {
        if (offset < 0 || offset + 4 > this.length) {
            return 0;
        }
        return Buffer.littleBytesToInt(this.bytes, offset);
    }

    public long getBigInt64(int offset) {
        if (offset < 0 || offset + 8 > this.length) {
            return 0L;
        }
        return Buffer.bytesToLong(this.bytes, offset);
    }

    public long getLittleInt64(int offset) {
        if (offset < 0 || offset + 8 > this.length) {
            return 0L;
        }
        return Buffer.littleBytesToLong(this.bytes, offset);
    }

    public int[] getVarInt(int offset) {
        if (offset < 0 || offset > this.bytes.length) {
            return new int[]{0, 0};
        }
        return Buffer.varBytesToInt(this.bytes, offset);
    }

    public void setString(int offset, String value) {
        int len2 = Buffer.estimateSizeUtf8(value);
        this.ensureCapacity(offset + len2);
        len2 = Buffer.stringToUtf8(value, this.bytes, offset);
        this.resetSize(offset + len2);
    }

    public void setBytes(int offset, LuaBytes src, int len2) {
        if (len2 == 0 || len2 > src.length) {
            len2 = src.length;
        }
        int capacity = offset + this.length;
        this.ensureCapacity(capacity);
        System.arraycopy(src.bytes, 0, this.bytes, offset, len2);
        this.resetSize(capacity);
    }

    public void setBigInt16(int offset, int value) {
        int capacity = offset + 2;
        this.ensureCapacity(capacity);
        Buffer.shortToBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setLittleInt16(int offset, int value) {
        int capacity = offset + 2;
        this.ensureCapacity(capacity);
        Buffer.shortToLittleBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setBigInt32(int offset, int value) {
        int capacity = offset + 4;
        this.ensureCapacity(capacity);
        Buffer.intToBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setLittleInt32(int offset, int value) {
        int capacity = offset + 4;
        this.ensureCapacity(capacity);
        Buffer.intToLittleBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setBigInt64(int offset, long value) {
        int capacity = offset + 8;
        this.ensureCapacity(capacity);
        Buffer.longToBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public void setLittleInt64(int offset, long value) {
        int capacity = offset + 8;
        this.ensureCapacity(capacity);
        Buffer.longToLittleBytes(value, this.bytes, offset);
        this.resetSize(capacity);
    }

    public int setVarInt(int offset, int value) {
        this.ensureCapacity(offset + 5);
        int len2 = Buffer.intToVarBytes(value, this.bytes, offset);
        this.resetSize(offset + len2);
        return len2;
    }

    public void appendString(String value) {
        this.setString(this.length, value);
    }

    public void appendBigInt16(int value) {
        this.setBigInt16(this.length, value);
    }

    public void appendLittleInt16(int value) {
        this.setLittleInt16(this.length, value);
    }

    public void appendBigInt32(int value) {
        this.setBigInt32(this.length, value);
    }

    public void appendLittleInt32(int value) {
        this.setLittleInt32(this.length, value);
    }

    public void appendBigInt64(long value) {
        this.setBigInt64(this.length, value);
    }

    public void appendLittleInt64(long value) {
        this.setLittleInt64(this.length, value);
    }

    public int appendVarInt(int value) {
        return this.setVarInt(this.length, value);
    }

    public void appendBytes(LuaBytes source, int len2) {
        this.setBytes(this.length, source, len2);
    }

    public void appendByte(byte value) {
        this.setByte(this.length, value);
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.bytes.length) {
            int len2 = this.bytes.length * 2;
            if (capacity > len2) {
                len2 = capacity;
            }
            byte[] target = new byte[len2];
            System.arraycopy(this.bytes, 0, target, 0, this.length);
            this.bytes = target;
        }
    }

    private void resetSize(int capacity) {
        if (capacity > this.length) {
            this.length = capacity;
        }
    }

    @Override
    public Object luaToObject() {
        return this.bytes;
    }
}

