/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.metrics;

import java.util.concurrent.atomic.AtomicLong;

public final class LatencyBuckets {
    private static final long NS_TO_MS = 1000000L;
    private final AtomicLong[] buckets;
    private final int latencyShift;

    public LatencyBuckets(int latencyColumns, int latencyShift) {
        this.latencyShift = latencyShift;
        this.buckets = new AtomicLong[latencyColumns];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new AtomicLong();
        }
    }

    public int getMax() {
        return this.buckets.length;
    }

    public long getBucket(int i) {
        return this.buckets[i].get();
    }

    public void add(long elapsed) {
        int index2 = this.getIndex(elapsed);
        this.buckets[index2].getAndIncrement();
    }

    private int getIndex(long elapsedNanos) {
        long elapsed = elapsedNanos / 1000000L;
        if (elapsedNanos - elapsed * 1000000L > 0L) {
            ++elapsed;
        }
        int lastBucket = this.buckets.length - 1;
        long limit = 1L;
        for (int i = 0; i < lastBucket; ++i) {
            if (elapsed <= limit) {
                return i;
            }
            limit <<= this.latencyShift;
        }
        return lastBucket;
    }
}

