/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public class ReadHeaderCommand
extends SyncCommand {
    private final Key key;
    private final Partition partition;
    private Record record;

    public ReadHeaderCommand(Cluster cluster, Policy policy, Key key) {
        super(cluster, policy);
        this.key = key;
        this.partition = Partition.read(cluster, policy, key);
        cluster.addTran();
    }

    @Override
    protected Node getNode() {
        return this.partition.getNodeRead(this.cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.READ;
    }

    @Override
    protected void writeBuffer() {
        this.setReadHeader(this.policy, this.key);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        RecordParser rp = new RecordParser(conn, this.dataBuffer);
        if (rp.resultCode == 0) {
            this.record = new Record(null, rp.generation, rp.expiration);
            return;
        }
        if (rp.resultCode == 2) {
            return;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            return;
        }
        throw new AerospikeException(rp.resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    public Record getRecord() {
        return this.record;
    }
}

