/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.exp;

import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.operation.HLLPolicy;
import com.aerospike.client.util.Pack;

public final class HLLExp {
    private static final int MODULE = 2;
    private static final int INIT = 0;
    private static final int ADD = 1;
    private static final int COUNT = 50;
    private static final int UNION = 51;
    private static final int UNION_COUNT = 52;
    private static final int INTERSECT_COUNT = 53;
    private static final int SIMILARITY = 54;
    private static final int DESCRIBE = 55;
    private static final int MAY_CONTAIN = 56;

    public static Exp init(HLLPolicy policy, Exp indexBitCount, Exp bin) {
        return HLLExp.init(policy, indexBitCount, Exp.val(-1L), bin);
    }

    public static Exp init(HLLPolicy policy, Exp indexBitCount, Exp minHashBitCount, Exp bin) {
        byte[] bytes = Pack.pack(0, indexBitCount, minHashBitCount, policy.flags, new CTX[0]);
        return HLLExp.addWrite(bin, bytes);
    }

    public static Exp add(HLLPolicy policy, Exp list, Exp bin) {
        return HLLExp.add(policy, list, Exp.val(-1L), Exp.val(-1L), bin);
    }

    public static Exp add(HLLPolicy policy, Exp list, Exp indexBitCount, Exp bin) {
        return HLLExp.add(policy, list, indexBitCount, Exp.val(-1L), bin);
    }

    public static Exp add(HLLPolicy policy, Exp list, Exp indexBitCount, Exp minHashBitCount, Exp bin) {
        byte[] bytes = Pack.pack(1, list, indexBitCount, minHashBitCount, policy.flags, new CTX[0]);
        return HLLExp.addWrite(bin, bytes);
    }

    public static Exp getCount(Exp bin) {
        byte[] bytes = Pack.pack(50, new CTX[0]);
        return HLLExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp getUnion(Exp list, Exp bin) {
        byte[] bytes = Pack.pack(51, list);
        return HLLExp.addRead(bin, bytes, Exp.Type.HLL);
    }

    public static Exp getUnionCount(Exp list, Exp bin) {
        byte[] bytes = Pack.pack(52, list);
        return HLLExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp getIntersectCount(Exp list, Exp bin) {
        byte[] bytes = Pack.pack(53, list);
        return HLLExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp getSimilarity(Exp list, Exp bin) {
        byte[] bytes = Pack.pack(54, list);
        return HLLExp.addRead(bin, bytes, Exp.Type.FLOAT);
    }

    public static Exp describe(Exp bin) {
        byte[] bytes = Pack.pack(55, new CTX[0]);
        return HLLExp.addRead(bin, bytes, Exp.Type.LIST);
    }

    public static Exp mayContain(Exp list, Exp bin) {
        byte[] bytes = Pack.pack(56, list);
        return HLLExp.addRead(bin, bytes, Exp.Type.INT);
    }

    private static Exp addWrite(Exp bin, byte[] bytes) {
        return new Exp.Module(bin, bytes, Exp.Type.HLL.code, 66);
    }

    private static Exp addRead(Exp bin, byte[] bytes, Exp.Type retType) {
        return new Exp.Module(bin, bytes, retType.code, 2);
    }
}

