/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.query.QueryAggregateExecutor;
import java.io.Closeable;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class ResultSet
implements Iterable<Object>,
Closeable {
    public static final Object END = new Object();
    private final QueryAggregateExecutor executor;
    private final BlockingQueue<Object> queue;
    private Object row;
    private volatile boolean valid = true;

    protected ResultSet(QueryAggregateExecutor executor, int capacity) {
        this.executor = executor;
        this.queue = new ArrayBlockingQueue<Object>(capacity);
    }

    protected ResultSet() {
        this.executor = null;
        this.queue = null;
    }

    public boolean next() throws AerospikeException {
        if (!this.valid) {
            this.executor.checkForException();
            return false;
        }
        try {
            this.row = this.queue.take();
        }
        catch (InterruptedException ie) {
            this.valid = false;
            if (Log.debugEnabled()) {
                Log.debug("ResultSet " + this.executor.statement.taskId + " take interrupted");
            }
            return false;
        }
        if (this.row == END) {
            this.valid = false;
            this.executor.checkForException();
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.valid = false;
        if (this.row != END && this.queue.poll() != END) {
            this.executor.stopThreads(new AerospikeException.QueryTerminated());
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new ResultSetIterator(this, this);
    }

    public Object getObject() {
        return this.row;
    }

    public boolean put(Object object) {
        if (!this.valid) {
            return false;
        }
        try {
            this.queue.put(object);
            return true;
        }
        catch (InterruptedException ie) {
            if (Log.debugEnabled()) {
                Log.debug("ResultSet " + this.executor.statement.taskId + " put interrupted");
            }
            if (this.valid) {
                this.abort();
            }
            return false;
        }
    }

    protected void abort() {
        this.valid = false;
        this.queue.clear();
        while (!this.queue.offer(END)) {
            if (this.queue.poll() != null) continue;
            if (!Log.debugEnabled()) break;
            Log.debug("ResultSet " + this.executor.statement.taskId + " both offer and poll failed on abort");
            break;
        }
    }

    private class ResultSetIterator
    implements Iterator<Object>,
    Closeable {
        private final ResultSet resultSet;
        private boolean more;

        ResultSetIterator(ResultSet resultSet, ResultSet resultSet2) {
            this.resultSet = resultSet2;
            this.more = this.resultSet.next();
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public Object next() {
            Object obj = this.resultSet.row;
            this.more = this.resultSet.next();
            return obj;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
            this.resultSet.close();
        }
    }
}

