/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.Policy;

public abstract class AsyncReadBase
extends AsyncCommand {
    protected final Key key;
    protected final Partition partition;

    public AsyncReadBase(Cluster cluster, Policy policy, Key key) {
        super(policy, true);
        this.key = key;
        this.partition = Partition.read(cluster, policy, key);
        cluster.addCommandCount();
    }

    @Override
    boolean isWrite() {
        return false;
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.partition.getNodeRead(cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.READ;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }
}

