/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchDelete;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchUDF;
import com.aerospike.client.BatchWrite;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Txn;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.BatchDeletePolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.BatchReadPolicy;
import com.aerospike.client.policy.BatchUDFPolicy;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryDuration;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ReadModeAP;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.BVal;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.PartitionStatus;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Packer;
import com.aerospike.client.util.ThreadLocalData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.Deflater;

public class Command {
    public static final int INFO1_READ = 1;
    public static final int INFO1_GET_ALL = 2;
    public static final int INFO1_SHORT_QUERY = 4;
    public static final int INFO1_BATCH = 8;
    public static final int INFO1_XDR = 16;
    public static final int INFO1_NOBINDATA = 32;
    public static final int INFO1_READ_MODE_AP_ALL = 64;
    public static final int INFO1_COMPRESS_RESPONSE = 128;
    public static final int INFO2_WRITE = 1;
    public static final int INFO2_DELETE = 2;
    public static final int INFO2_GENERATION = 4;
    public static final int INFO2_GENERATION_GT = 8;
    public static final int INFO2_DURABLE_DELETE = 16;
    public static final int INFO2_CREATE_ONLY = 32;
    public static final int INFO2_RELAX_AP_LONG_QUERY = 64;
    public static final int INFO2_RESPOND_ALL_OPS = 128;
    public static final int INFO3_LAST = 1;
    public static final int INFO3_COMMIT_MASTER = 2;
    public static final int INFO3_PARTITION_DONE = 4;
    public static final int INFO3_UPDATE_ONLY = 8;
    public static final int INFO3_CREATE_OR_REPLACE = 16;
    public static final int INFO3_REPLACE_ONLY = 32;
    public static final int INFO3_SC_READ_TYPE = 64;
    public static final int INFO3_SC_READ_RELAX = 128;
    public static final int INFO4_MRT_VERIFY_READ = 1;
    public static final int INFO4_MRT_ROLL_FORWARD = 2;
    public static final int INFO4_MRT_ROLL_BACK = 4;
    public static final byte STATE_READ_AUTH_HEADER = 1;
    public static final byte STATE_READ_HEADER = 2;
    public static final byte STATE_READ_DETAIL = 3;
    public static final byte STATE_COMPLETE = 4;
    public static final byte BATCH_MSG_READ = 0;
    public static final byte BATCH_MSG_REPEAT = 1;
    public static final byte BATCH_MSG_INFO = 2;
    public static final byte BATCH_MSG_GEN = 4;
    public static final byte BATCH_MSG_TTL = 8;
    public static final byte BATCH_MSG_INFO4 = 16;
    public static final int MSG_TOTAL_HEADER_SIZE = 30;
    public static final int FIELD_HEADER_SIZE = 5;
    public static final int OPERATION_HEADER_SIZE = 8;
    public static final int MSG_REMAINING_HEADER_SIZE = 22;
    public static final int COMPRESS_THRESHOLD = 128;
    public static final long CL_MSG_VERSION = 2L;
    public static final long AS_MSG_TYPE = 3L;
    public static final long MSG_TYPE_COMPRESSED = 4L;
    public byte[] dataBuffer;
    public int dataOffset;
    public final int maxRetries;
    public final int serverTimeout;
    public int socketTimeout;
    public int totalTimeout;
    public Long version;

    public Command(int socketTimeout, int totalTimeout, int maxRetries) {
        this.maxRetries = maxRetries;
        this.totalTimeout = totalTimeout;
        if (totalTimeout > 0) {
            this.serverTimeout = this.socketTimeout = socketTimeout < totalTimeout && socketTimeout > 0 ? socketTimeout : totalTimeout;
        } else {
            this.socketTimeout = socketTimeout;
            this.serverTimeout = 0;
        }
    }

    public final void setTxnAddKeys(WritePolicy policy, Key key, OperateArgs args) {
        this.begin();
        int fieldCount = this.estimateKeySize(key);
        this.dataOffset += args.size;
        this.sizeBuffer();
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)args.readAttr;
        this.dataBuffer[10] = (byte)args.writeAttr;
        this.dataBuffer[11] = 0;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(0, this.dataBuffer, 14);
        Buffer.intToBytes(policy.expiration, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(args.operations.length, this.dataBuffer, 28);
        this.dataOffset = 30;
        this.writeKey(key);
        for (Operation operation : args.operations) {
            this.writeOperation(operation);
        }
        this.end();
        this.compress(policy);
    }

    public final void setTxnVerify(Key key, long ver) {
        this.begin();
        int fieldCount = this.estimateKeySize(key);
        this.dataOffset += 12;
        ++fieldCount;
        this.sizeBuffer();
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = 33;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = 64;
        this.dataBuffer[12] = 1;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(0, this.dataBuffer, 14);
        Buffer.intToBytes(0, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(0, this.dataBuffer, 28);
        this.dataOffset = 30;
        this.writeKey(key);
        this.writeFieldVersion(ver);
        this.end();
    }

    public final void setBatchTxnVerify(BatchPolicy policy, Key[] keys, Long[] versions, BatchNode batch) {
        this.begin();
        this.dataOffset += 10;
        Key keyPrev = null;
        Long verPrev = null;
        int max2 = batch.offsetsSize;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions[offset];
            this.dataOffset += key.digest.length + 4;
            if (Command.canRepeat(key, keyPrev, ver, verPrev)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 9;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            if (ver != null) {
                this.dataOffset += 12;
            }
            keyPrev = key;
            verPrev = ver;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, 1);
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        keyPrev = null;
        verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions[offset];
            Buffer.intToBytes(offset, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (Command.canRepeat(key, keyPrev, ver, verPrev)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.dataBuffer[this.dataOffset++] = 18;
            this.dataBuffer[this.dataOffset++] = 33;
            this.dataBuffer[this.dataOffset++] = 0;
            this.dataBuffer[this.dataOffset++] = 64;
            this.dataBuffer[this.dataOffset++] = 1;
            int fieldCount = 0;
            if (ver != null) {
                ++fieldCount;
            }
            this.writeBatchFields(key, fieldCount, 0);
            if (ver != null) {
                this.writeFieldVersion(ver);
            }
            keyPrev = key;
            verPrev = ver;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setTxnMarkRollForward(Key key) {
        Bin bin = new Bin("fwd", true);
        this.begin();
        int fieldCount = this.estimateKeySize(key);
        this.estimateOperationSize(bin);
        this.writeTxnMonitor(key, 0, 1, fieldCount, 1);
        this.writeOperation(bin, Operation.Type.WRITE);
        this.end();
    }

    public final void setTxnRoll(Key key, Txn txn, int txnAttr) {
        this.begin();
        int fieldCount = this.estimateKeySize(key);
        fieldCount += this.sizeTxn(key, txn, false);
        this.sizeBuffer();
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = 0;
        this.dataBuffer[10] = 17;
        this.dataBuffer[11] = 0;
        this.dataBuffer[12] = (byte)txnAttr;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(0, this.dataBuffer, 14);
        Buffer.intToBytes(0, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(0, this.dataBuffer, 28);
        this.dataOffset = 30;
        this.writeKey(key);
        this.writeTxn(txn, false);
        this.end();
    }

    public final void setBatchTxnRoll(BatchPolicy policy, Txn txn, Key[] keys, BatchNode batch, BatchAttr attr) {
        this.begin();
        int fieldCount = 1;
        int max2 = batch.offsetsSize;
        Long[] versions = new Long[max2];
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            versions[i] = txn.getReadVersion(key);
        }
        this.dataOffset += 10;
        Key keyPrev = null;
        Long verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions[i];
            this.dataOffset += key.digest.length + 4;
            if (Command.canRepeat(key, keyPrev, ver, verPrev)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 12;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            this.sizeTxnBatch(txn, ver, attr.hasWrite);
            this.dataOffset += 2;
            keyPrev = key;
            verPrev = ver;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, fieldCount);
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        keyPrev = null;
        verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions[i];
            Buffer.intToBytes(offset, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (Command.canRepeat(key, keyPrev, ver, verPrev)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.writeBatchWrite(key, txn, ver, attr, null, 0, 0);
            keyPrev = key;
            verPrev = ver;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public void setTxnClose(Txn txn, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(key);
        this.writeTxnMonitor(key, 0, 19, fieldCount, 0);
        this.end();
    }

    private void writeTxnMonitor(Key key, int readAttr, int writeAttr, int fieldCount, int opCount) {
        this.sizeBuffer();
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = 0;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(0, this.dataBuffer, 14);
        Buffer.intToBytes(0, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(opCount, this.dataBuffer, 28);
        this.dataOffset = 30;
        this.writeKey(key);
    }

    public final void setWrite(WritePolicy policy, Operation.Type operation, Key key, Bin[] bins) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, true);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        for (Bin bin : bins) {
            this.estimateOperationSize(bin);
        }
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount, bins.length);
        this.writeKey(policy, key, true);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        for (Bin bin : bins) {
            this.writeOperation(bin, operation);
        }
        this.end();
        this.compress(policy);
    }

    public void setDelete(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, true);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 3, fieldCount, 0);
        this.writeKey(policy, key, true);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.end();
    }

    public void setDelete(Policy policy, Key key, BatchAttr attr) {
        this.begin();
        Expression exp2 = Command.getBatchExpression(policy, attr);
        int fieldCount = this.estimateKeyAttrSize(policy, key, attr, exp2);
        this.sizeBuffer();
        this.writeKeyAttr(policy, key, attr, exp2, fieldCount, 0);
        this.end();
    }

    public final void setTouch(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, true);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.estimateOperationSize();
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount, 1);
        this.writeKey(policy, key, true);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.writeOperation(Operation.Type.TOUCH);
        this.end();
    }

    public final void setExists(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, false);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderReadHeader(policy, 33, fieldCount, 0);
        this.writeKey(policy, key, false);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.end();
    }

    public final void setRead(Policy policy, Key key, String[] binNames) {
        int readAttr = 1;
        int opCount = 0;
        if (binNames != null && binNames.length > 0) {
            opCount = binNames.length;
        } else {
            readAttr |= 2;
        }
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, false);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        if (opCount != 0) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
        }
        this.sizeBuffer();
        this.writeHeaderRead(policy, this.serverTimeout, readAttr, 0, 0, fieldCount, opCount);
        this.writeKey(policy, key, false);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        if (opCount != 0) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    public final void setRead(Policy policy, BatchRead br) {
        int opCount;
        Expression exp2;
        this.begin();
        BatchReadPolicy rp = br.policy;
        BatchAttr attr = new BatchAttr();
        if (rp != null) {
            attr.setRead(rp);
            exp2 = rp.filterExp != null ? rp.filterExp : policy.filterExp;
        } else {
            attr.setRead(policy);
            exp2 = policy.filterExp;
        }
        if (br.binNames != null) {
            opCount = br.binNames.length;
            for (String binName : br.binNames) {
                this.estimateOperationSize(binName);
            }
        } else if (br.ops != null) {
            attr.adjustRead(br.ops);
            opCount = br.ops.length;
            for (Operation op : br.ops) {
                if (op.type.isWrite) {
                    throw new AerospikeException(4, "Write operations not allowed in read");
                }
                this.estimateOperationSize(op);
            }
        } else {
            attr.adjustRead(br.readAllBins);
            opCount = 0;
        }
        int fieldCount = this.estimateKeyAttrSize(policy, br.key, attr, exp2);
        this.sizeBuffer();
        this.writeKeyAttr(policy, br.key, attr, exp2, fieldCount, opCount);
        if (br.binNames != null) {
            for (String binName : br.binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        } else if (br.ops != null) {
            for (Operation op : br.ops) {
                this.writeOperation(op);
            }
        }
        this.end();
    }

    public final void setRead(Policy policy, Key key, Operation[] ops) {
        this.begin();
        BatchAttr attr = new BatchAttr();
        attr.setRead(policy);
        attr.adjustRead(ops);
        int fieldCount = this.estimateKeyAttrSize(policy, key, attr, policy.filterExp);
        for (Operation op : ops) {
            if (op.type.isWrite) {
                throw new AerospikeException(4, "Write operations not allowed in read");
            }
            this.estimateOperationSize(op);
        }
        this.sizeBuffer();
        this.writeKeyAttr(policy, key, attr, policy.filterExp, fieldCount, ops.length);
        for (Operation op : ops) {
            this.writeOperation(op);
        }
        this.end();
    }

    public final void setReadHeader(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, false);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderReadHeader(policy, 33, fieldCount, 0);
        this.writeKey(policy, key, false);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.end();
    }

    public final void setOperate(WritePolicy policy, Key key, OperateArgs args) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, args.hasWrite);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += args.size;
        this.sizeBuffer();
        this.writeHeaderReadWrite(policy, args, fieldCount);
        this.writeKey(policy, key, args.hasWrite);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        for (Operation operation : args.operations) {
            this.writeOperation(operation);
        }
        this.end();
        this.compress(policy);
    }

    public final void setOperate(Policy policy, BatchAttr attr, Key key, Operation[] ops) {
        this.begin();
        Expression exp2 = Command.getBatchExpression(policy, attr);
        int fieldCount = this.estimateKeyAttrSize(policy, key, attr, exp2);
        this.dataOffset += attr.opSize;
        this.sizeBuffer();
        this.writeKeyAttr(policy, key, attr, exp2, fieldCount, ops.length);
        for (Operation op : ops) {
            this.writeOperation(op);
        }
        this.end();
        this.compress(policy);
    }

    public final void setUdf(WritePolicy policy, Key key, String packageName, String functionName, Value[] args) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key, true);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        byte[] argBytes = Packer.pack(args);
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount += this.estimateUdfSize(packageName, functionName, argBytes), 0);
        this.writeKey(policy, key, true);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.writeField(packageName, 30);
        this.writeField(functionName, 31);
        this.writeField(argBytes, 32);
        this.end();
        this.compress(policy);
    }

    public final void setUdf(Policy policy, BatchAttr attr, Key key, String packageName, String functionName, Value[] args) {
        byte[] argBytes = Packer.pack(args);
        this.setUdf(policy, attr, key, packageName, functionName, argBytes);
    }

    public final void setUdf(Policy policy, BatchAttr attr, Key key, String packageName, String functionName, byte[] argBytes) {
        this.begin();
        Expression exp2 = Command.getBatchExpression(policy, attr);
        int fieldCount = this.estimateKeyAttrSize(policy, key, attr, exp2);
        this.sizeBuffer();
        this.writeKeyAttr(policy, key, attr, exp2, fieldCount += this.estimateUdfSize(packageName, functionName, argBytes), 0);
        this.writeField(packageName, 30);
        this.writeField(functionName, 31);
        this.writeField(argBytes, 32);
        this.end();
        this.compress(policy);
    }

    public final void setBatchRead(BatchPolicy policy, List<BatchRead> records, BatchNode batch) {
        int[] offsets = batch.offsets;
        int max2 = batch.offsetsSize;
        BatchRead prev = null;
        this.begin();
        int fieldCount = 1;
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        for (int i = 0; i < max2; ++i) {
            BatchRead record = records.get(offsets[i]);
            Key key = record.key;
            String[] binNames = record.binNames;
            Operation[] ops = record.ops;
            this.dataOffset += key.digest.length + 4;
            if (prev != null && prev.key.namespace == key.namespace && prev.key.setName == key.setName && prev.binNames == binNames && prev.readAllBins == record.readAllBins && prev.ops == ops) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5 + 6;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            if (binNames != null) {
                for (String binName : binNames) {
                    this.estimateOperationSize(binName);
                }
            } else if (ops != null) {
                for (Operation op : ops) {
                    this.estimateReadOperationSize(op);
                }
            }
            prev = record;
        }
        this.sizeBuffer();
        int readAttr = 1;
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.writeHeaderRead(policy, this.totalTimeout, readAttr | 8, 0, 0, fieldCount, 0);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = policy.allowInline ? (byte)1 : 0;
        prev = null;
        for (int i = 0; i < max2; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            BatchRead record = records.get(index2);
            Key key = record.key;
            String[] binNames = record.binNames;
            Operation[] ops = record.ops;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (prev != null && prev.key.namespace == key.namespace && prev.key.setName == key.setName && prev.binNames == binNames && prev.readAllBins == record.readAllBins && prev.ops == ops) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.dataBuffer[this.dataOffset++] = 0;
            if (binNames != null && binNames.length != 0) {
                this.dataBuffer[this.dataOffset++] = (byte)readAttr;
                this.writeBatchFields(key, 0, binNames.length);
                for (String binName : binNames) {
                    this.writeOperation(binName, Operation.Type.READ);
                }
            } else if (ops != null) {
                ++this.dataOffset;
                this.writeBatchFields(key, 0, ops.length);
                this.dataBuffer[offset] = (byte)this.writeReadOnlyOperations(ops, readAttr);
            } else {
                this.dataBuffer[this.dataOffset++] = (byte)(readAttr | (record.readAllBins ? 2 : 32));
                this.writeBatchFields(key, 0, 0);
            }
            prev = record;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchRead(BatchPolicy policy, Key[] keys, BatchNode batch, String[] binNames, Operation[] ops, int readAttr) {
        int[] offsets = batch.offsets;
        int max2 = batch.offsetsSize;
        this.begin();
        int fieldCount = 1;
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        Key prev = null;
        for (int i = 0; i < max2; ++i) {
            Key key = keys[offsets[i]];
            this.dataOffset += key.digest.length + 4;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5 + 6;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            if (binNames != null) {
                for (String binName : binNames) {
                    this.estimateOperationSize(binName);
                }
            } else if (ops != null) {
                for (Operation op : ops) {
                    this.estimateReadOperationSize(op);
                }
            }
            prev = key;
        }
        this.sizeBuffer();
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.writeHeaderRead(policy, this.totalTimeout, readAttr | 8, 0, 0, fieldCount, 0);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = policy.allowInline ? (byte)1 : 0;
        prev = null;
        for (int i = 0; i < max2; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            Key key = keys[index2];
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.dataBuffer[this.dataOffset++] = 0;
            if (binNames != null && binNames.length != 0) {
                this.dataBuffer[this.dataOffset++] = (byte)readAttr;
                this.writeBatchFields(key, 0, binNames.length);
                for (String binName : binNames) {
                    this.writeOperation(binName, Operation.Type.READ);
                }
            } else if (ops != null) {
                ++this.dataOffset;
                this.writeBatchFields(key, 0, ops.length);
                this.dataBuffer[offset] = (byte)this.writeReadOnlyOperations(ops, readAttr);
            } else {
                this.dataBuffer[this.dataOffset++] = (byte)readAttr;
                this.writeBatchFields(key, 0, 0);
            }
            prev = key;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchOperate(BatchPolicy policy, BatchWritePolicy writePolicy, BatchUDFPolicy udfPolicy, BatchDeletePolicy deletePolicy, List<? extends BatchRecord> records, BatchNode batch) {
        this.begin();
        int max2 = batch.offsetsSize;
        Txn txn = policy.txn;
        Long[] versions = null;
        if (txn != null) {
            versions = new Long[max2];
            for (int i = 0; i < max2; ++i) {
                int offset = batch.offsets[i];
                BatchRecord record = records.get(offset);
                versions[i] = txn.getReadVersion(record.key);
            }
        }
        int fieldCount = 1;
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        BatchRecord prev = null;
        Long verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            BatchRecord record = records.get(offset);
            Key key = record.key;
            Long ver = versions != null ? versions[i] : null;
            this.dataOffset += key.digest.length + 4;
            if (Command.canRepeat(policy, key, record, prev, ver, verPrev)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 12;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            this.sizeTxnBatch(txn, ver, record.hasWrite);
            this.dataOffset += record.size(policy);
            prev = record;
            verPrev = ver;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, fieldCount);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        BatchAttr attr = new BatchAttr();
        prev = null;
        verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            BatchRecord record = records.get(offset);
            Long ver = versions != null ? versions[i] : null;
            Buffer.intToBytes(offset, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            Key key = record.key;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (Command.canRepeat(policy, key, record, prev, ver, verPrev)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            switch (record.getType()) {
                case BATCH_READ: {
                    BatchRead br = (BatchRead)record;
                    if (br.policy != null) {
                        attr.setRead(br.policy);
                    } else {
                        attr.setRead(policy);
                    }
                    if (br.binNames != null) {
                        if (br.binNames.length > 0) {
                            this.writeBatchBinNames(key, txn, ver, br.binNames, attr, attr.filterExp);
                            break;
                        }
                        attr.adjustRead(true);
                        this.writeBatchRead(key, txn, ver, attr, attr.filterExp, 0);
                        break;
                    }
                    if (br.ops != null) {
                        attr.adjustRead(br.ops);
                        this.writeBatchOperations(key, txn, ver, br.ops, attr, attr.filterExp);
                        break;
                    }
                    attr.adjustRead(br.readAllBins);
                    this.writeBatchRead(key, txn, ver, attr, attr.filterExp, 0);
                    break;
                }
                case BATCH_WRITE: {
                    BatchWrite bw = (BatchWrite)record;
                    BatchWritePolicy bwp = bw.policy != null ? bw.policy : writePolicy;
                    attr.setWrite(bwp);
                    attr.adjustWrite(bw.ops);
                    this.writeBatchOperations(key, txn, ver, bw.ops, attr, attr.filterExp);
                    break;
                }
                case BATCH_UDF: {
                    BatchUDF bu = (BatchUDF)record;
                    BatchUDFPolicy bup = bu.policy != null ? bu.policy : udfPolicy;
                    attr.setUDF(bup);
                    this.writeBatchWrite(key, txn, ver, attr, attr.filterExp, 3, 0);
                    this.writeField(bu.packageName, 30);
                    this.writeField(bu.functionName, 31);
                    this.writeField(bu.argBytes, 32);
                    break;
                }
                case BATCH_DELETE: {
                    BatchDelete bd = (BatchDelete)record;
                    BatchDeletePolicy bdp = bd.policy != null ? bd.policy : deletePolicy;
                    attr.setDelete(bdp);
                    this.writeBatchWrite(key, txn, ver, attr, attr.filterExp, 0, 0);
                    break;
                }
            }
            prev = record;
            verPrev = ver;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchOperate(BatchPolicy policy, Key[] keys, BatchNode batch, String[] binNames, Operation[] ops, BatchAttr attr) {
        this.begin();
        int max2 = batch.offsetsSize;
        Txn txn = policy.txn;
        Long[] versions = null;
        if (txn != null) {
            versions = new Long[max2];
            for (int i = 0; i < max2; ++i) {
                int offset = batch.offsets[i];
                Key key = keys[offset];
                versions[i] = txn.getReadVersion(key);
            }
        }
        Expression exp2 = Command.getBatchExpression(policy, attr);
        int fieldCount = 1;
        if (exp2 != null) {
            this.dataOffset += exp2.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        Key keyPrev = null;
        Long verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions != null ? versions[i] : null;
            this.dataOffset += key.digest.length + 4;
            if (Command.canRepeat(attr, key, keyPrev, ver, verPrev)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 12;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            this.sizeTxnBatch(txn, ver, attr.hasWrite);
            if (attr.sendKey) {
                this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            }
            if (binNames != null) {
                for (String binName : binNames) {
                    this.estimateOperationSize(binName);
                }
            } else if (ops != null) {
                for (Operation op : ops) {
                    if (op.type.isWrite) {
                        if (!attr.hasWrite) {
                            throw new AerospikeException(4, "Write operations not allowed in batch read");
                        }
                        this.dataOffset += 2;
                    }
                    this.estimateOperationSize(op);
                }
            } else if ((attr.writeAttr & 2) != 0) {
                this.dataOffset += 2;
            }
            keyPrev = key;
            verPrev = ver;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, fieldCount);
        if (exp2 != null) {
            exp2.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        keyPrev = null;
        verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions != null ? versions[i] : null;
            Buffer.intToBytes(offset, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (Command.canRepeat(attr, key, keyPrev, ver, verPrev)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            if (binNames != null) {
                this.writeBatchBinNames(key, txn, ver, binNames, attr, null);
            } else if (ops != null) {
                this.writeBatchOperations(key, txn, ver, ops, attr, null);
            } else if ((attr.writeAttr & 2) != 0) {
                this.writeBatchWrite(key, txn, ver, attr, null, 0, 0);
            } else {
                this.writeBatchRead(key, txn, ver, attr, null, 0);
            }
            keyPrev = key;
            verPrev = ver;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchUDF(BatchPolicy policy, Key[] keys, BatchNode batch, String packageName, String functionName, byte[] argBytes, BatchAttr attr) {
        this.begin();
        int max2 = batch.offsetsSize;
        Txn txn = policy.txn;
        Long[] versions = null;
        if (txn != null) {
            versions = new Long[max2];
            for (int i = 0; i < max2; ++i) {
                int offset = batch.offsets[i];
                Key key = keys[offset];
                versions[i] = txn.getReadVersion(key);
            }
        }
        Expression exp2 = Command.getBatchExpression(policy, attr);
        int fieldCount = 1;
        if (exp2 != null) {
            this.dataOffset += exp2.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        Key keyPrev = null;
        Long verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions != null ? versions[i] : null;
            this.dataOffset += key.digest.length + 4;
            if (Command.canRepeat(attr, key, keyPrev, ver, verPrev)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 12;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            this.sizeTxnBatch(txn, ver, attr.hasWrite);
            if (attr.sendKey) {
                this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            }
            this.dataOffset += 2;
            this.estimateUdfSize(packageName, functionName, argBytes);
            keyPrev = key;
            verPrev = ver;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, fieldCount);
        if (exp2 != null) {
            exp2.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        keyPrev = null;
        verPrev = null;
        for (int i = 0; i < max2; ++i) {
            int offset = batch.offsets[i];
            Key key = keys[offset];
            Long ver = versions != null ? versions[i] : null;
            Buffer.intToBytes(offset, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (Command.canRepeat(attr, key, keyPrev, ver, verPrev)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.writeBatchWrite(key, txn, ver, attr, null, 3, 0);
            this.writeField(packageName, 30);
            this.writeField(functionName, 31);
            this.writeField(argBytes, 32);
            keyPrev = key;
            verPrev = ver;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    private static boolean canRepeat(Policy policy, Key key, BatchRecord record, BatchRecord prev, Long ver, Long verPrev) {
        return !policy.sendKey && verPrev == ver && prev != null && prev.key.namespace == key.namespace && prev.key.setName == key.setName && record.equals(prev);
    }

    private static boolean canRepeat(BatchAttr attr, Key key, Key keyPrev, Long ver, Long verPrev) {
        return !attr.sendKey && verPrev == ver && keyPrev != null && keyPrev.namespace == key.namespace && keyPrev.setName == key.setName;
    }

    private static boolean canRepeat(Key key, Key keyPrev, Long ver, Long verPrev) {
        return verPrev == ver && keyPrev != null && keyPrev.namespace == key.namespace && keyPrev.setName == key.setName;
    }

    private static final Expression getBatchExpression(Policy policy, BatchAttr attr) {
        return attr.filterExp != null ? attr.filterExp : policy.filterExp;
    }

    private static byte getBatchFlags(BatchPolicy policy) {
        byte flags = 8;
        if (policy.allowInline) {
            flags = (byte)(flags | 1);
        }
        if (policy.allowInlineSSD) {
            flags = (byte)(flags | 2);
        }
        if (policy.respondAllKeys) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    private void sizeTxnBatch(Txn txn, Long ver, boolean hasWrite) {
        if (txn != null) {
            ++this.dataOffset;
            this.dataOffset += 13;
            if (ver != null) {
                this.dataOffset += 12;
            }
            if (hasWrite && txn.getDeadline() != 0) {
                this.dataOffset += 9;
            }
        }
    }

    private void writeBatchHeader(Policy policy, int timeout, int fieldCount) {
        int readAttr = 8;
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = 0;
        for (int i = 12; i < 22; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(timeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(0, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private void writeBatchBinNames(Key key, Txn txn, Long ver, String[] binNames, BatchAttr attr, Expression filter) {
        this.writeBatchRead(key, txn, ver, attr, filter, binNames.length);
        for (String binName : binNames) {
            this.writeOperation(binName, Operation.Type.READ);
        }
    }

    private void writeBatchOperations(Key key, Txn txn, Long ver, Operation[] ops, BatchAttr attr, Expression filter) {
        if (attr.hasWrite) {
            this.writeBatchWrite(key, txn, ver, attr, filter, 0, ops.length);
        } else {
            this.writeBatchRead(key, txn, ver, attr, filter, ops.length);
        }
        for (Operation op : ops) {
            this.writeOperation(op);
        }
    }

    private void writeBatchRead(Key key, Txn txn, Long ver, BatchAttr attr, Expression filter, int opCount) {
        if (txn != null) {
            this.dataBuffer[this.dataOffset++] = 26;
            this.dataBuffer[this.dataOffset++] = (byte)attr.readAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.writeAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.infoAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.txnAttr;
            Buffer.intToBytes(attr.expiration, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.writeBatchFieldsTxn(key, txn, ver, attr, filter, 0, opCount);
        } else {
            this.dataBuffer[this.dataOffset++] = 10;
            this.dataBuffer[this.dataOffset++] = (byte)attr.readAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.writeAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.infoAttr;
            Buffer.intToBytes(attr.expiration, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.writeBatchFieldsReg(key, attr, filter, 0, opCount);
        }
    }

    private void writeBatchWrite(Key key, Txn txn, Long ver, BatchAttr attr, Expression filter, int fieldCount, int opCount) {
        if (txn != null) {
            this.dataBuffer[this.dataOffset++] = 30;
            this.dataBuffer[this.dataOffset++] = (byte)attr.readAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.writeAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.infoAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.txnAttr;
            Buffer.shortToBytes(attr.generation, this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            Buffer.intToBytes(attr.expiration, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.writeBatchFieldsTxn(key, txn, ver, attr, filter, fieldCount, opCount);
        } else {
            this.dataBuffer[this.dataOffset++] = 14;
            this.dataBuffer[this.dataOffset++] = (byte)attr.readAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.writeAttr;
            this.dataBuffer[this.dataOffset++] = (byte)attr.infoAttr;
            Buffer.shortToBytes(attr.generation, this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            Buffer.intToBytes(attr.expiration, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            this.writeBatchFieldsReg(key, attr, filter, fieldCount, opCount);
        }
    }

    private void writeBatchFieldsTxn(Key key, Txn txn, Long ver, BatchAttr attr, Expression filter, int fieldCount, int opCount) {
        ++fieldCount;
        if (ver != null) {
            ++fieldCount;
        }
        if (attr.hasWrite && txn.getDeadline() != 0) {
            ++fieldCount;
        }
        if (filter != null) {
            ++fieldCount;
        }
        if (attr.sendKey) {
            ++fieldCount;
        }
        this.writeBatchFields(key, fieldCount, opCount);
        this.writeFieldLE(txn.getId(), 5);
        if (ver != null) {
            this.writeFieldVersion(ver);
        }
        if (attr.hasWrite && txn.getDeadline() != 0) {
            this.writeFieldLE(txn.getDeadline(), 6);
        }
        if (filter != null) {
            filter.write(this);
        }
        if (attr.sendKey) {
            this.writeField(key.userKey, 2);
        }
    }

    private void writeBatchFieldsReg(Key key, BatchAttr attr, Expression filter, int fieldCount, int opCount) {
        if (filter != null) {
            ++fieldCount;
        }
        if (attr.sendKey) {
            ++fieldCount;
        }
        this.writeBatchFields(key, fieldCount, opCount);
        if (filter != null) {
            filter.write(this);
        }
        if (attr.sendKey) {
            this.writeField(key.userKey, 2);
        }
    }

    private void writeBatchFields(Key key, int fieldCount, int opCount) {
        Buffer.shortToBytes(fieldCount += 2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 2;
        Buffer.shortToBytes(opCount, this.dataBuffer, this.dataOffset);
        this.dataOffset += 2;
        this.writeField(key.namespace, 0);
        this.writeField(key.setName, 1);
    }

    public final void setScan(Cluster cluster, ScanPolicy policy, String namespace, String setName, String[] binNames, long taskId, PartitionTracker.NodePartitions nodePartitions) {
        this.begin();
        int fieldCount = 0;
        int partsFullSize = nodePartitions.partsFull.size() * 2;
        int partsPartialSize = nodePartitions.partsPartial.size() * 20;
        long maxRecords = nodePartitions.recordMax;
        if (namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(namespace) + 5;
            ++fieldCount;
        }
        if (setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(setName) + 5;
            ++fieldCount;
        }
        if (partsFullSize > 0) {
            this.dataOffset += partsFullSize + 5;
            ++fieldCount;
        }
        if (partsPartialSize > 0) {
            this.dataOffset += partsPartialSize + 5;
            ++fieldCount;
        }
        if (maxRecords > 0L) {
            this.dataOffset += 13;
            ++fieldCount;
        }
        if (policy.recordsPerSecond > 0) {
            this.dataOffset += 9;
            ++fieldCount;
        }
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 9;
        ++fieldCount;
        this.dataOffset += 13;
        ++fieldCount;
        if (binNames != null) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
        }
        this.sizeBuffer();
        int readAttr = 1;
        if (!policy.includeBinData) {
            readAttr |= 0x20;
        }
        int operationCount = binNames == null ? 0 : binNames.length;
        this.writeHeaderRead(policy, this.totalTimeout, readAttr, 0, 4, fieldCount, operationCount);
        if (namespace != null) {
            this.writeField(namespace, 0);
        }
        if (setName != null) {
            this.writeField(setName, 1);
        }
        if (partsFullSize > 0) {
            this.writeFieldHeader(partsFullSize, 11);
            for (PartitionStatus part : nodePartitions.partsFull) {
                Buffer.shortToLittleBytes(part.id, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
            }
        }
        if (partsPartialSize > 0) {
            this.writeFieldHeader(partsPartialSize, 12);
            for (PartitionStatus part : nodePartitions.partsPartial) {
                System.arraycopy(part.digest, 0, this.dataBuffer, this.dataOffset, 20);
                this.dataOffset += 20;
            }
        }
        if (maxRecords > 0L) {
            this.writeField(maxRecords, 13);
        }
        if (policy.recordsPerSecond > 0) {
            this.writeField(policy.recordsPerSecond, 10);
        }
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.writeField(policy.socketTimeout, 9);
        this.writeField(taskId, 7);
        if (binNames != null) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    public final void setQuery(Cluster cluster, Policy policy, Statement statement, long taskId, boolean background, PartitionTracker.NodePartitions nodePartitions) {
        byte[] functionArgBuffer = null;
        int fieldCount = 0;
        int filterSize = 0;
        int binNameSize = 0;
        boolean isNew = cluster.hasPartitionQuery;
        this.begin();
        if (statement.getNamespace() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getNamespace()) + 5;
            ++fieldCount;
        }
        if (statement.getSetName() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getSetName()) + 5;
            ++fieldCount;
        }
        if (statement.getRecordsPerSecond() > 0) {
            this.dataOffset += 9;
            ++fieldCount;
        }
        this.dataOffset += 9;
        ++fieldCount;
        this.dataOffset += 13;
        ++fieldCount;
        Filter filter = statement.getFilter();
        String[] binNames = statement.getBinNames();
        byte[] packedCtx = null;
        if (filter != null) {
            IndexCollectionType type2 = filter.getCollectionType();
            if (type2 != IndexCollectionType.DEFAULT) {
                this.dataOffset += 6;
                ++fieldCount;
            }
            this.dataOffset += 5;
            ++filterSize;
            this.dataOffset += (filterSize += filter.estimateSize());
            ++fieldCount;
            if (!isNew && binNames != null && binNames.length > 0) {
                this.dataOffset += 5;
                ++binNameSize;
                for (String binName : binNames) {
                    binNameSize += Buffer.estimateSizeUtf8(binName) + 1;
                }
                this.dataOffset += binNameSize;
                ++fieldCount;
            }
            if ((packedCtx = filter.getPackedCtx()) != null) {
                this.dataOffset += 5 + packedCtx.length;
                ++fieldCount;
            }
        }
        if (statement.getFunctionName() != null) {
            this.dataOffset += 6;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getPackageName()) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getFunctionName()) + 5;
            functionArgBuffer = statement.getFunctionArgs().length > 0 ? Packer.pack(statement.getFunctionArgs()) : new byte[]{};
            this.dataOffset += 5 + functionArgBuffer.length;
            fieldCount += 4;
        }
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        long maxRecords = 0L;
        int partsFullSize = 0;
        int partsPartialDigestSize = 0;
        int partsPartialBValSize = 0;
        if (nodePartitions != null) {
            partsFullSize = nodePartitions.partsFull.size() * 2;
            partsPartialDigestSize = nodePartitions.partsPartial.size() * 20;
            if (filter != null) {
                partsPartialBValSize = nodePartitions.partsPartial.size() * 8;
            }
            maxRecords = nodePartitions.recordMax;
        }
        if (partsFullSize > 0) {
            this.dataOffset += partsFullSize + 5;
            ++fieldCount;
        }
        if (partsPartialDigestSize > 0) {
            this.dataOffset += partsPartialDigestSize + 5;
            ++fieldCount;
        }
        if (partsPartialBValSize > 0) {
            this.dataOffset += partsPartialBValSize + 5;
            ++fieldCount;
        }
        if (maxRecords > 0L) {
            this.dataOffset += 13;
            ++fieldCount;
        }
        Operation[] operations = statement.getOperations();
        int operationCount = 0;
        if (operations != null) {
            if (!background) {
                throw new AerospikeException(4, "Operations not allowed in foreground query");
            }
            for (Operation operation : operations) {
                if (!operation.type.isWrite) {
                    throw new AerospikeException(4, "Read operations not allowed in background query");
                }
                this.estimateOperationSize(operation);
            }
            operationCount = operations.length;
        } else if (binNames != null && (isNew || filter == null)) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
            operationCount = binNames.length;
        }
        this.sizeBuffer();
        if (background) {
            this.writeHeaderWrite((WritePolicy)policy, 1, fieldCount, operationCount);
        } else {
            QueryPolicy qp = (QueryPolicy)policy;
            int readAttr = 1;
            int writeAttr = 0;
            if (!qp.includeBinData) {
                readAttr |= 0x20;
            }
            if (qp.shortQuery || qp.expectedDuration == QueryDuration.SHORT) {
                readAttr |= 4;
            } else if (qp.expectedDuration == QueryDuration.LONG_RELAX_AP) {
                writeAttr |= 0x40;
            }
            int infoAttr = isNew || filter == null ? 4 : 0;
            this.writeHeaderRead(policy, this.totalTimeout, readAttr, writeAttr, infoAttr, fieldCount, operationCount);
        }
        if (statement.getNamespace() != null) {
            this.writeField(statement.getNamespace(), 0);
        }
        if (statement.getSetName() != null) {
            this.writeField(statement.getSetName(), 1);
        }
        if (statement.getRecordsPerSecond() > 0) {
            this.writeField(statement.getRecordsPerSecond(), 10);
        }
        this.writeField(policy.socketTimeout, 9);
        this.writeField(taskId, 7);
        if (filter != null) {
            IndexCollectionType type3 = filter.getCollectionType();
            if (type3 != IndexCollectionType.DEFAULT) {
                this.writeFieldHeader(1, 26);
                this.dataBuffer[this.dataOffset++] = (byte)type3.ordinal();
            }
            this.writeFieldHeader(filterSize, 22);
            this.dataBuffer[this.dataOffset++] = 1;
            this.dataOffset = filter.write(this.dataBuffer, this.dataOffset);
            if (!isNew && binNames != null && binNames.length > 0) {
                this.writeFieldHeader(binNameSize, 40);
                this.dataBuffer[this.dataOffset++] = (byte)binNames.length;
                String[] readAttr = binNames;
                int n = readAttr.length;
                for (int infoAttr = 0; infoAttr < n; ++infoAttr) {
                    String binName = readAttr[infoAttr];
                    int len2 = Buffer.stringToUtf8(binName, this.dataBuffer, this.dataOffset + 1);
                    this.dataBuffer[this.dataOffset] = (byte)len2;
                    this.dataOffset += len2 + 1;
                }
            }
            if (packedCtx != null) {
                this.writeFieldHeader(packedCtx.length, 23);
                System.arraycopy(packedCtx, 0, this.dataBuffer, this.dataOffset, packedCtx.length);
                this.dataOffset += packedCtx.length;
            }
        }
        if (statement.getFunctionName() != null) {
            this.writeFieldHeader(1, 33);
            this.dataBuffer[this.dataOffset++] = background ? 2 : 1;
            this.writeField(statement.getPackageName(), 30);
            this.writeField(statement.getFunctionName(), 31);
            this.writeField(functionArgBuffer, 32);
        }
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        if (partsFullSize > 0) {
            this.writeFieldHeader(partsFullSize, 11);
            for (PartitionStatus part : nodePartitions.partsFull) {
                Buffer.shortToLittleBytes(part.id, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
            }
        }
        if (partsPartialDigestSize > 0) {
            this.writeFieldHeader(partsPartialDigestSize, 12);
            for (PartitionStatus part : nodePartitions.partsPartial) {
                System.arraycopy(part.digest, 0, this.dataBuffer, this.dataOffset, 20);
                this.dataOffset += 20;
            }
        }
        if (partsPartialBValSize > 0) {
            this.writeFieldHeader(partsPartialBValSize, 15);
            for (PartitionStatus part : nodePartitions.partsPartial) {
                Buffer.longToLittleBytes(part.bval, this.dataBuffer, this.dataOffset);
                this.dataOffset += 8;
            }
        }
        if (maxRecords > 0L) {
            this.writeField(maxRecords, 13);
        }
        if (operations != null) {
            for (Operation operation : operations) {
                this.writeOperation(operation);
            }
        } else if (binNames != null && (isNew || filter == null)) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    private final int estimateKeyAttrSize(Policy policy, Key key, BatchAttr attr, Expression filterExp) {
        int fieldCount = this.estimateKeySize(policy, key, attr.hasWrite);
        if (filterExp != null) {
            this.dataOffset += filterExp.size();
            ++fieldCount;
        }
        return fieldCount;
    }

    private int estimateKeySize(Policy policy, Key key, boolean hasWrite) {
        int fieldCount = this.estimateKeySize(key);
        fieldCount += this.sizeTxn(key, policy.txn, hasWrite);
        if (policy.sendKey) {
            this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            ++fieldCount;
        }
        return fieldCount;
    }

    protected final int estimateKeySize(Key key) {
        int fieldCount = 0;
        if (key.namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            ++fieldCount;
        }
        if (key.setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            ++fieldCount;
        }
        this.dataOffset += key.digest.length + 5;
        return ++fieldCount;
    }

    private final int estimateUdfSize(String packageName, String functionName, byte[] bytes) {
        this.dataOffset += Buffer.estimateSizeUtf8(packageName) + 5;
        this.dataOffset += Buffer.estimateSizeUtf8(functionName) + 5;
        this.dataOffset += bytes.length + 5;
        return 3;
    }

    private final void estimateOperationSize(Bin bin) {
        this.dataOffset += Buffer.estimateSizeUtf8(bin.name) + 8;
        this.dataOffset += bin.value.estimateSize();
    }

    private final void estimateOperationSize(Operation operation) {
        this.dataOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
        this.dataOffset += operation.value.estimateSize();
    }

    private void estimateReadOperationSize(Operation operation) {
        if (operation.type.isWrite) {
            throw new AerospikeException(4, "Write operations not allowed in batch read");
        }
        this.dataOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
        this.dataOffset += operation.value.estimateSize();
    }

    private final void estimateOperationSize(String binName) {
        this.dataOffset += Buffer.estimateSizeUtf8(binName) + 8;
    }

    private final void estimateOperationSize() {
        this.dataOffset += 8;
    }

    private final void writeHeaderWrite(WritePolicy policy, int writeAttr, int fieldCount, int operationCount) {
        int generation = 0;
        int readAttr = 0;
        int infoAttr = 0;
        switch (policy.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                infoAttr |= 8;
                break;
            }
            case REPLACE: {
                infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                writeAttr |= 0x20;
            }
        }
        switch (policy.generationPolicy) {
            case NONE: {
                break;
            }
            case EXPECT_GEN_EQUAL: {
                generation = policy.generation;
                writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                generation = policy.generation;
                writeAttr |= 8;
            }
        }
        if (policy.commitLevel == CommitLevel.COMMIT_MASTER) {
            infoAttr |= 2;
        }
        if (policy.durableDelete) {
            writeAttr |= 0x10;
        }
        if (policy.xdr) {
            readAttr |= 0x10;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(generation, this.dataBuffer, 14);
        Buffer.intToBytes(policy.expiration, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderReadWrite(WritePolicy policy, OperateArgs args, int fieldCount) {
        int generation = 0;
        int ttl = args.hasWrite ? policy.expiration : policy.readTouchTtlPercent;
        int readAttr = args.readAttr;
        int writeAttr = args.writeAttr;
        int infoAttr = 0;
        int operationCount = args.operations.length;
        switch (policy.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                infoAttr |= 8;
                break;
            }
            case REPLACE: {
                infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                writeAttr |= 0x20;
            }
        }
        switch (policy.generationPolicy) {
            case NONE: {
                break;
            }
            case EXPECT_GEN_EQUAL: {
                generation = policy.generation;
                writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                generation = policy.generation;
                writeAttr |= 8;
            }
        }
        if (policy.commitLevel == CommitLevel.COMMIT_MASTER) {
            infoAttr |= 2;
        }
        if (policy.durableDelete) {
            writeAttr |= 0x10;
        }
        if (policy.xdr) {
            readAttr |= 0x10;
        }
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(generation, this.dataBuffer, 14);
        Buffer.intToBytes(ttl, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderRead(Policy policy, int timeout, int readAttr, int writeAttr, int infoAttr, int fieldCount, int operationCount) {
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        for (int i = 12; i < 18; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(policy.readTouchTtlPercent, this.dataBuffer, 18);
        Buffer.intToBytes(timeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderReadHeader(Policy policy, int readAttr, int fieldCount, int operationCount) {
        int infoAttr = 0;
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = (byte)infoAttr;
        for (int i = 12; i < 18; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(policy.readTouchTtlPercent, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private void writeKeyAttr(Policy policy, Key key, BatchAttr attr, Expression filterExp, int fieldCount, int operationCount) {
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)attr.readAttr;
        this.dataBuffer[10] = (byte)attr.writeAttr;
        this.dataBuffer[11] = (byte)attr.infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(attr.generation, this.dataBuffer, 14);
        Buffer.intToBytes(attr.expiration, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
        this.writeKey(policy, key, attr.hasWrite);
        if (filterExp != null) {
            filterExp.write(this);
        }
    }

    private void writeKey(Policy policy, Key key, boolean sendDeadline) {
        this.writeKey(key);
        this.writeTxn(policy.txn, sendDeadline);
        if (policy.sendKey) {
            this.writeField(key.userKey, 2);
        }
    }

    protected final void writeKey(Key key) {
        if (key.namespace != null) {
            this.writeField(key.namespace, 0);
        }
        if (key.setName != null) {
            this.writeField(key.setName, 1);
        }
        this.writeField(key.digest, 4);
    }

    private final int writeReadOnlyOperations(Operation[] ops, int readAttr) {
        boolean readBin = false;
        boolean readHeader = false;
        for (Operation op : ops) {
            switch (op.type) {
                case READ: {
                    if (op.binName == null) {
                        readAttr |= 2;
                    }
                    readBin = true;
                    break;
                }
                case READ_HEADER: {
                    readHeader = true;
                    break;
                }
            }
            this.writeOperation(op);
        }
        if (readHeader && !readBin) {
            readAttr |= 0x20;
        }
        return readAttr;
    }

    private final void writeOperation(Bin bin, Operation.Type operation) {
        int nameLength = Buffer.stringToUtf8(bin.name, this.dataBuffer, this.dataOffset + 8);
        int valueLength = bin.value.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)bin.value.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    private final void writeOperation(Operation operation) {
        int nameLength = Buffer.stringToUtf8(operation.binName, this.dataBuffer, this.dataOffset + 8);
        int valueLength = operation.value.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.type.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)operation.value.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    private final void writeOperation(String name, Operation.Type operation) {
        int nameLength = Buffer.stringToUtf8(name, this.dataBuffer, this.dataOffset + 8);
        Buffer.intToBytes(nameLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength;
    }

    private final void writeOperation(Operation.Type operation) {
        Buffer.intToBytes(4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
    }

    private int sizeTxn(Key key, Txn txn, boolean hasWrite) {
        int fieldCount = 0;
        if (txn != null) {
            this.dataOffset += 13;
            ++fieldCount;
            this.version = txn.getReadVersion(key);
            if (this.version != null) {
                this.dataOffset += 12;
                ++fieldCount;
            }
            if (hasWrite && txn.getDeadline() != 0) {
                this.dataOffset += 9;
                ++fieldCount;
            }
        }
        return fieldCount;
    }

    private void writeTxn(Txn txn, boolean sendDeadline) {
        if (txn != null) {
            this.writeFieldLE(txn.getId(), 5);
            if (this.version != null) {
                this.writeFieldVersion(this.version);
            }
            if (sendDeadline && txn.getDeadline() != 0) {
                this.writeFieldLE(txn.getDeadline(), 6);
            }
        }
    }

    private void writeFieldVersion(long ver) {
        this.writeFieldHeader(7, 3);
        Buffer.longToVersionBytes(ver, this.dataBuffer, this.dataOffset);
        this.dataOffset += 7;
    }

    private void writeField(Value value, int type2) {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)value.getType();
        int len2 = value.write(this.dataBuffer, offset) + 1;
        this.writeFieldHeader(len2, type2);
        this.dataOffset += len2;
    }

    private void writeField(String str, int type2) {
        int len2 = Buffer.stringToUtf8(str, this.dataBuffer, this.dataOffset + 5);
        this.writeFieldHeader(len2, type2);
        this.dataOffset += len2;
    }

    private void writeField(byte[] bytes, int type2) {
        System.arraycopy(bytes, 0, this.dataBuffer, this.dataOffset + 5, bytes.length);
        this.writeFieldHeader(bytes.length, type2);
        this.dataOffset += bytes.length;
    }

    private void writeField(int val, int type2) {
        this.writeFieldHeader(4, type2);
        Buffer.intToBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
    }

    private void writeFieldLE(int val, int type2) {
        this.writeFieldHeader(4, type2);
        Buffer.intToLittleBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
    }

    private void writeField(long val, int type2) {
        this.writeFieldHeader(8, type2);
        Buffer.longToBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 8;
    }

    private void writeFieldLE(long val, int type2) {
        this.writeFieldHeader(8, type2);
        Buffer.longToLittleBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 8;
    }

    private void writeFieldHeader(int size, int type2) {
        Buffer.intToBytes(size + 1, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)type2;
    }

    public final void writeExpHeader(int size) {
        this.writeFieldHeader(size, 43);
    }

    protected final void begin() {
        this.dataOffset = 30;
    }

    protected final void end() {
        long proto = (long)(this.dataOffset - 8) | 0x200000000000000L | 0x3000000000000L;
        Buffer.longToBytes(proto, this.dataBuffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void compress(Policy policy) {
        if (policy.compress && this.dataOffset > 128) {
            Deflater def = new Deflater(1);
            try {
                def.setInput(this.dataBuffer, 0, this.dataOffset);
                def.finish();
                byte[] cbuf = new byte[this.dataOffset];
                int csize = def.deflate(cbuf, 16, this.dataOffset - 16);
                if (def.finished()) {
                    long proto = (long)(csize + 8) | 0x200000000000000L | 0x4000000000000L;
                    Buffer.longToBytes(proto, cbuf, 0);
                    Buffer.longToBytes(this.dataOffset, cbuf, 8);
                    this.dataBuffer = cbuf;
                    this.dataOffset = csize + 16;
                }
            }
            finally {
                def.end();
            }
        }
    }

    protected void sizeBuffer() {
        this.dataBuffer = ThreadLocalData.getBuffer();
        if (this.dataOffset > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(this.dataOffset);
        }
    }

    protected final void skipKey(int fieldCount) {
        for (int i = 0; i < fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4 + fieldlen;
        }
    }

    protected final Key parseKey(int fieldCount, BVal bval) {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        Value userKey = null;
        for (int i = 0; i < fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte fieldtype = this.dataBuffer[this.dataOffset++];
            int size = fieldlen - 1;
            switch (fieldtype) {
                case 4: {
                    digest = new byte[size];
                    System.arraycopy(this.dataBuffer, this.dataOffset, digest, 0, size);
                    break;
                }
                case 0: {
                    namespace = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    break;
                }
                case 1: {
                    setName = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    break;
                }
                case 2: {
                    byte type2 = this.dataBuffer[this.dataOffset++];
                    userKey = Buffer.bytesToKeyValue(type2, this.dataBuffer, this.dataOffset, --size);
                    break;
                }
                case 15: {
                    bval.val = Buffer.littleBytesToLong(this.dataBuffer, this.dataOffset);
                }
            }
            this.dataOffset += size;
        }
        return new Key(namespace, digest, setName, userKey);
    }

    public Long parseVersion(int fieldCount) {
        Long version = null;
        for (int i = 0; i < fieldCount; ++i) {
            int len2 = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte type2 = this.dataBuffer[this.dataOffset++];
            int size = len2 - 1;
            if (type2 == 3 && size == 7) {
                version = Buffer.versionBytesToLong(this.dataBuffer, this.dataOffset);
            }
            this.dataOffset += size;
        }
        return version;
    }

    protected final Record parseRecord(int opCount, int generation, int expiration, boolean isOperation) {
        LinkedHashMap<String, Object> bins = new LinkedHashMap<String, Object>();
        for (int i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            if (isOperation) {
                if (bins.containsKey(name)) {
                    OpResults list;
                    Object prev = bins.get(name);
                    if (prev instanceof OpResults) {
                        list = (OpResults)prev;
                        list.add(value);
                        continue;
                    }
                    list = new OpResults();
                    list.add(prev);
                    list.add(value);
                    bins.put(name, list);
                    continue;
                }
                bins.put(name, value);
                continue;
            }
            bins.put(name, value);
        }
        return new Record(bins, generation, expiration);
    }

    public static boolean batchInDoubt(boolean isWrite, int commandSentCounter) {
        return isWrite && commandSentCounter > 1;
    }

    public static class OpResults
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;
    }
}

