/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AbortStatus;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.CommitError;
import com.aerospike.client.CommitStatus;
import com.aerospike.client.Key;
import com.aerospike.client.Txn;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.Batch;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchExecutor;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.BatchSingle;
import com.aerospike.client.command.BatchStatus;
import com.aerospike.client.command.IBatchCommand;
import com.aerospike.client.command.TxnClose;
import com.aerospike.client.command.TxnMarkRollForward;
import com.aerospike.client.command.TxnMonitor;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.WritePolicy;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TxnRoll {
    private final Cluster cluster;
    private final Txn txn;
    private BatchRecord[] verifyRecords;
    private BatchRecord[] rollRecords;

    public TxnRoll(Cluster cluster, Txn txn) {
        this.cluster = cluster;
        this.txn = txn;
    }

    public void verify(BatchPolicy verifyPolicy, BatchPolicy rollPolicy) {
        try {
            this.verifyRecordVersions(verifyPolicy);
        }
        catch (Throwable t) {
            this.txn.setState(Txn.State.ABORTED);
            try {
                this.roll(rollPolicy, 4);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
                throw this.createCommitException(CommitError.VERIFY_FAIL_ABORT_ABANDONED, t);
            }
            if (this.txn.closeMonitor()) {
                try {
                    WritePolicy writePolicy = new WritePolicy(rollPolicy);
                    Key txnKey = TxnMonitor.getTxnMonitorKey(this.txn);
                    this.close(writePolicy, txnKey);
                }
                catch (Throwable t3) {
                    t.addSuppressed(t3);
                    throw this.createCommitException(CommitError.VERIFY_FAIL_CLOSE_ABANDONED, t);
                }
            }
            throw this.createCommitException(CommitError.VERIFY_FAIL, t);
        }
        this.txn.setState(Txn.State.VERIFIED);
    }

    public CommitStatus commit(BatchPolicy rollPolicy) {
        WritePolicy writePolicy = new WritePolicy(rollPolicy);
        Key txnKey = TxnMonitor.getTxnMonitorKey(this.txn);
        if (this.txn.monitorExists()) {
            try {
                this.markRollForward(writePolicy, txnKey);
            }
            catch (AerospikeException ae) {
                AerospikeException.Commit aec = this.createCommitException(CommitError.MARK_ROLL_FORWARD_ABANDONED, ae);
                if (ae.getResultCode() == 125) {
                    aec.setInDoubt(false);
                    this.txn.setInDoubt(false);
                    this.txn.setState(Txn.State.ABORTED);
                } else if (this.txn.getInDoubt()) {
                    aec.setInDoubt(true);
                } else if (ae.getInDoubt()) {
                    aec.setInDoubt(true);
                    this.txn.setInDoubt(true);
                }
                throw aec;
            }
            catch (Throwable t) {
                AerospikeException.Commit aec = this.createCommitException(CommitError.MARK_ROLL_FORWARD_ABANDONED, t);
                if (this.txn.getInDoubt()) {
                    aec.setInDoubt(true);
                }
                throw aec;
            }
        }
        this.txn.setState(Txn.State.COMMITTED);
        this.txn.setInDoubt(false);
        try {
            this.roll(rollPolicy, 2);
        }
        catch (Throwable t) {
            return CommitStatus.ROLL_FORWARD_ABANDONED;
        }
        if (this.txn.closeMonitor()) {
            try {
                this.close(writePolicy, txnKey);
            }
            catch (Throwable t) {
                return CommitStatus.CLOSE_ABANDONED;
            }
        }
        return CommitStatus.OK;
    }

    private AerospikeException.Commit createCommitException(CommitError error2, Throwable cause) {
        AerospikeException.Commit aec = new AerospikeException.Commit(error2, this.verifyRecords, this.rollRecords, cause);
        if (cause instanceof AerospikeException) {
            AerospikeException src = (AerospikeException)cause;
            aec.setNode(src.getNode());
            aec.setPolicy(src.getPolicy());
            aec.setIteration(src.getIteration());
            aec.setInDoubt(src.getInDoubt());
        }
        return aec;
    }

    public AbortStatus abort(BatchPolicy rollPolicy) {
        this.txn.setState(Txn.State.ABORTED);
        try {
            this.roll(rollPolicy, 4);
        }
        catch (Throwable t) {
            return AbortStatus.ROLL_BACK_ABANDONED;
        }
        if (this.txn.closeMonitor()) {
            try {
                WritePolicy writePolicy = new WritePolicy(rollPolicy);
                Key txnKey = TxnMonitor.getTxnMonitorKey(this.txn);
                this.close(writePolicy, txnKey);
            }
            catch (Throwable t) {
                return AbortStatus.CLOSE_ABANDONED;
            }
        }
        return AbortStatus.OK;
    }

    private void verifyRecordVersions(BatchPolicy verifyPolicy) {
        Set<Map.Entry<Key, Long>> reads = this.txn.getReads();
        int max2 = reads.size();
        if (max2 == 0) {
            return;
        }
        BatchRecord[] records = new BatchRecord[max2];
        Key[] keys = new Key[max2];
        Long[] versions = new Long[max2];
        int count = 0;
        for (Map.Entry<Key, Long> entry : reads) {
            Key key;
            keys[count] = key = entry.getKey();
            records[count] = new BatchRecord(key, false);
            versions[count] = entry.getValue();
            ++count;
        }
        this.verifyRecords = records;
        BatchStatus status2 = new BatchStatus(true);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, verifyPolicy, keys, records, false, status2);
        IBatchCommand[] commands = new IBatchCommand[bns.size()];
        count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new BatchSingle.TxnVerify(this.cluster, verifyPolicy, versions[i], records[i], status2, bn.node);
                continue;
            }
            commands[count++] = new Batch.TxnVerify(this.cluster, bn, verifyPolicy, keys, versions, records, status2);
        }
        BatchExecutor.execute(this.cluster, verifyPolicy, commands, status2);
        if (!status2.getStatus()) {
            throw new RuntimeException("Failed to verify one or more record versions");
        }
    }

    private void markRollForward(WritePolicy writePolicy, Key txnKey) {
        TxnMarkRollForward cmd = new TxnMarkRollForward(this.cluster, writePolicy, txnKey);
        cmd.execute();
    }

    private void roll(BatchPolicy rollPolicy, int txnAttr) {
        Set<Key> keySet = this.txn.getWrites();
        if (keySet.isEmpty()) {
            return;
        }
        Key[] keys = keySet.toArray(new Key[keySet.size()]);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], true);
        }
        this.rollRecords = records;
        BatchAttr attr = new BatchAttr();
        attr.setTxn(txnAttr);
        BatchStatus status2 = new BatchStatus(true);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, rollPolicy, keys, records, true, status2);
        IBatchCommand[] commands = new IBatchCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new BatchSingle.TxnRoll(this.cluster, rollPolicy, this.txn, records[i], status2, bn.node, txnAttr);
                continue;
            }
            commands[count++] = new Batch.TxnRoll(this.cluster, bn, rollPolicy, this.txn, keys, records, attr, status2);
        }
        BatchExecutor.execute(this.cluster, rollPolicy, commands, status2);
        if (!status2.getStatus()) {
            String rollString = txnAttr == 2 ? "commit" : "abort";
            throw new RuntimeException("Failed to " + rollString + " one or more records");
        }
    }

    private void close(WritePolicy writePolicy, Key txnKey) {
        TxnClose cmd = new TxnClose(this.cluster, this.txn, writePolicy, txnKey);
        cmd.execute();
        this.txn.clear();
    }
}

