/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaAerospikeLib;
import com.aerospike.client.lua.LuaBytes;
import com.aerospike.client.lua.LuaBytesLib;
import com.aerospike.client.lua.LuaCache;
import com.aerospike.client.lua.LuaGeoJSON;
import com.aerospike.client.lua.LuaList;
import com.aerospike.client.lua.LuaListLib;
import com.aerospike.client.lua.LuaMap;
import com.aerospike.client.lua.LuaMapLib;
import com.aerospike.client.lua.LuaStreamLib;
import com.aerospike.client.lua.LuaUnpacker;
import com.aerospike.client.query.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.CoroutineLib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.StringLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseIoLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseOsLib;
import org.luaj.vm2.lib.jse.LuajavaLib;

public final class LuaInstance {
    private final Globals globals = new Globals();
    private final LuaTable loadedTable;

    public LuaInstance() throws AerospikeException {
        this.globals.load(new JseBaseLib());
        this.globals.load(new PackageLib());
        this.globals.load(new TableLib());
        this.globals.load(new StringLib());
        this.globals.load(new CoroutineLib());
        this.globals.load(new JseMathLib());
        this.globals.load(new JseIoLib());
        this.globals.load(new JseOsLib());
        this.globals.load(new LuajavaLib());
        this.globals.load(new DebugLib());
        LuaTable packageTable = (LuaTable)this.globals.get("package");
        this.loadedTable = (LuaTable)packageTable.get("loaded");
        this.globals.load(new LuaBytesLib(this));
        this.globals.load(new LuaListLib(this));
        this.globals.load(new LuaMapLib(this));
        this.globals.load(new LuaStreamLib(this));
        LuaC.install(this.globals);
        ClassLoader resourceLoader = LuaInstance.class.getClassLoader();
        this.loadSystemPackage(resourceLoader, "compat52");
        this.loadSystemPackage(resourceLoader, "stream_ops");
        this.loadSystemPackage(resourceLoader, "aerospike");
        this.globals.load(new LuaAerospikeLib(this));
        LoadState.install(this.globals);
    }

    public void registerPackage(String packageName, LuaTable table) {
        this.globals.set(packageName, (LuaValue)table);
        this.loadedTable.set(packageName, (LuaValue)LuaValue.TRUE);
    }

    public LuaValue getPackage(String packageName) {
        return this.globals.get(packageName);
    }

    public void loadPackage(Statement statement) {
        if (this.loadedTable.get(statement.getPackageName()).toboolean()) {
            return;
        }
        Prototype prototype = statement.getResourceLoader() == null || statement.getResourcePath() == null ? LuaCache.loadPackageFromFile(statement.getPackageName()) : LuaCache.loadPackageFromResource(statement.getResourceLoader(), statement.getResourcePath(), statement.getPackageName());
        LuaClosure function = new LuaClosure(prototype, this.globals);
        function.invoke();
        this.loadedTable.set(statement.getPackageName(), (LuaValue)LuaValue.TRUE);
    }

    private void loadSystemPackage(ClassLoader resourceLoader, String packageName) {
        String resourcePath = "udf/" + packageName + ".lua";
        Prototype prototype = LuaCache.loadPackageFromResource(resourceLoader, resourcePath, packageName);
        LuaClosure function = new LuaClosure(prototype, this.globals);
        function.invoke();
        this.loadedTable.set(packageName, (LuaValue)LuaValue.TRUE);
    }

    public void unloadPackage(String packageName) {
        this.loadedTable.set(packageName, (LuaValue)LuaValue.FALSE);
    }

    public void load(LibFunction function) {
        this.globals.load(function);
    }

    public void call(String functionName, LuaValue[] args) {
        this.globals.get(functionName).invoke(args);
    }

    public LuaValue getFunction(String functionName) {
        return this.globals.get(functionName);
    }

    public LuaValue getLuaValue(int type2, byte[] buf, int offset, int len2) throws AerospikeException {
        if (len2 <= 0) {
            return LuaValue.NIL;
        }
        switch (type2) {
            case 3: {
                byte[] copy = new byte[len2];
                System.arraycopy(buf, offset, copy, 0, len2);
                return LuaString.valueOf(copy, 0, len2);
            }
            case 1: {
                if (len2 <= 4) {
                    return LuaInteger.valueOf(Buffer.bytesToInt(buf, offset));
                }
                if (len2 <= 8) {
                    return LuaInteger.valueOf(Buffer.bytesToLong(buf, offset));
                }
                throw new AerospikeException("Lua BigInteger not implemented.");
            }
            case 17: {
                return LuaBoolean.valueOf(Buffer.bytesToBool(buf, offset, len2));
            }
            case 2: {
                return LuaDouble.valueOf(Buffer.bytesToDouble(buf, offset));
            }
            case 4: {
                byte[] blob = new byte[len2];
                System.arraycopy(buf, offset, blob, 0, len2);
                return new LuaBytes(this, blob);
            }
            case 7: {
                byte[] blob = new byte[len2];
                System.arraycopy(buf, offset, blob, 0, len2);
                return new LuaBytes(this, blob);
            }
            case 20: {
                LuaUnpacker unpacker = new LuaUnpacker(this, buf, offset, len2);
                return (LuaValue)unpacker.unpackList();
            }
            case 19: {
                LuaUnpacker unpacker = new LuaUnpacker(this, buf, offset, len2);
                return (LuaValue)unpacker.unpackMap();
            }
            case 23: {
                int ncells = Buffer.bytesToShort(buf, offset + 1);
                int hdrsz = 3 + ncells * 8;
                return new LuaGeoJSON(new String(buf, offset + hdrsz, len2 - hdrsz));
            }
        }
        return LuaValue.NIL;
    }

    public LuaList getLuaList(List<?> list) {
        ArrayList<LuaValue> luaList = new ArrayList<LuaValue>();
        for (Object obj : list) {
            luaList.add(this.getLuaValue(obj));
        }
        return new LuaList(this, luaList);
    }

    public LuaList getLuaList(Value[] array) {
        ArrayList<LuaValue> luaList = new ArrayList<LuaValue>();
        for (Value value : array) {
            luaList.add(value.getLuaValue(this));
        }
        return new LuaList(this, luaList);
    }

    public LuaMap getLuaMap(Map<?, ?> map) {
        HashMap<LuaValue, LuaValue> luaMap = new HashMap<LuaValue, LuaValue>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            LuaValue key = this.getLuaValue(entry.getKey());
            LuaValue value = this.getLuaValue(entry.getValue());
            luaMap.put(key, value);
        }
        return new LuaMap(this, luaMap);
    }

    public LuaValue getLuaValue(Object obj) {
        if (obj == null) {
            return LuaValue.NIL;
        }
        if (obj instanceof LuaValue) {
            return (LuaValue)obj;
        }
        if (obj instanceof Value) {
            Value value = (Value)obj;
            return value.getLuaValue(this);
        }
        if (obj instanceof byte[]) {
            return new LuaBytes(this, (byte[])obj);
        }
        if (obj instanceof String) {
            return LuaString.valueOf((String)obj);
        }
        if (obj instanceof Integer) {
            return LuaInteger.valueOf((Integer)obj);
        }
        if (obj instanceof Long) {
            return LuaInteger.valueOf((Long)obj);
        }
        if (obj instanceof Double) {
            return LuaDouble.valueOf((Double)obj);
        }
        if (obj instanceof Float) {
            return LuaDouble.valueOf(((Float)obj).floatValue());
        }
        if (obj instanceof Boolean) {
            return LuaBoolean.valueOf((Boolean)obj);
        }
        if (obj instanceof List) {
            return this.getLuaList((List)obj);
        }
        if (obj instanceof Map) {
            return this.getLuaMap((Map)obj);
        }
        return LuaValue.NIL;
    }
}

