/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.metrics;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Log;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.ConnectionStats;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.metrics.LatencyBuckets;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.metrics.MetricsListener;
import com.aerospike.client.metrics.MetricsPolicy;
import com.aerospike.client.metrics.NodeMetrics;
import com.aerospike.client.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public final class MetricsWriter
implements MetricsListener {
    private static final DateTimeFormatter FilenameFormat = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter TimestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final int MinFileSize = 1000000;
    private final String dir;
    private final StringBuilder sb;
    private FileWriter writer;
    private long size;
    private long maxSize;
    private int latencyColumns;
    private int latencyShift;
    private boolean enabled;

    public MetricsWriter(String dir) {
        this.dir = dir;
        this.sb = new StringBuilder(8192);
    }

    @Override
    public void onEnable(Cluster cluster, MetricsPolicy policy) {
        if (policy.reportSizeLimit != 0L && policy.reportSizeLimit < 1000000L) {
            throw new AerospikeException("MetricsPolicy.reportSizeLimit " + policy.reportSizeLimit + " must be at least " + 1000000);
        }
        this.maxSize = policy.reportSizeLimit;
        this.latencyColumns = policy.latencyColumns;
        this.latencyShift = policy.latencyShift;
        try {
            Files.createDirectories(Paths.get(this.dir, new String[0]), new FileAttribute[0]);
            this.open();
        }
        catch (IOException ioe) {
            throw new AerospikeException(ioe);
        }
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSnapshot(Cluster cluster) {
        MetricsWriter metricsWriter = this;
        synchronized (metricsWriter) {
            if (this.enabled) {
                this.writeCluster(cluster);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNodeClose(Node node) {
        MetricsWriter metricsWriter = this;
        synchronized (metricsWriter) {
            if (this.enabled) {
                this.sb.setLength(0);
                this.sb.append(LocalDateTime.now().format(TimestampFormat));
                this.sb.append(" node");
                this.writeNode(node);
                this.writeLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisable(Cluster cluster) {
        MetricsWriter metricsWriter = this;
        synchronized (metricsWriter) {
            if (this.enabled) {
                try {
                    this.enabled = false;
                    this.writeCluster(cluster);
                    this.writer.close();
                }
                catch (Throwable e) {
                    Log.error("Failed to close metrics writer: " + Util.getErrorMessage(e));
                }
            }
        }
    }

    private void open() throws IOException {
        LocalDateTime now = LocalDateTime.now();
        String path = this.dir + File.separator + "metrics-" + now.format(FilenameFormat) + ".log";
        this.writer = new FileWriter(path, true);
        this.size = 0L;
        this.sb.setLength(0);
        this.sb.append(now.format(TimestampFormat));
        this.sb.append(" header(1)");
        this.sb.append(" cluster[name,cpu,mem,threadsInUse,recoverQueueSize,invalidNodeCount,commandCount,retryCount,delayQueueTimeoutCount,eventloop[],node[]]");
        this.sb.append(" eventloop[processSize,queueSize]");
        this.sb.append(" node[name,address,port,syncConn,asyncConn,errors,timeouts,latency[]]");
        this.sb.append(" conn[inUse,inPool,opened,closed]");
        this.sb.append(" latency(");
        this.sb.append(this.latencyColumns);
        this.sb.append(',');
        this.sb.append(this.latencyShift);
        this.sb.append(')');
        this.sb.append("[type[l1,l2,l3...]]");
        this.writeLine();
    }

    private void writeCluster(Cluster cluster) {
        String clusterName = cluster.getClusterName();
        if (clusterName == null) {
            clusterName = "";
        }
        double cpu = Util.getProcessCpuLoad();
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.sb.setLength(0);
        this.sb.append(LocalDateTime.now().format(TimestampFormat));
        this.sb.append(" cluster[");
        this.sb.append(clusterName);
        this.sb.append(',');
        this.sb.append((int)cpu);
        this.sb.append(',');
        this.sb.append(mem);
        this.sb.append(',');
        this.sb.append(cluster.getThreadsInUse());
        this.sb.append(',');
        this.sb.append(cluster.getRecoverQueueSize());
        this.sb.append(',');
        this.sb.append(cluster.getInvalidNodeCount());
        this.sb.append(',');
        this.sb.append(cluster.getCommandCount());
        this.sb.append(',');
        this.sb.append(cluster.getRetryCount());
        this.sb.append(',');
        this.sb.append(cluster.getDelayQueueTimeoutCount());
        this.sb.append(",[");
        EventLoop[] eventLoops = cluster.getEventLoopArray();
        if (eventLoops != null) {
            for (int i = 0; i < eventLoops.length; ++i) {
                EventLoop el = eventLoops[i];
                if (i > 0) {
                    this.sb.append(',');
                }
                this.sb.append('[');
                this.sb.append(el.getProcessSize());
                this.sb.append(',');
                this.sb.append(el.getQueueSize());
                this.sb.append(']');
            }
        }
        this.sb.append("],[");
        Node[] nodes = cluster.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (i > 0) {
                this.sb.append(',');
            }
            this.writeNode(node);
        }
        this.sb.append("]]");
        this.writeLine();
    }

    private void writeNode(Node node) {
        this.sb.append('[');
        this.sb.append(node.getName());
        this.sb.append(',');
        Host host = node.getHost();
        this.sb.append(host.name);
        this.sb.append(',');
        this.sb.append(host.port);
        this.sb.append(',');
        this.writeConn(node.getConnectionStats());
        this.sb.append(',');
        this.writeConn(node.getAsyncConnectionStats());
        this.sb.append(',');
        this.sb.append(node.getErrorCount());
        this.sb.append(',');
        this.sb.append(node.getTimeoutCount());
        this.sb.append(",[");
        NodeMetrics nm = node.getMetrics();
        int max2 = LatencyType.getMax();
        for (int i = 0; i < max2; ++i) {
            if (i > 0) {
                this.sb.append(',');
            }
            this.sb.append(LatencyType.getString(i));
            this.sb.append('[');
            LatencyBuckets buckets = nm.getLatencyBuckets(i);
            int bucketMax = buckets.getMax();
            for (int j = 0; j < bucketMax; ++j) {
                if (j > 0) {
                    this.sb.append(',');
                }
                this.sb.append(buckets.getBucket(j));
            }
            this.sb.append(']');
        }
        this.sb.append("]]");
    }

    private void writeConn(ConnectionStats cs) {
        this.sb.append(cs.inUse);
        this.sb.append(',');
        this.sb.append(cs.inPool);
        this.sb.append(',');
        this.sb.append(cs.opened);
        this.sb.append(',');
        this.sb.append(cs.closed);
    }

    private void writeLine() {
        try {
            this.sb.append(System.lineSeparator());
            this.writer.write(this.sb.toString());
            this.size += (long)this.sb.length();
            this.writer.flush();
            if (this.maxSize > 0L && this.size >= this.maxSize) {
                this.writer.close();
                this.open();
            }
        }
        catch (IOException ioe) {
            this.enabled = false;
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AerospikeException(ioe);
        }
    }
}

