/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncWriteBase;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.WritePolicy;

public final class AsyncTouch
extends AsyncWriteBase {
    private final WriteListener writeListener;
    private final ExistsListener existsListener;
    private boolean touched;

    public AsyncTouch(Cluster cluster, WriteListener listener, WritePolicy writePolicy, Key key) {
        super(cluster, writePolicy, key);
        this.writeListener = listener;
        this.existsListener = null;
    }

    public AsyncTouch(Cluster cluster, ExistsListener listener, WritePolicy writePolicy, Key key) {
        super(cluster, writePolicy, key);
        this.writeListener = null;
        this.existsListener = listener;
    }

    @Override
    protected void writeBuffer() {
        this.setTouch(this.writePolicy, this.key);
    }

    @Override
    protected boolean parseResult() {
        int resultCode = this.parseHeader();
        if (resultCode == 0) {
            this.touched = true;
            return true;
        }
        if (resultCode == 2) {
            if (this.existsListener == null) {
                throw new AerospikeException(resultCode);
            }
            this.touched = false;
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            this.touched = false;
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected void onSuccess() {
        if (this.writeListener != null) {
            this.writeListener.onSuccess(this.key);
        } else if (this.existsListener != null) {
            this.existsListener.onSuccess(this.key, this.touched);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.writeListener != null) {
            this.writeListener.onFailure(e);
        } else if (this.existsListener != null) {
            this.existsListener.onFailure(e);
        }
    }
}

