/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Txn;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncTxnAddKeys;
import com.aerospike.client.async.AsyncWriteBase;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.command.TxnMonitor;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.util.Util;
import java.util.List;

public abstract class AsyncTxnMonitor {
    final EventLoop eventLoop;
    final Cluster cluster;

    public static void execute(EventLoop eventLoop, Cluster cluster, WritePolicy policy, AsyncWriteBase command) {
        if (policy.txn == null) {
            eventLoop.execute(cluster, command);
            return;
        }
        Txn txn = policy.txn;
        Key cmdKey = command.key;
        if (txn.getWrites().contains(cmdKey)) {
            eventLoop.execute(cluster, command);
            return;
        }
        Operation[] ops = TxnMonitor.getTranOps(txn, cmdKey);
        Single ate = new Single(eventLoop, cluster, command);
        ate.execute(policy, ops);
    }

    public static void executeBatch(BatchPolicy policy, AsyncBatchExecutor executor, AsyncCommand[] commands, Key[] keys) {
        if (policy.txn == null) {
            executor.execute(commands);
            return;
        }
        Operation[] ops = TxnMonitor.getTranOps(policy.txn, keys);
        Batch ate = new Batch(executor, commands);
        ate.execute(policy, ops);
    }

    public static void executeBatch(BatchPolicy policy, AsyncBatchExecutor executor, AsyncCommand[] commands, List<BatchRecord> records) {
        if (policy.txn == null) {
            executor.execute(commands);
            return;
        }
        Operation[] ops = TxnMonitor.getTranOps(policy.txn, records);
        if (ops == null) {
            executor.execute(commands);
            return;
        }
        Batch ate = new Batch(executor, commands);
        ate.execute(policy, ops);
    }

    private AsyncTxnMonitor(EventLoop eventLoop, Cluster cluster) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
    }

    void execute(Policy policy, Operation[] ops) {
        Txn txn = policy.txn;
        Key tranKey = TxnMonitor.getTxnMonitorKey(txn);
        WritePolicy wp = TxnMonitor.copyTimeoutPolicy(policy);
        RecordListener tranListener = new RecordListener(){

            @Override
            public void onSuccess(Key key, Record record) {
                try {
                    AsyncTxnMonitor.this.runCommand();
                }
                catch (AerospikeException ae) {
                    AsyncTxnMonitor.this.notifyFailure(ae);
                }
                catch (Throwable t) {
                    AsyncTxnMonitor.this.notifyFailure(new AerospikeException(t));
                }
            }

            @Override
            public void onFailure(AerospikeException ae) {
                AsyncTxnMonitor.this.notifyFailure(new AerospikeException(-17, "Failed to add key(s) to MRT monitor", ae));
            }
        };
        OperateArgs args = new OperateArgs(wp, null, null, ops);
        AsyncTxnAddKeys tranCommand = new AsyncTxnAddKeys(this.cluster, tranListener, tranKey, args, txn);
        this.eventLoop.execute(this.cluster, tranCommand);
    }

    private void notifyFailure(AerospikeException ae) {
        try {
            this.onFailure(ae);
        }
        catch (Throwable t) {
            Log.error("notifyCommandFailure onFailure() failed: " + Util.getStackTrace(t));
        }
    }

    abstract void onFailure(AerospikeException var1);

    abstract void runCommand();

    private static class Batch
    extends AsyncTxnMonitor {
        private final AsyncBatchExecutor executor;
        private final AsyncCommand[] commands;

        private Batch(AsyncBatchExecutor executor, AsyncCommand[] commands) {
            super(executor.eventLoop, executor.cluster);
            this.executor = executor;
            this.commands = commands;
        }

        @Override
        void runCommand() {
            this.executor.execute(this.commands);
        }

        @Override
        void onFailure(AerospikeException ae) {
            this.executor.onFailure(ae);
        }
    }

    private static class Single
    extends AsyncTxnMonitor {
        private final AsyncWriteBase command;

        private Single(EventLoop eventLoop, Cluster cluster, AsyncWriteBase command) {
            super(eventLoop, cluster);
            this.command = command;
        }

        @Override
        void runCommand() {
            this.eventLoop.execute(this.cluster, this.command);
        }

        @Override
        void onFailure(AerospikeException ae) {
            this.command.onFailure(ae);
        }
    }
}

