/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncReadCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public class ReadCommand
extends SyncReadCommand {
    private final String[] binNames;
    private final boolean isOperation;
    private Record record;

    public ReadCommand(Cluster cluster, Policy policy, Key key) {
        super(cluster, policy, key);
        this.binNames = null;
        this.isOperation = false;
    }

    public ReadCommand(Cluster cluster, Policy policy, Key key, String[] binNames) {
        super(cluster, policy, key);
        this.binNames = binNames;
        this.isOperation = false;
    }

    public ReadCommand(Cluster cluster, Policy policy, Key key, boolean isOperation) {
        super(cluster, policy, key);
        this.binNames = null;
        this.isOperation = isOperation;
    }

    @Override
    protected void writeBuffer() {
        this.setRead(this.policy, this.key, this.binNames);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        RecordParser rp = new RecordParser(conn, this.dataBuffer);
        rp.parseFields(this.policy.txn, this.key, false);
        if (rp.resultCode == 0) {
            this.record = rp.parseRecord(this.isOperation);
            return;
        }
        if (rp.resultCode == 2) {
            return;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            return;
        }
        throw new AerospikeException(rp.resultCode);
    }

    public Record getRecord() {
        return this.record;
    }
}

