/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.operation;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.operation.HLLPolicy;
import com.aerospike.client.util.Pack;
import java.util.List;

public final class HLLOperation {
    private static final int INIT = 0;
    private static final int ADD = 1;
    private static final int SET_UNION = 2;
    private static final int SET_COUNT = 3;
    private static final int FOLD = 4;
    private static final int COUNT = 50;
    private static final int UNION = 51;
    private static final int UNION_COUNT = 52;
    private static final int INTERSECT_COUNT = 53;
    private static final int SIMILARITY = 54;
    private static final int DESCRIBE = 55;

    public static Operation init(HLLPolicy policy, String binName, int indexBitCount) {
        return HLLOperation.init(policy, binName, indexBitCount, -1);
    }

    public static Operation init(HLLPolicy policy, String binName, int indexBitCount, int minHashBitCount) {
        byte[] bytes = Pack.pack(0, indexBitCount, minHashBitCount, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(bytes));
    }

    public static Operation add(HLLPolicy policy, String binName, List<Value> list) {
        return HLLOperation.add(policy, binName, list, -1, -1);
    }

    public static Operation add(HLLPolicy policy, String binName, List<Value> list, int indexBitCount) {
        return HLLOperation.add(policy, binName, list, indexBitCount, -1);
    }

    public static Operation add(HLLPolicy policy, String binName, List<Value> list, int indexBitCount, int minHashBitCount) {
        byte[] bytes = Pack.pack(1, list, indexBitCount, minHashBitCount, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(bytes));
    }

    public static Operation setUnion(HLLPolicy policy, String binName, List<Value.HLLValue> list) {
        byte[] bytes = Pack.pack(2, list, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(bytes));
    }

    public static Operation refreshCount(String binName) {
        byte[] bytes = Pack.pack(3, new CTX[0]);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(bytes));
    }

    public static Operation fold(String binName, int indexBitCount) {
        byte[] bytes = Pack.pack(4, indexBitCount, new CTX[0]);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(bytes));
    }

    public static Operation getCount(String binName) {
        byte[] bytes = Pack.pack(50, new CTX[0]);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(bytes));
    }

    public static Operation getUnion(String binName, List<Value.HLLValue> list) {
        byte[] bytes = Pack.pack(51, list, new CTX[0]);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(bytes));
    }

    public static Operation getUnionCount(String binName, List<Value.HLLValue> list) {
        byte[] bytes = Pack.pack(52, list, new CTX[0]);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(bytes));
    }

    public static Operation getIntersectCount(String binName, List<Value.HLLValue> list) {
        byte[] bytes = Pack.pack(53, list, new CTX[0]);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(bytes));
    }

    public static Operation getSimilarity(String binName, List<Value.HLLValue> list) {
        byte[] bytes = Pack.pack(54, list, new CTX[0]);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(bytes));
    }

    public static Operation describe(String binName) {
        byte[] bytes = Pack.pack(55, new CTX[0]);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(bytes));
    }
}

