/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.policy;

import com.aerospike.client.Txn;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.ReadModeAP;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import java.util.Objects;

public class Policy {
    public Txn txn;
    public ReadModeAP readModeAP = ReadModeAP.ONE;
    public ReadModeSC readModeSC = ReadModeSC.SESSION;
    public Replica replica = Replica.SEQUENCE;
    public Expression filterExp;
    public int connectTimeout;
    public int socketTimeout = 30000;
    public int totalTimeout = 1000;
    public int timeoutDelay;
    public int maxRetries = 2;
    public int sleepBetweenRetries;
    public int readTouchTtlPercent;
    public boolean sendKey;
    public boolean compress;
    public boolean failOnFilteredOut;

    public Policy(Policy other) {
        this.txn = other.txn;
        this.readModeAP = other.readModeAP;
        this.readModeSC = other.readModeSC;
        this.replica = other.replica;
        this.filterExp = other.filterExp;
        this.connectTimeout = other.connectTimeout;
        this.socketTimeout = other.socketTimeout;
        this.totalTimeout = other.totalTimeout;
        this.timeoutDelay = other.timeoutDelay;
        this.maxRetries = other.maxRetries;
        this.sleepBetweenRetries = other.sleepBetweenRetries;
        this.readTouchTtlPercent = other.readTouchTtlPercent;
        this.sendKey = other.sendKey;
        this.compress = other.compress;
        this.failOnFilteredOut = other.failOnFilteredOut;
    }

    public Policy() {
    }

    public final void setTimeout(int timeout) {
        this.socketTimeout = timeout;
        this.totalTimeout = timeout;
    }

    public final void setTimeouts(int socketTimeout, int totalTimeout) {
        this.socketTimeout = socketTimeout;
        this.totalTimeout = totalTimeout;
        if (totalTimeout > 0 && (socketTimeout == 0 || socketTimeout > totalTimeout)) {
            this.socketTimeout = totalTimeout;
        }
    }

    public void setTxn(Txn txn) {
        this.txn = txn;
    }

    public void setReadModeAP(ReadModeAP readModeAP) {
        this.readModeAP = readModeAP;
    }

    public void setReadModeSC(ReadModeSC readModeSC) {
        this.readModeSC = readModeSC;
    }

    public void setReplica(Replica replica) {
        this.replica = replica;
    }

    public void setFilterExp(Expression filterExp) {
        this.filterExp = filterExp;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setTotalTimeout(int totalTimeout) {
        this.totalTimeout = totalTimeout;
    }

    public void setTimeoutDelay(int timeoutDelay) {
        this.timeoutDelay = timeoutDelay;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public void setReadTouchTtlPercent(int readTouchTtlPercent) {
        this.readTouchTtlPercent = readTouchTtlPercent;
    }

    public void setSendKey(boolean sendKey) {
        this.sendKey = sendKey;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setFailOnFilteredOut(boolean failOnFilteredOut) {
        this.failOnFilteredOut = failOnFilteredOut;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return this.connectTimeout == policy.connectTimeout && this.socketTimeout == policy.socketTimeout && this.totalTimeout == policy.totalTimeout && this.timeoutDelay == policy.timeoutDelay && this.maxRetries == policy.maxRetries && this.sleepBetweenRetries == policy.sleepBetweenRetries && this.readTouchTtlPercent == policy.readTouchTtlPercent && this.sendKey == policy.sendKey && this.compress == policy.compress && this.failOnFilteredOut == policy.failOnFilteredOut && Objects.equals(this.txn, policy.txn) && this.readModeAP == policy.readModeAP && this.readModeSC == policy.readModeSC && this.replica == policy.replica && Objects.equals(this.filterExp, policy.filterExp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.txn, this.readModeAP, this.readModeSC, this.replica, this.filterExp, this.connectTimeout, this.socketTimeout, this.totalTimeout, this.timeoutDelay, this.maxRetries, this.sleepBetweenRetries, this.readTouchTtlPercent, this.sendKey, this.compress, this.failOnFilteredOut});
    }
}

