/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Util;
import java.util.concurrent.TimeUnit;

public abstract class Task {
    public static final int NOT_FOUND = 0;
    public static final int IN_PROGRESS = 1;
    public static final int COMPLETE = 2;
    protected final Cluster cluster;
    protected InfoPolicy policy;
    private boolean done;

    public Task(Cluster cluster, Policy policy) {
        this.cluster = cluster;
        this.policy = new InfoPolicy(policy);
        this.done = false;
    }

    public Task() {
        this.cluster = null;
        this.policy = null;
        this.done = true;
    }

    public final void waitTillComplete() {
        this.taskWait(1000);
    }

    public final void waitTillComplete(int sleepInterval) {
        this.taskWait(sleepInterval);
    }

    public final void waitTillComplete(int sleepInterval, int timeout) {
        this.policy = new InfoPolicy();
        this.policy.timeout = timeout;
        this.taskWait(sleepInterval);
    }

    private final void taskWait(int sleepInterval) {
        if (this.done) {
            return;
        }
        long deadline = this.policy.timeout > 0 ? System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.policy.timeout) : 0L;
        int iteration = 1;
        while (true) {
            Util.sleep(sleepInterval);
            int status = this.queryStatus();
            if (status == 2 || status == 0 && this.policy.timeout == 0) {
                this.done = true;
                return;
            }
            if (this.policy.timeout > 0 && System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(sleepInterval) > deadline) {
                if (status == 0) {
                    this.done = true;
                    return;
                }
                throw new AerospikeException.Timeout("Client timeout in taskWait()", iteration, this.policy.timeout, true);
            }
            ++iteration;
        }
    }

    public final boolean isDone() {
        if (this.done) {
            return true;
        }
        int status = this.queryStatus();
        if (status == 0) {
            Util.sleep(1000L);
            status = this.queryStatus();
        }
        this.done = status != 1;
        return this.done;
    }

    public abstract int queryStatus();
}

