/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AbortStatus;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchDelete;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchResults;
import com.aerospike.client.BatchUDF;
import com.aerospike.client.BatchWrite;
import com.aerospike.client.Bin;
import com.aerospike.client.CommitStatus;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Language;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.Txn;
import com.aerospike.client.Value;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.admin.Privilege;
import com.aerospike.client.admin.Role;
import com.aerospike.client.admin.User;
import com.aerospike.client.async.AsyncBatch;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncBatchSingle;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncDelete;
import com.aerospike.client.async.AsyncExecute;
import com.aerospike.client.async.AsyncExists;
import com.aerospike.client.async.AsyncIndexTask;
import com.aerospike.client.async.AsyncInfoCommand;
import com.aerospike.client.async.AsyncOperateRead;
import com.aerospike.client.async.AsyncOperateWrite;
import com.aerospike.client.async.AsyncQueryExecutor;
import com.aerospike.client.async.AsyncQueryPartitionExecutor;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.async.AsyncReadHeader;
import com.aerospike.client.async.AsyncScanPartitionExecutor;
import com.aerospike.client.async.AsyncTouch;
import com.aerospike.client.async.AsyncTxnMonitor;
import com.aerospike.client.async.AsyncTxnRoll;
import com.aerospike.client.async.AsyncWrite;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.ClusterStats;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Batch;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchExecutor;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.BatchSingle;
import com.aerospike.client.command.BatchStatus;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.DeleteCommand;
import com.aerospike.client.command.ExecuteCommand;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.ExistsCommand;
import com.aerospike.client.command.IBatchCommand;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.command.OperateCommandRead;
import com.aerospike.client.command.OperateCommandWrite;
import com.aerospike.client.command.ReadCommand;
import com.aerospike.client.command.ReadHeaderCommand;
import com.aerospike.client.command.RegisterCommand;
import com.aerospike.client.command.ScanExecutor;
import com.aerospike.client.command.TouchCommand;
import com.aerospike.client.command.TxnMonitor;
import com.aerospike.client.command.TxnRoll;
import com.aerospike.client.command.WriteCommand;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.listener.AbortListener;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchOperateListListener;
import com.aerospike.client.listener.BatchRecordArrayListener;
import com.aerospike.client.listener.BatchRecordSequenceListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ClusterStatsListener;
import com.aerospike.client.listener.CommitListener;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.IndexListener;
import com.aerospike.client.listener.InfoListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.metrics.MetricsPolicy;
import com.aerospike.client.policy.AdminPolicy;
import com.aerospike.client.policy.BatchDeletePolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.BatchUDFPolicy;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.TxnRollPolicy;
import com.aerospike.client.policy.TxnVerifyPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.PartitionFilter;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.QueryAggregateExecutor;
import com.aerospike.client.query.QueryListener;
import com.aerospike.client.query.QueryListenerExecutor;
import com.aerospike.client.query.QueryPartitionExecutor;
import com.aerospike.client.query.QueryRecordExecutor;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.ServerCommand;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.ExecuteTask;
import com.aerospike.client.task.IndexTask;
import com.aerospike.client.task.RegisterTask;
import com.aerospike.client.util.Crypto;
import com.aerospike.client.util.Pack;
import com.aerospike.client.util.Packer;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class AerospikeClient
implements IAerospikeClient,
Closeable {
    protected Cluster cluster;
    public final Policy readPolicyDefault;
    public final WritePolicy writePolicyDefault;
    public final ScanPolicy scanPolicyDefault;
    public final QueryPolicy queryPolicyDefault;
    public final BatchPolicy batchPolicyDefault;
    public final BatchPolicy batchParentPolicyWriteDefault;
    public final BatchWritePolicy batchWritePolicyDefault;
    public final BatchDeletePolicy batchDeletePolicyDefault;
    public final BatchUDFPolicy batchUDFPolicyDefault;
    public final InfoPolicy infoPolicyDefault;
    public final TxnVerifyPolicy txnVerifyPolicyDefault;
    public final TxnRollPolicy txnRollPolicyDefault;
    private final WritePolicy operatePolicyReadDefault;

    public AerospikeClient(String hostname, int port) throws AerospikeException {
        this(new ClientPolicy(), new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, Host ... hosts) throws AerospikeException {
        if (policy == null) {
            policy = new ClientPolicy();
        }
        this.readPolicyDefault = policy.readPolicyDefault;
        this.writePolicyDefault = policy.writePolicyDefault;
        this.scanPolicyDefault = policy.scanPolicyDefault;
        this.queryPolicyDefault = policy.queryPolicyDefault;
        this.batchPolicyDefault = policy.batchPolicyDefault;
        this.batchParentPolicyWriteDefault = policy.batchParentPolicyWriteDefault;
        this.batchWritePolicyDefault = policy.batchWritePolicyDefault;
        this.batchDeletePolicyDefault = policy.batchDeletePolicyDefault;
        this.batchUDFPolicyDefault = policy.batchUDFPolicyDefault;
        this.infoPolicyDefault = policy.infoPolicyDefault;
        this.txnVerifyPolicyDefault = policy.txnVerifyPolicyDefault;
        this.txnRollPolicyDefault = policy.txnRollPolicyDefault;
        this.operatePolicyReadDefault = new WritePolicy(this.readPolicyDefault);
        this.cluster = new Cluster(this, policy, hosts);
    }

    protected AerospikeClient(ClientPolicy policy) {
        if (policy != null) {
            this.readPolicyDefault = policy.readPolicyDefault;
            this.writePolicyDefault = policy.writePolicyDefault;
            this.scanPolicyDefault = policy.scanPolicyDefault;
            this.queryPolicyDefault = policy.queryPolicyDefault;
            this.batchPolicyDefault = policy.batchPolicyDefault;
            this.batchParentPolicyWriteDefault = policy.batchParentPolicyWriteDefault;
            this.batchWritePolicyDefault = policy.batchWritePolicyDefault;
            this.batchDeletePolicyDefault = policy.batchDeletePolicyDefault;
            this.batchUDFPolicyDefault = policy.batchUDFPolicyDefault;
            this.infoPolicyDefault = policy.infoPolicyDefault;
            this.txnVerifyPolicyDefault = policy.txnVerifyPolicyDefault;
            this.txnRollPolicyDefault = policy.txnRollPolicyDefault;
            this.operatePolicyReadDefault = new WritePolicy(this.readPolicyDefault);
        } else {
            this.readPolicyDefault = new Policy();
            this.writePolicyDefault = new WritePolicy();
            this.scanPolicyDefault = new ScanPolicy();
            this.queryPolicyDefault = new QueryPolicy();
            this.batchPolicyDefault = new BatchPolicy();
            this.batchParentPolicyWriteDefault = BatchPolicy.WriteDefault();
            this.batchWritePolicyDefault = new BatchWritePolicy();
            this.batchDeletePolicyDefault = new BatchDeletePolicy();
            this.batchUDFPolicyDefault = new BatchUDFPolicy();
            this.infoPolicyDefault = new InfoPolicy();
            this.txnVerifyPolicyDefault = new TxnVerifyPolicy();
            this.txnRollPolicyDefault = new TxnRollPolicy();
            this.operatePolicyReadDefault = new WritePolicy(this.readPolicyDefault);
        }
    }

    @Override
    public final Policy getReadPolicyDefault() {
        return this.readPolicyDefault;
    }

    @Override
    public final Policy copyReadPolicyDefault() {
        return new Policy(this.readPolicyDefault);
    }

    @Override
    public final WritePolicy getWritePolicyDefault() {
        return this.writePolicyDefault;
    }

    @Override
    public final WritePolicy copyWritePolicyDefault() {
        return new WritePolicy(this.writePolicyDefault);
    }

    @Override
    public final ScanPolicy getScanPolicyDefault() {
        return this.scanPolicyDefault;
    }

    @Override
    public final ScanPolicy copyScanPolicyDefault() {
        return new ScanPolicy(this.scanPolicyDefault);
    }

    @Override
    public final QueryPolicy getQueryPolicyDefault() {
        return this.queryPolicyDefault;
    }

    @Override
    public final QueryPolicy copyQueryPolicyDefault() {
        return new QueryPolicy(this.queryPolicyDefault);
    }

    @Override
    public final BatchPolicy getBatchPolicyDefault() {
        return this.batchPolicyDefault;
    }

    @Override
    public final BatchPolicy copyBatchPolicyDefault() {
        return new BatchPolicy(this.batchPolicyDefault);
    }

    @Override
    public final BatchPolicy getBatchParentPolicyWriteDefault() {
        return this.batchParentPolicyWriteDefault;
    }

    @Override
    public final BatchPolicy copyBatchParentPolicyWriteDefault() {
        return new BatchPolicy(this.batchParentPolicyWriteDefault);
    }

    @Override
    public final BatchWritePolicy getBatchWritePolicyDefault() {
        return this.batchWritePolicyDefault;
    }

    @Override
    public final BatchWritePolicy copyBatchWritePolicyDefault() {
        return new BatchWritePolicy(this.batchWritePolicyDefault);
    }

    @Override
    public final BatchDeletePolicy getBatchDeletePolicyDefault() {
        return this.batchDeletePolicyDefault;
    }

    @Override
    public final BatchDeletePolicy copyBatchDeletePolicyDefault() {
        return new BatchDeletePolicy(this.batchDeletePolicyDefault);
    }

    @Override
    public final BatchUDFPolicy getBatchUDFPolicyDefault() {
        return this.batchUDFPolicyDefault;
    }

    @Override
    public final BatchUDFPolicy copyBatchUDFPolicyDefault() {
        return new BatchUDFPolicy(this.batchUDFPolicyDefault);
    }

    @Override
    public final InfoPolicy getInfoPolicyDefault() {
        return this.infoPolicyDefault;
    }

    @Override
    public final InfoPolicy copyInfoPolicyDefault() {
        return new InfoPolicy(this.infoPolicyDefault);
    }

    @Override
    public final TxnVerifyPolicy getTxnVerifyPolicyDefault() {
        return this.txnVerifyPolicyDefault;
    }

    @Override
    public final TxnVerifyPolicy copyTxnVerifyPolicyDefault() {
        return new TxnVerifyPolicy(this.txnVerifyPolicyDefault);
    }

    @Override
    public final TxnRollPolicy getTxnRollPolicyDefault() {
        return this.txnRollPolicyDefault;
    }

    @Override
    public final TxnRollPolicy copyTxnRollPolicyDefault() {
        return new TxnRollPolicy(this.txnRollPolicyDefault);
    }

    @Override
    public void close() {
        this.cluster.close();
    }

    @Override
    public final boolean isConnected() {
        return this.cluster.isConnected();
    }

    @Override
    public final Node[] getNodes() {
        return this.cluster.getNodes();
    }

    @Override
    public final List<String> getNodeNames() {
        Node[] nodes = this.cluster.getNodes();
        ArrayList<String> names = new ArrayList<String>(nodes.length);
        for (Node node : nodes) {
            names.add(node.getName());
        }
        return names;
    }

    @Override
    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        return this.cluster.getNode(nodeName);
    }

    @Override
    public final void enableMetrics(MetricsPolicy policy) {
        this.cluster.enableMetrics(policy);
    }

    @Override
    public final void disableMetrics() {
        this.cluster.disableMetrics();
    }

    @Override
    public final ClusterStats getClusterStats() {
        return this.cluster.getStats();
    }

    @Override
    public final void getClusterStats(ClusterStatsListener listener) {
        this.cluster.getStats(listener);
    }

    @Override
    public final Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public final CommitStatus commit(Txn txn) throws AerospikeException.Commit {
        TxnRoll tr = new TxnRoll(this.cluster, txn);
        switch (txn.getState()) {
            default: {
                tr.verify(this.txnVerifyPolicyDefault, this.txnRollPolicyDefault);
                return tr.commit(this.txnRollPolicyDefault);
            }
            case VERIFIED: {
                return tr.commit(this.txnRollPolicyDefault);
            }
            case COMMITTED: {
                return CommitStatus.ALREADY_COMMITTED;
            }
            case ABORTED: 
        }
        return CommitStatus.ALREADY_ABORTED;
    }

    @Override
    public final void commit(EventLoop eventLoop, CommitListener listener, Txn txn) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        AsyncTxnRoll atr = new AsyncTxnRoll(this.cluster, eventLoop, this.txnVerifyPolicyDefault, this.txnRollPolicyDefault, txn);
        switch (txn.getState()) {
            default: {
                atr.verify(listener);
                break;
            }
            case VERIFIED: {
                atr.commit(listener);
                break;
            }
            case COMMITTED: {
                listener.onSuccess(CommitStatus.ALREADY_COMMITTED);
                break;
            }
            case ABORTED: {
                listener.onSuccess(CommitStatus.ALREADY_ABORTED);
            }
        }
    }

    @Override
    public final AbortStatus abort(Txn txn) {
        TxnRoll tr = new TxnRoll(this.cluster, txn);
        switch (txn.getState()) {
            default: {
                return tr.abort(this.txnRollPolicyDefault);
            }
            case COMMITTED: {
                return AbortStatus.ALREADY_COMMITTED;
            }
            case ABORTED: 
        }
        return AbortStatus.ALREADY_ABORTED;
    }

    @Override
    public final void abort(EventLoop eventLoop, AbortListener listener, Txn txn) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        AsyncTxnRoll atr = new AsyncTxnRoll(this.cluster, eventLoop, null, this.txnRollPolicyDefault, txn);
        switch (txn.getState()) {
            default: {
                atr.abort(listener);
                break;
            }
            case COMMITTED: {
                listener.onSuccess(AbortStatus.ALREADY_COMMITTED);
                break;
            }
            case ABORTED: {
                listener.onSuccess(AbortStatus.ALREADY_ABORTED);
            }
        }
    }

    @Override
    public final void put(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.WRITE);
        command.execute();
    }

    @Override
    public final void put(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.WRITE);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final void append(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.APPEND);
        command.execute();
    }

    @Override
    public final void append(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.APPEND);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final void prepend(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.PREPEND);
        command.execute();
    }

    @Override
    public final void prepend(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.PREPEND);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final void add(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.ADD);
        command.execute();
    }

    @Override
    public final void add(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, listener, policy, key, bins, Operation.Type.ADD);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final boolean delete(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        DeleteCommand command = new DeleteCommand(this.cluster, policy, key);
        command.execute();
        return command.existed();
    }

    @Override
    public final void delete(EventLoop eventLoop, DeleteListener listener, WritePolicy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncDelete command = new AsyncDelete(this.cluster, listener, policy, key);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final BatchResults delete(BatchPolicy batchPolicy, BatchDeletePolicy deletePolicy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            return new BatchResults(new BatchRecord[0], true);
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (deletePolicy == null) {
            deletePolicy = this.batchDeletePolicyDefault;
        }
        if (batchPolicy.txn != null) {
            TxnMonitor.addKeys(this.cluster, batchPolicy, keys);
        }
        BatchAttr attr = new BatchAttr();
        attr.setDelete(deletePolicy);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], attr.hasWrite);
        }
        try {
            BatchStatus status2 = new BatchStatus(true);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, records, attr.hasWrite, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.Delete(this.cluster, batchPolicy, attr, records[i], status2, bn.node);
                    continue;
                }
                commands[count++] = new Batch.OperateArrayCommand(this.cluster, bn, batchPolicy, keys, null, records, attr, status2);
            }
            BatchExecutor.execute(this.cluster, batchPolicy, commands, status2);
            return new BatchResults(records, status2.getStatus());
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchRecordArray(records, e);
        }
    }

    @Override
    public final void delete(EventLoop eventLoop, BatchRecordArrayListener listener, BatchPolicy batchPolicy, BatchDeletePolicy deletePolicy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(new BatchRecord[0], true);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (deletePolicy == null) {
            deletePolicy = this.batchDeletePolicyDefault;
        }
        BatchAttr attr = new BatchAttr();
        attr.setDelete(deletePolicy);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], attr.hasWrite);
        }
        AsyncBatchExecutor.BatchRecordArray executor = new AsyncBatchExecutor.BatchRecordArray(eventLoop, this.cluster, listener, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, records, attr.hasWrite, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.Delete((AsyncBatchExecutor)executor, this.cluster, batchPolicy, attr, records[i], bn.node);
                continue;
            }
            commands[count++] = new AsyncBatch.OperateRecordArrayCommand(executor, bn, batchPolicy, keys, null, records, attr);
        }
        AsyncTxnMonitor.executeBatch(batchPolicy, (AsyncBatchExecutor)executor, commands, keys);
    }

    @Override
    public final void delete(EventLoop eventLoop, BatchRecordSequenceListener listener, BatchPolicy batchPolicy, BatchDeletePolicy deletePolicy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (deletePolicy == null) {
            deletePolicy = this.batchDeletePolicyDefault;
        }
        BatchAttr attr = new BatchAttr();
        attr.setDelete(deletePolicy);
        boolean[] sent = new boolean[keys.length];
        AsyncBatchExecutor.BatchRecordSequence executor = new AsyncBatchExecutor.BatchRecordSequence(eventLoop, this.cluster, listener, sent);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, null, attr.hasWrite, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.DeleteSequenceSent(executor, this.cluster, batchPolicy, keys[i], attr, bn.node, listener, i);
                continue;
            }
            commands[count++] = new AsyncBatch.OperateRecordSequenceCommand(executor, bn, batchPolicy, keys, null, sent, listener, attr);
        }
        AsyncTxnMonitor.executeBatch(batchPolicy, (AsyncBatchExecutor)executor, commands, keys);
    }

    @Override
    public final void truncate(InfoPolicy policy, String ns, String set, Calendar beforeLastUpdate) throws AerospikeException {
        String response;
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        Node node = this.cluster.getRandomNode();
        StringBuilder sb = new StringBuilder(200);
        if (set != null) {
            sb.append("truncate:namespace=");
            sb.append(ns);
            sb.append(";set=");
            sb.append(set);
        } else {
            sb.append("truncate-namespace:namespace=");
            sb.append(ns);
        }
        if (beforeLastUpdate != null) {
            sb.append(";lut=");
            sb.append(beforeLastUpdate.getTimeInMillis() * 1000000L);
        }
        if (!(response = Info.request(policy, node, sb.toString())).equalsIgnoreCase("ok")) {
            throw new AerospikeException("Truncate failed: " + response);
        }
    }

    @Override
    public final void touch(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        TouchCommand command = new TouchCommand(this.cluster, policy, key, true);
        command.execute();
    }

    @Override
    public final void touch(EventLoop eventLoop, WriteListener listener, WritePolicy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncTouch command = new AsyncTouch(this.cluster, listener, policy, key);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final boolean touched(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        TouchCommand command = new TouchCommand(this.cluster, policy, key, false);
        command.execute();
        return command.getTouched();
    }

    @Override
    public final void touched(EventLoop eventLoop, ExistsListener listener, WritePolicy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncTouch command = new AsyncTouch(this.cluster, listener, policy, key);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final boolean exists(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        ExistsCommand command = new ExistsCommand(this.cluster, policy, key);
        command.execute();
        return command.exists();
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsListener listener, Policy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        AsyncExists command = new AsyncExists(this.cluster, listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean[] exists(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            return new boolean[0];
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        boolean[] existsArray = new boolean[keys.length];
        try {
            BatchStatus status2 = new BatchStatus(false);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.Exists(this.cluster, policy, keys[i], existsArray, i, status2, bn.node);
                    continue;
                }
                commands[count++] = new Batch.ExistsArrayCommand(this.cluster, bn, policy, keys, existsArray, status2);
            }
            BatchExecutor.execute(this.cluster, policy, commands, status2);
            return existsArray;
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchExists(existsArray, e);
        }
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new boolean[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        boolean[] existsArray = new boolean[keys.length];
        AsyncBatchExecutor.ExistsArray executor = new AsyncBatchExecutor.ExistsArray(eventLoop, this.cluster, listener, keys, existsArray);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.Exists(executor, this.cluster, policy, keys[i], bn.node, existsArray, i);
                continue;
            }
            commands[count++] = new AsyncBatch.ExistsArrayCommand(executor, bn, policy, keys, existsArray);
        }
        executor.execute(commands);
    }

    @Override
    public final void exists(EventLoop eventLoop, ExistsSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        AsyncBatchExecutor.ExistsSequence executor = new AsyncBatchExecutor.ExistsSequence(eventLoop, this.cluster, listener);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.ExistsSequence((AsyncBatchExecutor)executor, this.cluster, policy, keys[i], bn.node, listener);
                continue;
            }
            commands[count++] = new AsyncBatch.ExistsSequenceCommand(executor, bn, policy, keys, listener);
        }
        executor.execute(commands);
    }

    @Override
    public final Record get(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        ReadCommand command = new ReadCommand(this.cluster, policy, key);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void get(EventLoop eventLoop, RecordListener listener, Policy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        AsyncRead command = new AsyncRead(this.cluster, listener, policy, key, null);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final Record get(Policy policy, Key key, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        ReadCommand command = new ReadCommand(this.cluster, policy, key, binNames);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void get(EventLoop eventLoop, RecordListener listener, Policy policy, Key key, String ... binNames) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        AsyncRead command = new AsyncRead(this.cluster, listener, policy, key, binNames);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final Record getHeader(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        ReadHeaderCommand command = new ReadHeaderCommand(this.cluster, policy, key);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordListener listener, Policy policy, Key key) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        AsyncReadHeader command = new AsyncReadHeader(this.cluster, listener, policy, key);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final boolean get(BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            return true;
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(records);
        }
        BatchStatus status2 = new BatchStatus(true);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, records, status2);
        IBatchCommand[] commands = new IBatchCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new BatchSingle.ReadRecord(this.cluster, policy, records.get(i), status2, bn.node);
                continue;
            }
            commands[count++] = new Batch.ReadListCommand(this.cluster, bn, policy, records, status2);
        }
        BatchExecutor.execute(this.cluster, policy, commands, status2);
        return status2.getStatus();
    }

    @Override
    public final void get(EventLoop eventLoop, BatchListListener listener, BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess(records);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(records);
        }
        AsyncBatchExecutor.ReadList executor = new AsyncBatchExecutor.ReadList(eventLoop, this.cluster, listener, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, records, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.Read(executor, this.cluster, policy, records.get(i), bn.node);
                continue;
            }
            commands[count++] = new AsyncBatch.ReadListCommand((AsyncBatchExecutor)executor, bn, policy, records);
        }
        executor.execute(commands);
    }

    @Override
    public final void get(EventLoop eventLoop, BatchSequenceListener listener, BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(records);
        }
        AsyncBatchExecutor.ReadSequence executor = new AsyncBatchExecutor.ReadSequence(eventLoop, this.cluster, listener);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, records, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.ReadGetSequence((AsyncBatchExecutor)executor, this.cluster, policy, records.get(i), bn.node, listener);
                continue;
            }
            commands[count++] = new AsyncBatch.ReadSequenceCommand(executor, bn, policy, listener, records);
        }
        executor.execute(commands);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            return new Record[0];
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        Record[] records = new Record[keys.length];
        try {
            BatchStatus status2 = new BatchStatus(false);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.Read(this.cluster, policy, keys[i], null, records, i, status2, bn.node, false);
                    continue;
                }
                commands[count++] = new Batch.GetArrayCommand(this.cluster, bn, policy, keys, null, null, records, 3, false, status2);
            }
            BatchExecutor.execute(this.cluster, policy, commands, status2);
            return records;
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchRecords(records, e);
        }
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        Record[] records = new Record[keys.length];
        AsyncBatchExecutor.GetArray executor = new AsyncBatchExecutor.GetArray(eventLoop, this.cluster, listener, keys, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.Get(executor, this.cluster, policy, keys[i], null, records, bn.node, i, false);
                continue;
            }
            commands[count++] = new AsyncBatch.GetArrayCommand(executor, bn, policy, keys, null, null, records, 3, false);
        }
        executor.execute(commands);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        AsyncBatchExecutor.GetSequence executor = new AsyncBatchExecutor.GetSequence(eventLoop, this.cluster, listener);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.GetSequence(executor, this.cluster, policy, listener, keys[i], null, bn.node, false);
                continue;
            }
            commands[count++] = new AsyncBatch.GetSequenceCommand(executor, bn, policy, keys, null, null, listener, 3, false);
        }
        executor.execute(commands);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (keys.length == 0) {
            return new Record[0];
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        int readAttr = binNames == null || binNames.length == 0 ? 3 : 1;
        Record[] records = new Record[keys.length];
        try {
            BatchStatus status2 = new BatchStatus(false);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.Read(this.cluster, policy, keys[i], binNames, records, i, status2, bn.node, false);
                    continue;
                }
                commands[count++] = new Batch.GetArrayCommand(this.cluster, bn, policy, keys, binNames, null, records, readAttr, false, status2);
            }
            BatchExecutor.execute(this.cluster, policy, commands, status2);
            return records;
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchRecords(records, e);
        }
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        int readAttr = binNames == null || binNames.length == 0 ? 3 : 1;
        Record[] records = new Record[keys.length];
        AsyncBatchExecutor.GetArray executor = new AsyncBatchExecutor.GetArray(eventLoop, this.cluster, listener, keys, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.Get(executor, this.cluster, policy, keys[i], binNames, records, bn.node, i, false);
                continue;
            }
            commands[count++] = new AsyncBatch.GetArrayCommand(executor, bn, policy, keys, binNames, null, records, readAttr, false);
        }
        executor.execute(commands);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys, String ... binNames) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        int readAttr = binNames == null || binNames.length == 0 ? 3 : 1;
        AsyncBatchExecutor.GetSequence executor = new AsyncBatchExecutor.GetSequence(eventLoop, this.cluster, listener);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.GetSequence(executor, this.cluster, policy, listener, keys[i], binNames, bn.node, false);
                continue;
            }
            commands[count++] = new AsyncBatch.GetSequenceCommand(executor, bn, policy, keys, binNames, null, listener, readAttr, false);
        }
        executor.execute(commands);
    }

    @Override
    public final Record[] get(BatchPolicy policy, Key[] keys, Operation ... ops) throws AerospikeException {
        if (keys.length == 0) {
            return new Record[0];
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        Record[] records = new Record[keys.length];
        try {
            BatchStatus status2 = new BatchStatus(false);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.OperateRead(this.cluster, policy, keys[i], ops, records, i, status2, bn.node);
                    continue;
                }
                commands[count++] = new Batch.GetArrayCommand(this.cluster, bn, policy, keys, null, ops, records, 1, true, status2);
            }
            BatchExecutor.execute(this.cluster, policy, commands, status2);
            return records;
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchRecords(records, e);
        }
    }

    @Override
    public final void get(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys, Operation ... ops) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        Record[] records = new Record[keys.length];
        AsyncBatchExecutor.GetArray executor = new AsyncBatchExecutor.GetArray(eventLoop, this.cluster, listener, keys, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.OperateGet(executor, this.cluster, policy, keys[i], ops, records, bn.node, i);
                continue;
            }
            commands[count++] = new AsyncBatch.GetArrayCommand(executor, bn, policy, keys, null, ops, records, 1, true);
        }
        executor.execute(commands);
    }

    @Override
    public final void get(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys, Operation ... ops) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        AsyncBatchExecutor.GetSequence executor = new AsyncBatchExecutor.GetSequence(eventLoop, this.cluster, listener);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.OperateGetSequence(executor, this.cluster, policy, listener, keys[i], ops, bn.node);
                continue;
            }
            commands[count++] = new AsyncBatch.GetSequenceCommand(executor, bn, policy, keys, null, ops, listener, 1, true);
        }
        executor.execute(commands);
    }

    @Override
    public final Record[] getHeader(BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            return new Record[0];
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        Record[] records = new Record[keys.length];
        try {
            BatchStatus status2 = new BatchStatus(false);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.ReadHeader(this.cluster, policy, keys[i], records, i, status2, bn.node);
                    continue;
                }
                commands[count++] = new Batch.GetArrayCommand(this.cluster, bn, policy, keys, null, null, records, 33, false, status2);
            }
            BatchExecutor.execute(this.cluster, policy, commands, status2);
            return records;
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchRecords(records, e);
        }
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordArrayListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(keys, new Record[0]);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        Record[] records = new Record[keys.length];
        AsyncBatchExecutor.GetArray executor = new AsyncBatchExecutor.GetArray(eventLoop, this.cluster, listener, keys, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.ReadHeader(executor, this.cluster, policy, keys[i], records, bn.node, i);
                continue;
            }
            commands[count++] = new AsyncBatch.GetArrayCommand(executor, bn, policy, keys, null, null, records, 33, false);
        }
        executor.execute(commands);
    }

    @Override
    public final void getHeader(EventLoop eventLoop, RecordSequenceListener listener, BatchPolicy policy, Key[] keys) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(keys);
        }
        AsyncBatchExecutor.GetSequence executor = new AsyncBatchExecutor.GetSequence(eventLoop, this.cluster, listener);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, keys, null, false, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.ReadHeaderSequence((AsyncBatchExecutor)executor, this.cluster, policy, keys[i], bn.node, listener);
                continue;
            }
            commands[count++] = new AsyncBatch.GetSequenceCommand(executor, bn, policy, keys, null, null, listener, 33, false);
        }
        executor.execute(commands);
    }

    @Override
    public final Record operate(WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        OperateArgs args = new OperateArgs(policy, this.writePolicyDefault, this.operatePolicyReadDefault, operations);
        policy = args.writePolicy;
        if (args.hasWrite) {
            if (policy.txn != null) {
                TxnMonitor.addKey(this.cluster, policy, key);
            }
            OperateCommandWrite command = new OperateCommandWrite(this.cluster, key, args);
            command.execute();
            return command.getRecord();
        }
        if (policy.txn != null) {
            policy.txn.prepareRead(key.namespace);
        }
        OperateCommandRead command = new OperateCommandRead(this.cluster, key, args);
        command.execute();
        return command.getRecord();
    }

    @Override
    public final void operate(EventLoop eventLoop, RecordListener listener, WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        OperateArgs args = new OperateArgs(policy, this.writePolicyDefault, this.operatePolicyReadDefault, operations);
        policy = args.writePolicy;
        if (args.hasWrite) {
            AsyncOperateWrite command = new AsyncOperateWrite(this.cluster, listener, key, args);
            AsyncTxnMonitor.execute(eventLoop, this.cluster, args.writePolicy, command);
        } else {
            if (policy.txn != null) {
                policy.txn.prepareRead(key.namespace);
            }
            AsyncOperateRead command = new AsyncOperateRead(this.cluster, listener, key, args);
            eventLoop.execute(this.cluster, command);
        }
    }

    @Override
    public final boolean operate(BatchPolicy policy, List<BatchRecord> records) throws AerospikeException {
        if (records.size() == 0) {
            return true;
        }
        if (policy == null) {
            policy = this.batchParentPolicyWriteDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKeys(this.cluster, policy, records);
        }
        BatchStatus status2 = new BatchStatus(true);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, records, status2);
        IBatchCommand[] commands = new IBatchCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                BatchRecord record = records.get(i);
                switch (record.getType()) {
                    case BATCH_READ: {
                        BatchRead br = (BatchRead)record;
                        commands[count++] = new BatchSingle.ReadRecord(this.cluster, policy, br, status2, bn.node);
                        break;
                    }
                    case BATCH_WRITE: {
                        BatchWrite bw = (BatchWrite)record;
                        BatchAttr attr = new BatchAttr();
                        BatchWritePolicy bwp = bw.policy != null ? bw.policy : this.batchWritePolicyDefault;
                        attr.setWrite(bwp);
                        attr.adjustWrite(bw.ops);
                        attr.setOpSize(bw.ops);
                        commands[count++] = new BatchSingle.OperateBatchRecord(this.cluster, policy, bw.ops, attr, record, status2, bn.node);
                        break;
                    }
                    case BATCH_UDF: {
                        BatchUDF bu = (BatchUDF)record;
                        BatchAttr attr = new BatchAttr();
                        BatchUDFPolicy bup = bu.policy != null ? bu.policy : this.batchUDFPolicyDefault;
                        attr.setUDF(bup);
                        commands[count++] = new BatchSingle.UDF(this.cluster, policy, bu.packageName, bu.functionName, bu.functionArgs, attr, record, status2, bn.node);
                        break;
                    }
                    case BATCH_DELETE: {
                        BatchDelete bd = (BatchDelete)record;
                        BatchAttr attr = new BatchAttr();
                        BatchDeletePolicy bdp = bd.policy != null ? bd.policy : this.batchDeletePolicyDefault;
                        attr.setDelete(bdp);
                        commands[count++] = new BatchSingle.Delete(this.cluster, policy, attr, record, status2, bn.node);
                        break;
                    }
                    default: {
                        throw new AerospikeException("Invalid batch type: " + String.valueOf((Object)record.getType()));
                    }
                }
                continue;
            }
            commands[count++] = new Batch.OperateListCommand(this.cluster, bn, policy, records, status2);
        }
        BatchExecutor.execute(this.cluster, policy, commands, status2);
        return status2.getStatus();
    }

    @Override
    public final void operate(EventLoop eventLoop, BatchOperateListListener listener, BatchPolicy policy, List<BatchRecord> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess(records, false);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchParentPolicyWriteDefault;
        }
        AsyncBatchExecutor.OperateList executor = new AsyncBatchExecutor.OperateList(eventLoop, this.cluster, listener, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, records, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                BatchRecord record = records.get(i);
                switch (record.getType()) {
                    case BATCH_READ: {
                        BatchRead br = (BatchRead)record;
                        commands[count++] = new AsyncBatchSingle.Read(executor, this.cluster, policy, br, bn.node);
                        break;
                    }
                    case BATCH_WRITE: {
                        BatchWrite bw = (BatchWrite)record;
                        BatchAttr attr = new BatchAttr();
                        BatchWritePolicy bwp = bw.policy != null ? bw.policy : this.batchWritePolicyDefault;
                        attr.setWrite(bwp);
                        attr.adjustWrite(bw.ops);
                        attr.setOpSize(bw.ops);
                        commands[count++] = new AsyncBatchSingle.Write((AsyncBatchExecutor)executor, this.cluster, policy, attr, bw, bn.node);
                        break;
                    }
                    case BATCH_UDF: {
                        BatchUDF bu = (BatchUDF)record;
                        BatchAttr attr = new BatchAttr();
                        BatchUDFPolicy bup = bu.policy != null ? bu.policy : this.batchUDFPolicyDefault;
                        attr.setUDF(bup);
                        commands[count++] = new AsyncBatchSingle.UDF((AsyncBatchExecutor)executor, this.cluster, policy, attr, bu, bn.node);
                        break;
                    }
                    case BATCH_DELETE: {
                        BatchDelete bd = (BatchDelete)record;
                        BatchAttr attr = new BatchAttr();
                        BatchDeletePolicy bdp = bd.policy != null ? bd.policy : this.batchDeletePolicyDefault;
                        attr.setDelete(bdp);
                        commands[count++] = new AsyncBatchSingle.Delete((AsyncBatchExecutor)executor, this.cluster, policy, attr, record, bn.node);
                        break;
                    }
                    default: {
                        throw new AerospikeException("Invalid batch type: " + String.valueOf((Object)record.getType()));
                    }
                }
                continue;
            }
            commands[count++] = new AsyncBatch.OperateListCommand((AsyncBatchExecutor)executor, bn, policy, records);
        }
        AsyncTxnMonitor.executeBatch(policy, (AsyncBatchExecutor)executor, commands, records);
    }

    @Override
    public final void operate(EventLoop eventLoop, BatchRecordSequenceListener listener, BatchPolicy policy, List<BatchRecord> records) throws AerospikeException {
        if (records.size() == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.batchParentPolicyWriteDefault;
        }
        AsyncBatchExecutor.OperateSequence executor = new AsyncBatchExecutor.OperateSequence(eventLoop, this.cluster, listener);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, policy, records, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                BatchRecord record = records.get(i);
                switch (record.getType()) {
                    case BATCH_READ: {
                        BatchRead br = (BatchRead)record;
                        commands[count++] = new AsyncBatchSingle.ReadSequence(executor, this.cluster, policy, br, bn.node, listener, i);
                        break;
                    }
                    case BATCH_WRITE: {
                        BatchWrite bw = (BatchWrite)record;
                        BatchAttr attr = new BatchAttr();
                        BatchWritePolicy bwp = bw.policy != null ? bw.policy : this.batchWritePolicyDefault;
                        attr.setWrite(bwp);
                        attr.adjustWrite(bw.ops);
                        attr.setOpSize(bw.ops);
                        commands[count++] = new AsyncBatchSingle.WriteSequence(executor, this.cluster, policy, attr, bw, bn.node, listener, i);
                        break;
                    }
                    case BATCH_UDF: {
                        BatchUDF bu = (BatchUDF)record;
                        BatchAttr attr = new BatchAttr();
                        BatchUDFPolicy bup = bu.policy != null ? bu.policy : this.batchUDFPolicyDefault;
                        attr.setUDF(bup);
                        commands[count++] = new AsyncBatchSingle.UDFSequence(executor, this.cluster, policy, attr, bu, bn.node, listener, i);
                        break;
                    }
                    case BATCH_DELETE: {
                        BatchDelete bd = (BatchDelete)record;
                        BatchAttr attr = new BatchAttr();
                        BatchDeletePolicy bdp = bd.policy != null ? bd.policy : this.batchDeletePolicyDefault;
                        attr.setDelete(bdp);
                        commands[count++] = new AsyncBatchSingle.DeleteSequence(executor, this.cluster, policy, attr, bd, bn.node, listener, i);
                        break;
                    }
                    default: {
                        throw new AerospikeException("Invalid batch type: " + String.valueOf((Object)record.getType()));
                    }
                }
                continue;
            }
            commands[count++] = new AsyncBatch.OperateSequenceCommand(executor, bn, policy, listener, records);
        }
        AsyncTxnMonitor.executeBatch(policy, (AsyncBatchExecutor)executor, commands, records);
    }

    @Override
    public final BatchResults operate(BatchPolicy batchPolicy, BatchWritePolicy writePolicy, Key[] keys, Operation ... ops) throws AerospikeException {
        if (keys.length == 0) {
            return new BatchResults(new BatchRecord[0], true);
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (writePolicy == null) {
            writePolicy = this.batchWritePolicyDefault;
        }
        if (batchPolicy.txn != null) {
            TxnMonitor.addKeys(this.cluster, batchPolicy, keys);
        }
        BatchAttr attr = new BatchAttr(batchPolicy, writePolicy, ops);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], attr.hasWrite);
        }
        try {
            BatchStatus status2 = new BatchStatus(true);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, records, attr.hasWrite, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            boolean opSizeSet = false;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    if (!opSizeSet) {
                        attr.setOpSize(ops);
                        opSizeSet = true;
                    }
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.OperateBatchRecord(this.cluster, batchPolicy, ops, attr, records[i], status2, bn.node);
                    continue;
                }
                commands[count++] = new Batch.OperateArrayCommand(this.cluster, bn, batchPolicy, keys, ops, records, attr, status2);
            }
            BatchExecutor.execute(this.cluster, batchPolicy, commands, status2);
            return new BatchResults(records, status2.getStatus());
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchRecordArray(records, e);
        }
    }

    @Override
    public final void operate(EventLoop eventLoop, BatchRecordArrayListener listener, BatchPolicy batchPolicy, BatchWritePolicy writePolicy, Key[] keys, Operation ... ops) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(new BatchRecord[0], true);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (writePolicy == null) {
            writePolicy = this.batchWritePolicyDefault;
        }
        BatchAttr attr = new BatchAttr(batchPolicy, writePolicy, ops);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], attr.hasWrite);
        }
        AsyncBatchExecutor.BatchRecordArray executor = new AsyncBatchExecutor.BatchRecordArray(eventLoop, this.cluster, listener, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, records, attr.hasWrite, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.Operate(executor, this.cluster, batchPolicy, attr, records[i], ops, bn.node);
                continue;
            }
            commands[count++] = new AsyncBatch.OperateRecordArrayCommand(executor, bn, batchPolicy, keys, ops, records, attr);
        }
        AsyncTxnMonitor.executeBatch(batchPolicy, (AsyncBatchExecutor)executor, commands, keys);
    }

    @Override
    public final void operate(EventLoop eventLoop, BatchRecordSequenceListener listener, BatchPolicy batchPolicy, BatchWritePolicy writePolicy, Key[] keys, Operation ... ops) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (writePolicy == null) {
            writePolicy = this.batchWritePolicyDefault;
        }
        BatchAttr attr = new BatchAttr(batchPolicy, writePolicy, ops);
        boolean[] sent = new boolean[keys.length];
        AsyncBatchExecutor.BatchRecordSequence executor = new AsyncBatchExecutor.BatchRecordSequence(eventLoop, this.cluster, listener, sent);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, null, attr.hasWrite, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.OperateSequence(executor, this.cluster, batchPolicy, keys[i], attr, ops, bn.node, listener, i);
                continue;
            }
            commands[count++] = new AsyncBatch.OperateRecordSequenceCommand(executor, bn, batchPolicy, keys, ops, sent, listener, attr);
        }
        AsyncTxnMonitor.executeBatch(batchPolicy, (AsyncBatchExecutor)executor, commands, keys);
    }

    @Override
    public final void scanAll(ScanPolicy policy, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes);
        ScanExecutor.scanPartitions(this.cluster, policy, namespace, setName, binNames, callback, tracker);
    }

    @Override
    public final void scanAll(EventLoop eventLoop, RecordSequenceListener listener, ScanPolicy policy, String namespace, String setName, String ... binNames) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes);
        new AsyncScanPartitionExecutor(eventLoop, this.cluster, policy, listener, namespace, setName, binNames, tracker);
    }

    @Override
    public final void scanNode(ScanPolicy policy, String nodeName, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        Node node = this.cluster.getNode(nodeName);
        this.scanNode(policy, node, namespace, setName, callback, binNames);
    }

    @Override
    public final void scanNode(ScanPolicy policy, Node node, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        PartitionTracker tracker = new PartitionTracker(policy, node);
        ScanExecutor.scanPartitions(this.cluster, policy, namespace, setName, binNames, callback, tracker);
    }

    @Override
    public final void scanPartitions(ScanPolicy policy, PartitionFilter partitionFilter, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes, partitionFilter);
        ScanExecutor.scanPartitions(this.cluster, policy, namespace, setName, binNames, callback, tracker);
    }

    @Override
    public final void scanPartitions(EventLoop eventLoop, RecordSequenceListener listener, ScanPolicy policy, PartitionFilter partitionFilter, String namespace, String setName, String ... binNames) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        PartitionTracker tracker = new PartitionTracker(policy, nodes, partitionFilter);
        new AsyncScanPartitionExecutor(eventLoop, this.cluster, policy, listener, namespace, setName, binNames, tracker);
    }

    @Override
    public final RegisterTask register(Policy policy, String clientPath, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        File file = new File(clientPath);
        byte[] bytes = Util.readFile(file);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final RegisterTask register(Policy policy, ClassLoader resourceLoader, String resourcePath, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        byte[] bytes = Util.readResource(resourceLoader, resourcePath);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final RegisterTask registerUdfString(Policy policy, String code, String serverPath, Language language) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        byte[] bytes = Buffer.stringToUtf8(code);
        return RegisterCommand.register(this.cluster, policy, bytes, serverPath, language);
    }

    @Override
    public final void removeUdf(InfoPolicy policy, String serverPath) throws AerospikeException {
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        String command = "udf-remove:filename=" + serverPath;
        Node node = this.cluster.getRandomNode();
        String response = Info.request(policy, node, command);
        if (response.equalsIgnoreCase("ok")) {
            return;
        }
        if (response.startsWith("error=file_not_found")) {
            return;
        }
        throw new AerospikeException("Remove UDF failed: " + response);
    }

    @Override
    public final Object execute(WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (policy.txn != null) {
            TxnMonitor.addKey(this.cluster, policy, key);
        }
        ExecuteCommand command = new ExecuteCommand(this.cluster, policy, key, packageName, functionName, functionArgs);
        command.execute();
        Record record = command.getRecord();
        if (record == null || record.bins == null) {
            return null;
        }
        Map<String, Object> map = record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }

    @Override
    public final void execute(EventLoop eventLoop, ExecuteListener listener, WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        AsyncExecute command = new AsyncExecute(this.cluster, listener, policy, key, packageName, functionName, functionArgs);
        AsyncTxnMonitor.execute(eventLoop, this.cluster, policy, command);
    }

    @Override
    public final BatchResults execute(BatchPolicy batchPolicy, BatchUDFPolicy udfPolicy, Key[] keys, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (keys.length == 0) {
            return new BatchResults(new BatchRecord[0], true);
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (udfPolicy == null) {
            udfPolicy = this.batchUDFPolicyDefault;
        }
        if (batchPolicy.txn != null) {
            TxnMonitor.addKeys(this.cluster, batchPolicy, keys);
        }
        byte[] argBytes = Packer.pack(functionArgs);
        BatchAttr attr = new BatchAttr();
        attr.setUDF(udfPolicy);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], attr.hasWrite);
        }
        try {
            BatchStatus status2 = new BatchStatus(true);
            List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, records, attr.hasWrite, status2);
            IBatchCommand[] commands = new IBatchCommand[bns.size()];
            int count = 0;
            for (BatchNode bn : bns) {
                if (bn.offsetsSize == 1) {
                    int i = bn.offsets[0];
                    commands[count++] = new BatchSingle.UDF(this.cluster, batchPolicy, packageName, functionName, functionArgs, attr, records[i], status2, bn.node);
                    continue;
                }
                commands[count++] = new Batch.UDFCommand(this.cluster, bn, batchPolicy, keys, packageName, functionName, argBytes, records, attr, status2);
            }
            BatchExecutor.execute(this.cluster, batchPolicy, commands, status2);
            return new BatchResults(records, status2.getStatus());
        }
        catch (Throwable e) {
            throw new AerospikeException.BatchRecordArray(records, e);
        }
    }

    @Override
    public final void execute(EventLoop eventLoop, BatchRecordArrayListener listener, BatchPolicy batchPolicy, BatchUDFPolicy udfPolicy, Key[] keys, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess(new BatchRecord[0], true);
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (udfPolicy == null) {
            udfPolicy = this.batchUDFPolicyDefault;
        }
        byte[] argBytes = Packer.pack(functionArgs);
        BatchAttr attr = new BatchAttr();
        attr.setUDF(udfPolicy);
        BatchRecord[] records = new BatchRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = new BatchRecord(keys[i], attr.hasWrite);
        }
        AsyncBatchExecutor.BatchRecordArray executor = new AsyncBatchExecutor.BatchRecordArray(eventLoop, this.cluster, listener, records);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, records, attr.hasWrite, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.UDFCommand(executor, this.cluster, batchPolicy, attr, records[i], packageName, functionName, argBytes, bn.node);
                continue;
            }
            commands[count++] = new AsyncBatch.UDFArrayCommand(executor, bn, batchPolicy, keys, packageName, functionName, argBytes, records, attr);
        }
        AsyncTxnMonitor.executeBatch(batchPolicy, (AsyncBatchExecutor)executor, commands, keys);
    }

    @Override
    public final void execute(EventLoop eventLoop, BatchRecordSequenceListener listener, BatchPolicy batchPolicy, BatchUDFPolicy udfPolicy, Key[] keys, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (keys.length == 0) {
            listener.onSuccess();
            return;
        }
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (batchPolicy == null) {
            batchPolicy = this.batchParentPolicyWriteDefault;
        }
        if (udfPolicy == null) {
            udfPolicy = this.batchUDFPolicyDefault;
        }
        byte[] argBytes = Packer.pack(functionArgs);
        BatchAttr attr = new BatchAttr();
        attr.setUDF(udfPolicy);
        boolean[] sent = new boolean[keys.length];
        AsyncBatchExecutor.BatchRecordSequence executor = new AsyncBatchExecutor.BatchRecordSequence(eventLoop, this.cluster, listener, sent);
        List<BatchNode> bns = BatchNodeList.generate(this.cluster, batchPolicy, keys, null, attr.hasWrite, executor);
        AsyncCommand[] commands = new AsyncCommand[bns.size()];
        int count = 0;
        for (BatchNode bn : bns) {
            if (bn.offsetsSize == 1) {
                int i = bn.offsets[0];
                commands[count++] = new AsyncBatchSingle.UDFSequenceCommand(executor, this.cluster, batchPolicy, keys[i], attr, packageName, functionName, argBytes, bn.node, listener, i);
                continue;
            }
            commands[count++] = new AsyncBatch.UDFSequenceCommand(executor, bn, batchPolicy, keys, packageName, functionName, argBytes, sent, listener, attr);
        }
        AsyncTxnMonitor.executeBatch(batchPolicy, (AsyncBatchExecutor)executor, commands, keys);
    }

    @Override
    public final ExecuteTask execute(WritePolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        statement.setAggregateFunction(packageName, functionName, functionArgs);
        this.cluster.addCommandCount();
        long taskId = statement.prepareTaskId();
        Node[] nodes = this.cluster.validateNodes();
        Executor executor = new Executor(this.cluster, nodes.length);
        for (Node node : nodes) {
            ServerCommand command = new ServerCommand(this.cluster, node, policy, statement, taskId);
            executor.addCommand(command);
        }
        executor.execute(nodes.length);
        return new ExecuteTask(this.cluster, (Policy)policy, statement, taskId);
    }

    @Override
    public final ExecuteTask execute(WritePolicy policy, Statement statement, Operation ... operations) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if (operations.length > 0) {
            statement.setOperations(operations);
        }
        this.cluster.addCommandCount();
        long taskId = statement.prepareTaskId();
        Node[] nodes = this.cluster.validateNodes();
        Executor executor = new Executor(this.cluster, nodes.length);
        for (Node node : nodes) {
            ServerCommand command = new ServerCommand(this.cluster, node, policy, statement, taskId);
            executor.addCommand(command);
        }
        executor.execute(nodes.length);
        return new ExecuteTask(this.cluster, (Policy)policy, statement, taskId);
    }

    @Override
    public final RecordSet query(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (this.cluster.hasPartitionQuery || statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, statement, nodes);
            QueryPartitionExecutor executor = new QueryPartitionExecutor(this.cluster, policy, statement, nodes.length, tracker);
            return executor.getRecordSet();
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, nodes);
        executor.execute();
        return executor.getRecordSet();
    }

    @Override
    public final void query(EventLoop eventLoop, RecordSequenceListener listener, QueryPolicy policy, Statement statement) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (this.cluster.hasPartitionQuery || statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, statement, nodes);
            new AsyncQueryPartitionExecutor(eventLoop, listener, this.cluster, policy, statement, tracker);
        } else {
            new AsyncQueryExecutor(eventLoop, listener, this.cluster, policy, statement, nodes);
        }
    }

    @Override
    public final void query(QueryPolicy policy, Statement statement, QueryListener listener) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (!this.cluster.hasPartitionQuery && statement.getFilter() != null) {
            throw new AerospikeException(4, "Query by partition is not supported");
        }
        PartitionTracker tracker = new PartitionTracker(policy, statement, nodes);
        QueryListenerExecutor.execute(this.cluster, policy, statement, listener, tracker);
    }

    @Override
    public final void query(QueryPolicy policy, Statement statement, PartitionFilter partitionFilter, QueryListener listener) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (!this.cluster.hasPartitionQuery && statement.getFilter() != null) {
            throw new AerospikeException(4, "Query by partition is not supported");
        }
        PartitionTracker tracker = new PartitionTracker(policy, statement, nodes, partitionFilter);
        QueryListenerExecutor.execute(this.cluster, policy, statement, listener, tracker);
    }

    @Override
    public final RecordSet queryNode(QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        if (this.cluster.hasPartitionQuery || statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, statement, node);
            QueryPartitionExecutor executor = new QueryPartitionExecutor(this.cluster, policy, statement, 1, tracker);
            return executor.getRecordSet();
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, new Node[]{node});
        executor.execute();
        return executor.getRecordSet();
    }

    @Override
    public final RecordSet queryPartitions(QueryPolicy policy, Statement statement, PartitionFilter partitionFilter) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (this.cluster.hasPartitionQuery || statement.getFilter() == null) {
            PartitionTracker tracker = new PartitionTracker(policy, statement, nodes, partitionFilter);
            QueryPartitionExecutor executor = new QueryPartitionExecutor(this.cluster, policy, statement, nodes.length, tracker);
            return executor.getRecordSet();
        }
        throw new AerospikeException(4, "queryPartitions() not supported");
    }

    @Override
    public final void queryPartitions(EventLoop eventLoop, RecordSequenceListener listener, QueryPolicy policy, Statement statement, PartitionFilter partitionFilter) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        if (!this.cluster.hasPartitionQuery && statement.getFilter() != null) {
            throw new AerospikeException(4, "queryPartitions() not supported");
        }
        PartitionTracker tracker = new PartitionTracker(policy, statement, nodes, partitionFilter);
        new AsyncQueryPartitionExecutor(eventLoop, listener, this.cluster, policy, statement, tracker);
    }

    @Override
    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        statement.setAggregateFunction(packageName, functionName, functionArgs);
        return this.queryAggregate(policy, statement);
    }

    @Override
    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        Node[] nodes = this.cluster.validateNodes();
        QueryAggregateExecutor executor = new QueryAggregateExecutor(this.cluster, policy, statement, nodes);
        return executor.getResultSet();
    }

    @Override
    public final ResultSet queryAggregateNode(QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        QueryAggregateExecutor executor = new QueryAggregateExecutor(this.cluster, policy, statement, new Node[]{node});
        return executor.getResultSet();
    }

    @Override
    public final IndexTask createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType) throws AerospikeException {
        return this.createIndex(policy, namespace, setName, indexName, binName, indexType, IndexCollectionType.DEFAULT, new CTX[0]);
    }

    @Override
    public final IndexTask createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) throws AerospikeException {
        String command;
        String response;
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if ((response = this.sendInfoCommand(policy, command = AerospikeClient.buildCreateIndexInfoCommand(namespace, setName, indexName, binName, indexType, indexCollectionType, ctx))).equalsIgnoreCase("OK")) {
            return new IndexTask(this.cluster, policy, namespace, indexName, true);
        }
        int code = AerospikeClient.parseIndexErrorCode(response);
        throw new AerospikeException(code, "Create index failed: " + response);
    }

    @Override
    public final void createIndex(EventLoop eventLoop, IndexListener listener, Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        String command = AerospikeClient.buildCreateIndexInfoCommand(namespace, setName, indexName, binName, indexType, indexCollectionType, ctx);
        this.sendIndexInfoCommand(eventLoop, listener, policy, namespace, indexName, command, true);
    }

    @Override
    public final IndexTask dropIndex(Policy policy, String namespace, String setName, String indexName) throws AerospikeException {
        String command;
        String response;
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        if ((response = this.sendInfoCommand(policy, command = AerospikeClient.buildDropIndexInfoCommand(namespace, setName, indexName))).equalsIgnoreCase("OK")) {
            return new IndexTask(this.cluster, policy, namespace, indexName, false);
        }
        int code = AerospikeClient.parseIndexErrorCode(response);
        throw new AerospikeException(code, "Drop index failed: " + response);
    }

    @Override
    public final void dropIndex(EventLoop eventLoop, IndexListener listener, Policy policy, String namespace, String setName, String indexName) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        String command = AerospikeClient.buildDropIndexInfoCommand(namespace, setName, indexName);
        this.sendIndexInfoCommand(eventLoop, listener, policy, namespace, indexName, command, false);
    }

    @Override
    public final void info(EventLoop eventLoop, InfoListener listener, InfoPolicy policy, Node node, String ... commands) throws AerospikeException {
        if (eventLoop == null) {
            eventLoop = this.cluster.eventLoops.next();
        }
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        if (node == null) {
            node = this.cluster.getRandomNode();
        }
        AsyncInfoCommand command = new AsyncInfoCommand(listener, policy, node, commands);
        eventLoop.execute(this.cluster, command);
    }

    @Override
    public final void setXDRFilter(InfoPolicy policy, String datacenter, String namespace, Expression filter) throws AerospikeException {
        if (policy == null) {
            policy = this.infoPolicyDefault;
        }
        String filterString = filter != null ? filter.getBase64() : "null";
        String command = "xdr-set-filter:dc=" + datacenter + ";namespace=" + namespace + ";exp=" + filterString;
        Node node = this.cluster.getRandomNode();
        String response = Info.request(policy, node, command);
        if (response.equalsIgnoreCase("ok")) {
            return;
        }
        int code = AerospikeClient.parseIndexErrorCode(response);
        throw new AerospikeException(code, "xdr-set-filter failed: " + response);
    }

    @Override
    public final void createUser(AdminPolicy policy, String user, String password, List<String> roles) throws AerospikeException {
        String hash = AdminCommand.hashPassword(password);
        AdminCommand command = new AdminCommand();
        command.createUser(this.cluster, policy, user, hash, roles);
    }

    @Override
    public final void dropUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.dropUser(this.cluster, policy, user);
    }

    @Override
    public final void changePassword(AdminPolicy policy, String user, String password) throws AerospikeException {
        if (this.cluster.getUser() == null) {
            throw new AerospikeException("Invalid user");
        }
        byte[] userBytes = Buffer.stringToUtf8(user);
        byte[] passwordBytes = Buffer.stringToUtf8(password);
        String hash = AdminCommand.hashPassword(password);
        byte[] hashBytes = Buffer.stringToUtf8(hash);
        AdminCommand command = new AdminCommand();
        if (Arrays.equals(userBytes, this.cluster.getUser())) {
            command.changePassword(this.cluster, policy, userBytes, hash);
        } else {
            command.setPassword(this.cluster, policy, userBytes, hash);
        }
        this.cluster.changePassword(userBytes, passwordBytes, hashBytes);
    }

    @Override
    public final void grantRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.grantRoles(this.cluster, policy, user, roles);
    }

    @Override
    public final void revokeRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.revokeRoles(this.cluster, policy, user, roles);
    }

    @Override
    public final void createRole(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.createRole(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void createRole(AdminPolicy policy, String roleName, List<Privilege> privileges, List<String> whitelist) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.createRole(this.cluster, policy, roleName, privileges, whitelist, 0, 0);
    }

    @Override
    public final void createRole(AdminPolicy policy, String roleName, List<Privilege> privileges, List<String> whitelist, int readQuota, int writeQuota) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.createRole(this.cluster, policy, roleName, privileges, whitelist, readQuota, writeQuota);
    }

    @Override
    public final void dropRole(AdminPolicy policy, String roleName) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.dropRole(this.cluster, policy, roleName);
    }

    @Override
    public final void grantPrivileges(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.grantPrivileges(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void revokePrivileges(AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.revokePrivileges(this.cluster, policy, roleName, privileges);
    }

    @Override
    public final void setWhitelist(AdminPolicy policy, String roleName, List<String> whitelist) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.setWhitelist(this.cluster, policy, roleName, whitelist);
    }

    @Override
    public final void setQuotas(AdminPolicy policy, String roleName, int readQuota, int writeQuota) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.setQuotas(this.cluster, policy, roleName, readQuota, writeQuota);
    }

    @Override
    public final User queryUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand.UserCommand command = new AdminCommand.UserCommand(1);
        return command.queryUser(this.cluster, policy, user);
    }

    @Override
    public final List<User> queryUsers(AdminPolicy policy) throws AerospikeException {
        AdminCommand.UserCommand command = new AdminCommand.UserCommand(100);
        return command.queryUsers(this.cluster, policy);
    }

    @Override
    public final Role queryRole(AdminPolicy policy, String roleName) throws AerospikeException {
        AdminCommand.RoleCommand command = new AdminCommand.RoleCommand(1);
        return command.queryRole(this.cluster, policy, roleName);
    }

    @Override
    public final List<Role> queryRoles(AdminPolicy policy) throws AerospikeException {
        AdminCommand.RoleCommand command = new AdminCommand.RoleCommand(100);
        return command.queryRoles(this.cluster, policy);
    }

    private static String buildCreateIndexInfoCommand(String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX[] ctx) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("sindex-create:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        if (ctx != null && ctx.length > 0) {
            byte[] bytes = Pack.pack(ctx);
            String base64 = Crypto.encodeBase64(bytes);
            sb.append(";context=");
            sb.append(base64);
        }
        if (indexCollectionType != IndexCollectionType.DEFAULT) {
            sb.append(";indextype=");
            sb.append((Object)indexCollectionType);
        }
        sb.append(";indexdata=");
        sb.append(binName);
        sb.append(",");
        sb.append((Object)indexType);
        return sb.toString();
    }

    private static String buildDropIndexInfoCommand(String namespace, String setName, String indexName) {
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-delete:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        return sb.toString();
    }

    private String sendInfoCommand(Policy policy, String command) {
        Info info;
        Node node = this.cluster.getRandomNode();
        Connection conn = node.getConnection(policy.connectTimeout, policy.socketTimeout);
        try {
            info = new Info(conn, command);
            node.putConnection(conn);
        }
        catch (Throwable e) {
            node.closeConnection(conn);
            throw e;
        }
        return info.getValue();
    }

    private void sendIndexInfoCommand(EventLoop eventLoop, final IndexListener listener, Policy policy, final String namespace, final String indexName, String command, final boolean isCreate) {
        this.info(eventLoop, new InfoListener(){

            @Override
            public void onSuccess(Map<String, String> map) {
                String response = map.values().iterator().next();
                if (response.equalsIgnoreCase("OK")) {
                    listener.onSuccess(new AsyncIndexTask(AerospikeClient.this, namespace, indexName, isCreate));
                } else {
                    int code = AerospikeClient.parseIndexErrorCode(response);
                    String type2 = isCreate ? "Create" : "Drop";
                    listener.onFailure(new AerospikeException(code, type2 + " index failed: " + response));
                }
            }

            @Override
            public void onFailure(AerospikeException ae) {
                listener.onFailure(ae);
            }
        }, new InfoPolicy(policy), this.cluster.getRandomNode(), command);
    }

    private static int parseIndexErrorCode(String response) {
        Info.Error error2 = new Info.Error(response);
        return error2.code == 0 ? 1 : error2.code;
    }
}

