/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.BatchUDFPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Packer;

public final class BatchUDF
extends BatchRecord {
    public final BatchUDFPolicy policy;
    public final String packageName;
    public final String functionName;
    public final Value[] functionArgs;
    public byte[] argBytes;

    public BatchUDF(Key key, String packageName, String functionName, Value[] functionArgs) {
        super(key, true);
        this.policy = null;
        this.packageName = packageName;
        this.functionName = functionName;
        this.functionArgs = functionArgs;
    }

    public BatchUDF(BatchUDFPolicy policy, Key key, String packageName, String functionName, Value[] functionArgs) {
        super(key, true);
        this.policy = policy;
        this.packageName = packageName;
        this.functionName = functionName;
        this.functionArgs = functionArgs;
    }

    @Override
    public BatchRecord.Type getType() {
        return BatchRecord.Type.BATCH_UDF;
    }

    @Override
    public boolean equals(BatchRecord obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchUDF other = (BatchUDF)obj;
        return this.functionName == other.functionName && this.functionArgs == other.functionArgs && this.packageName == other.packageName && this.policy == other.policy && (this.policy == null || !this.policy.sendKey);
    }

    @Override
    public int size(Policy parentPolicy) {
        int size = 2;
        if (this.policy != null) {
            if (this.policy.filterExp != null) {
                size += this.policy.filterExp.size();
            }
            if (this.policy.sendKey || parentPolicy.sendKey) {
                size += this.key.userKey.estimateSize() + 5 + 1;
            }
        } else if (parentPolicy.sendKey) {
            size += this.key.userKey.estimateSize() + 5 + 1;
        }
        size += Buffer.estimateSizeUtf8(this.packageName) + 5;
        size += Buffer.estimateSizeUtf8(this.functionName) + 5;
        this.argBytes = Packer.pack(this.functionArgs);
        return size += this.argBytes.length + 5;
    }
}

