/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.util.Crypto;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Info {
    private static final int DEFAULT_TIMEOUT = 1000;
    public byte[] buffer;
    public int length;
    public int offset;

    public static String request(Node node, String name) throws AerospikeException {
        Connection conn = node.getConnection(1000);
        try {
            String response = Info.request(conn, name);
            node.putConnection(conn);
            return response;
        }
        catch (Throwable e) {
            node.closeConnection(conn);
            throw e;
        }
    }

    public static String request(InfoPolicy policy, Node node, String name) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            String result = Info.request(conn, name);
            node.putConnection(conn);
            return result;
        }
        catch (Throwable e) {
            node.closeConnection(conn);
            throw e;
        }
    }

    public static Map<String, String> request(InfoPolicy policy, Node node, String ... names) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            HashMap<String, String> result = Info.request(conn, names);
            node.putConnection(conn);
            return result;
        }
        catch (Throwable e) {
            node.closeConnection(conn);
            throw e;
        }
    }

    public static Map<String, String> request(InfoPolicy policy, Node node) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            HashMap<String, String> result = Info.request(conn);
            node.putConnection(conn);
            return result;
        }
        catch (Throwable e) {
            node.closeConnection(conn);
            throw e;
        }
    }

    public static String request(String hostname, int port, String name) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port), name);
    }

    public static HashMap<String, String> request(String hostname, int port, String ... names) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port), names);
    }

    public static HashMap<String, String> request(String hostname, int port) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(InetSocketAddress socketAddress, String name) throws AerospikeException {
        try (Connection conn = new Connection(socketAddress, 1000);){
            String string = Info.request(conn, name);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> request(InetSocketAddress socketAddress, String ... names) throws AerospikeException {
        try (Connection conn = new Connection(socketAddress, 1000);){
            HashMap<String, String> hashMap = Info.request(conn, names);
            return hashMap;
        }
    }

    public static HashMap<String, String> request(InetSocketAddress socketAddress) throws AerospikeException {
        try (Connection conn = new Connection(socketAddress, 1000);){
            HashMap<String, String> hashMap = Info.request(conn);
            return hashMap;
        }
    }

    public static String request(Connection conn, String name) throws AerospikeException {
        Info info = new Info(conn, name);
        return info.parseSingleResponse(name);
    }

    public static HashMap<String, String> request(Connection conn, String ... names) throws AerospikeException {
        Info info = new Info(conn, names);
        return info.parseMultiResponse();
    }

    public static HashMap<String, String> request(Connection conn, List<String> names) throws AerospikeException {
        Info info = new Info(conn, names);
        return info.parseMultiResponse();
    }

    public static HashMap<String, String> request(Connection conn) throws AerospikeException {
        Info info = new Info(conn);
        return info.parseMultiResponse();
    }

    public static int parseResultCode(String response) {
        if (response.regionMatches(true, 0, "OK", 0, 2)) {
            return 0;
        }
        Error error2 = new Error(response);
        if (error2.code >= 0) {
            return error2.code;
        }
        throw new AerospikeException(error2.code, "Unrecognized info response: " + response);
    }

    public Info(Connection conn, String command) throws AerospikeException {
        int size = Buffer.estimateSizeUtf8Quick(command) + 9;
        this.buffer = new byte[size];
        this.offset = 8;
        this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
        this.buffer[this.offset++] = 10;
        this.sendCommand(conn);
    }

    public Info(Connection conn, String ... commands) throws AerospikeException {
        int size = 8;
        for (String command : commands) {
            size += Buffer.estimateSizeUtf8Quick(command) + 1;
        }
        this.buffer = new byte[size];
        this.offset = 8;
        for (String command : commands) {
            this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
            this.buffer[this.offset++] = 10;
        }
        this.sendCommand(conn);
    }

    public Info(Connection conn, List<String> commands) throws AerospikeException {
        int size = 8;
        for (String command : commands) {
            size += Buffer.estimateSizeUtf8Quick(command) + 1;
        }
        this.buffer = new byte[size];
        this.offset = 8;
        for (String command : commands) {
            this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
            this.buffer[this.offset++] = 10;
        }
        this.sendCommand(conn);
    }

    public Info(Connection conn) throws AerospikeException {
        this.buffer = new byte[8];
        this.offset = 8;
        this.sendCommand(conn);
    }

    public Info(byte[] buffer, int length) {
        this.buffer = buffer;
        this.length = length;
    }

    private void sendCommand(Connection conn) {
        try {
            long size = (long)this.offset - 8L | 0x200000000000000L | 0x1000000000000L;
            Buffer.longToBytes(size, this.buffer, 0);
            conn.write(this.buffer, this.offset);
            conn.readFully(this.buffer, 8);
            size = Buffer.bytesToLong(this.buffer, 0);
            this.length = (int)(size & 0xFFFFFFFFFFFFL);
            if (this.length > this.buffer.length) {
                this.buffer = new byte[this.length];
            }
            conn.readFully(this.buffer, this.length);
            conn.updateLastUsed();
            this.offset = 0;
        }
        catch (IOException ioe) {
            throw new AerospikeException.Connection(ioe);
        }
    }

    private String parseSingleResponse(String name) {
        String response = Buffer.utf8ToString(this.buffer, 0, this.length);
        if (response.startsWith(name)) {
            if (response.length() > name.length() + 1) {
                return response.substring(name.length() + 1, response.length() - 1);
            }
            return null;
        }
        throw new AerospikeException.Parse("Info response does not include: " + name);
    }

    public HashMap<String, String> parseMultiResponse() throws AerospikeException {
        HashMap<String, String> responses = new HashMap<String, String>();
        int offset = 0;
        int begin = 0;
        while (offset < this.length) {
            String name;
            byte b = this.buffer[offset];
            if (b == 9) {
                name = Buffer.utf8ToString(this.buffer, begin, offset - begin);
                this.checkError();
                begin = ++offset;
                while (offset < this.length && this.buffer[offset] != 10) {
                    ++offset;
                }
                if (offset > begin) {
                    String value = Buffer.utf8ToString(this.buffer, begin, offset - begin);
                    responses.put(name, value);
                } else {
                    responses.put(name, null);
                }
                begin = ++offset;
                continue;
            }
            if (b == 10) {
                if (offset > begin) {
                    name = Buffer.utf8ToString(this.buffer, begin, offset - begin);
                    responses.put(name, null);
                }
                begin = ++offset;
                continue;
            }
            ++offset;
        }
        if (offset > begin) {
            String name = Buffer.utf8ToString(this.buffer, begin, offset - begin);
            responses.put(name, null);
        }
        return responses;
    }

    public void parseName(String name) {
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 9) {
                String s = Buffer.utf8ToString(this.buffer, begin, this.offset - begin).trim();
                if (!name.equals(s)) break;
                ++this.offset;
                this.checkError();
                return;
            }
            ++this.offset;
        }
        throw new AerospikeException.Parse("Failed to find " + name);
    }

    private void checkError() {
        if (this.offset + 4 >= this.length) {
            return;
        }
        if (this.buffer[this.offset] != 69 || this.buffer[this.offset + 1] != 82 || this.buffer[this.offset + 2] != 82 || this.buffer[this.offset + 3] != 79 || this.buffer[this.offset + 4] != 82) {
            return;
        }
        this.offset += 5;
        this.skipDelimiter(':');
        int begin = this.offset;
        int code = this.parseInt();
        if (code == 0) {
            code = 1;
        }
        if (this.offset > begin) {
            this.skipDelimiter(':');
        } else if (this.buffer[this.offset] == 58) {
            ++this.offset;
        }
        String message = this.parseString('\n');
        throw new AerospikeException(code, message);
    }

    public String getValue() {
        this.skipToValue();
        return Buffer.utf8ToString(this.buffer, this.offset, this.length - this.offset - 1);
    }

    public NameValueParser getNameValueParser() {
        this.skipToValue();
        return new NameValueParser();
    }

    public void skipToValue() {
        while (this.offset < this.length) {
            byte b = this.buffer[this.offset];
            if (b == 9) {
                ++this.offset;
                break;
            }
            if (b == 10) break;
            ++this.offset;
        }
    }

    public void skipDelimiter(char stop) {
        byte b;
        while (this.offset < this.length && (b = this.buffer[this.offset++]) != stop) {
        }
    }

    public int parseInt() {
        int begin = this.offset;
        int end = this.offset;
        while (this.offset < this.length) {
            byte b = this.buffer[this.offset];
            if (b < 48 || b > 57) {
                end = this.offset;
                break;
            }
            ++this.offset;
        }
        return Buffer.utf8DigitsToInt(this.buffer, begin, end);
    }

    public String parseString(char stop) {
        byte b;
        int begin = this.offset;
        while (this.offset < this.length && (b = this.buffer[this.offset]) != stop) {
            ++this.offset;
        }
        return Buffer.utf8ToString(this.buffer, begin, this.offset - begin);
    }

    public String parseString(char stop1, char stop2, char stop3) {
        byte b;
        int begin = this.offset;
        while (this.offset < this.length && (b = this.buffer[this.offset]) != stop1 && b != stop2 && b != stop3) {
            ++this.offset;
        }
        return Buffer.utf8ToString(this.buffer, begin, this.offset - begin);
    }

    public void expect(char expected) {
        if (expected != this.buffer[this.offset]) {
            throw new AerospikeException.Parse("Expected " + expected + " Received: " + (char)(this.buffer[this.offset] & 0xFF));
        }
        ++this.offset;
    }

    public String getTruncatedResponse() {
        int max2 = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max2);
    }

    public static class Error {
        public final int code;
        public final String message;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Error(String response) {
            int rc = -1;
            String msg = response;
            try {
                String[] list = response.split(":");
                String s = list[0];
                if (s.regionMatches(true, 0, "FAIL", 0, 4) || s.regionMatches(true, 0, "ERROR", 0, 5)) {
                    if (list.length >= 3) {
                        msg = list[2].trim();
                        s = list[1].trim();
                        if (!s.isEmpty()) {
                            rc = Integer.parseInt(s);
                        }
                    } else if (list.length == 2 && !(s = list[1].trim()).isEmpty()) {
                        try {
                            rc = Integer.parseInt(s);
                        }
                        catch (Throwable t) {
                            msg = s;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.code = rc;
                this.message = msg;
            }
        }
    }

    public class NameValueParser {
        private int nameBegin;
        private int nameEnd;
        private int valueBegin;
        private int valueEnd;

        public boolean next() {
            this.nameBegin = Info.this.offset;
            while (Info.this.offset < Info.this.length) {
                byte b = Info.this.buffer[Info.this.offset];
                if (b == 61) {
                    if (Info.this.offset <= this.nameBegin) {
                        return false;
                    }
                    this.nameEnd = Info.this.offset;
                    this.parseValue();
                    return true;
                }
                if (b == 10) break;
                ++Info.this.offset;
            }
            this.nameEnd = Info.this.offset;
            this.valueBegin = Info.this.offset;
            this.valueEnd = Info.this.offset;
            return Info.this.offset > this.nameBegin;
        }

        private void parseValue() {
            this.valueBegin = ++Info.this.offset;
            while (Info.this.offset < Info.this.length) {
                byte b = Info.this.buffer[Info.this.offset];
                if (b == 59) {
                    this.valueEnd = Info.this.offset++;
                    return;
                }
                if (b == 10) break;
                ++Info.this.offset;
            }
            this.valueEnd = Info.this.offset;
        }

        public String getName() {
            int len2 = this.nameEnd - this.nameBegin;
            return Buffer.utf8ToString(Info.this.buffer, this.nameBegin, len2);
        }

        public String getValue() {
            int len2 = this.valueEnd - this.valueBegin;
            if (len2 <= 0) {
                return null;
            }
            return Buffer.utf8ToString(Info.this.buffer, this.valueBegin, len2);
        }

        public String getStringBase64() {
            int len2 = this.valueEnd - this.valueBegin;
            if (len2 <= 0) {
                return null;
            }
            byte[] bytes = Crypto.decodeBase64(Info.this.buffer, this.valueBegin, len2);
            return Buffer.utf8ToString(bytes, 0, bytes.length);
        }
    }
}

