/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public final class Log {
    private static volatile Level gLevel = Level.INFO;
    private static volatile Callback gCallback = null;
    private static volatile boolean gCallbackSet = false;

    public static void setLevel(Level level) {
        gLevel = level;
    }

    public static void setCallback(Callback callback) {
        gCallback = callback;
        gCallbackSet = true;
    }

    public static void setCallbackStandard() {
        Log.setCallback(new Standard());
    }

    public static boolean isSet() {
        return gCallbackSet;
    }

    public static boolean errorEnabled() {
        return gCallback != null;
    }

    public static boolean warnEnabled() {
        return gCallback != null && Level.WARN.ordinal() <= gLevel.ordinal();
    }

    public static boolean infoEnabled() {
        return gCallback != null && Level.INFO.ordinal() <= gLevel.ordinal();
    }

    public static boolean debugEnabled() {
        return gCallback != null && Level.DEBUG.ordinal() <= gLevel.ordinal();
    }

    public static void error(String message) {
        Log.log(Level.ERROR, message);
    }

    public static void warn(String message) {
        Log.log(Level.WARN, message);
    }

    public static void info(String message) {
        Log.log(Level.INFO, message);
    }

    public static void debug(String message) {
        Log.log(Level.DEBUG, message);
    }

    public static void log(Level level, String message) {
        if (gCallback != null && level.ordinal() <= gLevel.ordinal()) {
            try {
                gCallback.log(level, message);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }

    public static interface Callback {
        public void log(Level var1, String var2);
    }

    private static class Standard
    implements Callback {
        private static final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());

        private Standard() {
        }

        @Override
        public void log(Level level, String message) {
            System.out.println(LocalDateTime.now().format(Formatter) + " " + String.valueOf((Object)level) + " " + message);
        }
    }
}

