/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.InfoListener;
import com.aerospike.client.listener.TaskStatusListener;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.task.IndexTask;
import java.util.Map;

public class AsyncIndexTask {
    private final IAerospikeClient client;
    private final String namespace;
    private final String indexName;
    private final boolean isCreate;

    public AsyncIndexTask(IAerospikeClient client, String namespace, String indexName, boolean isCreate) {
        this.client = client;
        this.namespace = namespace;
        this.indexName = indexName;
        this.isCreate = isCreate;
    }

    public void queryStatus(EventLoop eventLoop, InfoPolicy policy, Node node, final TaskStatusListener listener) {
        if (this.client.getNodes().length == 0) {
            listener.onFailure(new AerospikeException("Cluster is empty"));
        }
        final String command = IndexTask.buildStatusCommand(this.namespace, this.indexName);
        this.client.info(eventLoop, new InfoListener(){

            @Override
            public void onSuccess(Map<String, String> map) {
                try {
                    int status2 = IndexTask.parseStatusResponse(command, map.values().iterator().next(), AsyncIndexTask.this.isCreate);
                    listener.onSuccess(status2);
                }
                catch (AerospikeException ae) {
                    listener.onFailure(ae);
                }
            }

            @Override
            public void onFailure(AerospikeException ae) {
                listener.onFailure(ae);
            }
        }, policy, node, command);
    }
}

