/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncWriteBase;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.listener.RecordListener;

public final class AsyncOperateWrite
extends AsyncWriteBase {
    private final RecordListener listener;
    private final OperateArgs args;
    private Record record;

    public AsyncOperateWrite(Cluster cluster, RecordListener listener, Key key, OperateArgs args) {
        super(cluster, args.writePolicy, key);
        this.listener = listener;
        this.args = args;
    }

    @Override
    protected void writeBuffer() {
        this.setOperate(this.args.writePolicy, this.key, this.args);
    }

    @Override
    protected boolean parseResult() {
        RecordParser rp = new RecordParser(this.dataBuffer, this.dataOffset, this.receiveSize);
        rp.parseFields(this.policy.txn, this.key, true);
        if (rp.resultCode == 0) {
            this.record = rp.parseRecord(true);
            return true;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            return true;
        }
        throw new AerospikeException(rp.resultCode);
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

