/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.Log;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.ScheduleTask;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.util.Util;
import java.util.concurrent.TimeUnit;

public final class HashedWheelTimer
implements Runnable {
    private final EventLoop eventLoop;
    private final HashedWheelBucket[] wheel;
    private final ScheduleTask schedule;
    private final long tickDuration;
    private long startTime;
    private long tick;
    private final int mask;

    public HashedWheelTimer(EventLoop eventLoop, long tickDuration, TimeUnit unit, int ticksPerWheel) {
        int normalizedTicksPerWheel;
        this.eventLoop = eventLoop;
        this.tickDuration = unit.toNanos(tickDuration);
        for (normalizedTicksPerWheel = 1; normalizedTicksPerWheel < ticksPerWheel; normalizedTicksPerWheel <<= 1) {
        }
        this.wheel = new HashedWheelBucket[normalizedTicksPerWheel];
        for (int i = 0; i < this.wheel.length; ++i) {
            this.wheel[i] = new HashedWheelBucket();
        }
        this.mask = this.wheel.length - 1;
        if (this.tickDuration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", tickDuration, Long.MAX_VALUE / (long)this.wheel.length));
        }
        this.schedule = new ScheduleTask(this);
    }

    public void start() {
        this.startTime = System.nanoTime();
        this.eventLoop.schedule(this.schedule, this.tickDuration, TimeUnit.NANOSECONDS);
    }

    @Override
    public void run() {
        long expectTime;
        long currentTime = System.nanoTime() - this.startTime;
        for (expectTime = this.tickDuration * (this.tick + 1L); expectTime <= currentTime; expectTime += this.tickDuration) {
            int idx = (int)(this.tick & (long)this.mask);
            this.wheel[idx].expireTimeouts(currentTime);
            ++this.tick;
        }
        this.eventLoop.schedule(this.schedule, expectTime - currentTime, TimeUnit.NANOSECONDS);
    }

    public void addTimeout(HashedWheelTimeout timeout, long deadline) {
        timeout.deadline = deadline - this.startTime;
        timeout.next = null;
        timeout.prev = null;
        long calculated = timeout.deadline / this.tickDuration;
        timeout.remainingRounds = (calculated - this.tick) / (long)this.wheel.length;
        long ticks = Math.max(calculated, this.tick);
        int stopIndex = (int)(ticks & (long)this.mask);
        HashedWheelBucket bucket = this.wheel[stopIndex];
        bucket.addTimeout(timeout);
    }

    private static final class HashedWheelBucket {
        private HashedWheelTimeout head;
        private HashedWheelTimeout tail;

        private HashedWheelBucket() {
        }

        public void addTimeout(HashedWheelTimeout timeout) {
            timeout.bucket = this;
            if (this.head == null) {
                this.head = this.tail = timeout;
            } else {
                this.tail.next = timeout;
                timeout.prev = this.tail;
                this.tail = timeout;
            }
        }

        public void expireTimeouts(long deadline) {
            HashedWheelTimeout timeout = this.head;
            while (timeout != null) {
                HashedWheelTimeout next2 = timeout.next;
                if (timeout.remainingRounds <= 0L) {
                    next2 = this.remove(timeout);
                    if (timeout.deadline > deadline && Log.warnEnabled()) {
                        Log.warn("timeout.deadline (" + timeout.deadline + ") > deadline (" + deadline + ")");
                    }
                    timeout.expire();
                } else {
                    --timeout.remainingRounds;
                }
                timeout = next2;
            }
        }

        public HashedWheelTimeout remove(HashedWheelTimeout timeout) {
            HashedWheelTimeout next2 = timeout.next;
            if (timeout.prev != null) {
                timeout.prev.next = next2;
            }
            if (timeout.next != null) {
                timeout.next.prev = timeout.prev;
            }
            if (timeout == this.head) {
                if (timeout == this.tail) {
                    this.tail = null;
                    this.head = null;
                } else {
                    this.head = next2;
                }
            } else if (timeout == this.tail) {
                this.tail = timeout.prev;
            }
            timeout.prev = null;
            timeout.next = null;
            timeout.bucket = null;
            return next2;
        }
    }

    public static final class HashedWheelTimeout {
        private final TimerTask task;
        private long deadline;
        private long remainingRounds;
        private HashedWheelTimeout next;
        private HashedWheelTimeout prev;
        private HashedWheelBucket bucket;

        HashedWheelTimeout(TimerTask task) {
            this.task = task;
        }

        public boolean active() {
            return this.bucket != null;
        }

        public void cancel() {
            if (this.bucket != null) {
                this.bucket.remove(this);
            }
        }

        private void expire() {
            block2: {
                try {
                    this.task.timeout();
                }
                catch (Throwable t) {
                    if (!Log.warnEnabled()) break block2;
                    Log.warn("task.timeout() failed: " + Util.getErrorMessage(t));
                }
            }
        }
    }
}

