/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.async.AsyncConnectorExecutor;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.Monitor;
import com.aerospike.client.async.NettyConnection;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.ConnectionRecover;
import com.aerospike.client.cluster.ConnectionStats;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.PartitionParser;
import com.aerospike.client.cluster.Peer;
import com.aerospike.client.cluster.PeerParser;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.cluster.Pool;
import com.aerospike.client.cluster.RackParser;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.metrics.MetricsPolicy;
import com.aerospike.client.metrics.NodeMetrics;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Node
implements Closeable {
    public static final int PARTITIONS = 4096;
    public static final int HAS_PARTITION_SCAN = 1;
    public static final int HAS_QUERY_SHOW = 2;
    public static final int HAS_BATCH_ANY = 4;
    public static final int HAS_PARTITION_QUERY = 8;
    private static final String[] INFO_PERIODIC = new String[]{"node", "peers-generation", "partition-generation"};
    private static final String[] INFO_PERIODIC_REB = new String[]{"node", "peers-generation", "partition-generation", "rebalance-generation"};
    protected final Cluster cluster;
    private final String name;
    private final Host host;
    protected final List<Host> aliases;
    protected final InetSocketAddress address;
    private final Pool[] connectionPools;
    private final AsyncPool[] asyncConnectionPools;
    private Connection tendConnection;
    private byte[] sessionToken;
    private long sessionExpiration;
    private volatile Map<String, Integer> racks;
    private volatile NodeMetrics metrics;
    final AtomicInteger connsOpened;
    final AtomicInteger connsClosed;
    private final AtomicInteger errorRateCount;
    private final AtomicLong errorCount;
    private final AtomicLong timeoutCount;
    protected int connectionIter;
    private int peersGeneration;
    int partitionGeneration;
    private int rebalanceGeneration;
    protected int peersCount;
    protected int referenceCount;
    protected int failures;
    private final int features;
    protected boolean partitionChanged;
    protected boolean rebalanceChanged;
    protected volatile boolean performLogin;
    protected volatile boolean active;

    public Node(Cluster cluster, NodeValidator nv) {
        this.cluster = cluster;
        this.name = nv.name;
        this.aliases = nv.aliases;
        this.host = nv.primaryHost;
        this.address = nv.primaryAddress;
        this.tendConnection = nv.primaryConn;
        this.sessionToken = nv.sessionToken;
        this.sessionExpiration = nv.sessionExpiration;
        this.features = nv.features;
        this.connsOpened = new AtomicInteger(1);
        this.connsClosed = new AtomicInteger(0);
        this.errorRateCount = new AtomicInteger(0);
        this.errorCount = new AtomicLong(0L);
        this.timeoutCount = new AtomicLong(0L);
        this.peersGeneration = -1;
        this.partitionGeneration = -1;
        this.rebalanceGeneration = -1;
        this.partitionChanged = true;
        this.rebalanceChanged = cluster.rackAware;
        this.racks = cluster.rackAware ? new HashMap() : null;
        this.active = true;
        if (cluster.metricsEnabled) {
            this.metrics = new NodeMetrics(cluster.metricsPolicy);
        }
        this.connectionPools = new Pool[cluster.connPoolsPerNode];
        int min2 = cluster.minConnsPerNode / cluster.connPoolsPerNode;
        int remMin = cluster.minConnsPerNode - min2 * cluster.connPoolsPerNode;
        int max2 = cluster.maxConnsPerNode / cluster.connPoolsPerNode;
        int remMax = cluster.maxConnsPerNode - max2 * cluster.connPoolsPerNode;
        for (int i = 0; i < this.connectionPools.length; ++i) {
            Pool pool;
            int minSize = i < remMin ? min2 + 1 : min2;
            int maxSize = i < remMax ? max2 + 1 : max2;
            this.connectionPools[i] = pool = new Pool(minSize, maxSize);
        }
        EventState[] eventState = cluster.eventState;
        if (eventState == null) {
            this.asyncConnectionPools = null;
            return;
        }
        this.asyncConnectionPools = new AsyncPool[eventState.length];
        min2 = cluster.asyncMinConnsPerNode / this.asyncConnectionPools.length;
        remMin = cluster.asyncMinConnsPerNode - min2 * this.asyncConnectionPools.length;
        max2 = cluster.asyncMaxConnsPerNode / this.asyncConnectionPools.length;
        remMax = cluster.asyncMaxConnsPerNode - max2 * this.asyncConnectionPools.length;
        for (int i = 0; i < eventState.length; ++i) {
            int minSize = i < remMin ? min2 + 1 : min2;
            int maxSize = i < remMax ? max2 + 1 : max2;
            this.asyncConnectionPools[i] = new AsyncPool(minSize, maxSize);
        }
    }

    public final void createMinConnections() {
        for (Pool pool : this.connectionPools) {
            if (pool.minSize <= 0) continue;
            this.createConnections(pool, pool.minSize);
        }
        EventState[] eventState = this.cluster.eventState;
        if (eventState == null || this.cluster.asyncMinConnsPerNode <= 0) {
            return;
        }
        final Monitor monitor = new Monitor();
        final AtomicInteger eventLoopCount = new AtomicInteger(eventState.length);
        final int maxConcurrent = 20 / eventState.length + 1;
        for (int i = 0; i < eventState.length; ++i) {
            final int minSize = this.asyncConnectionPools[i].minSize;
            if (minSize > 0) {
                final EventLoop eventLoop = eventState[i].eventLoop;
                final Node node = this;
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                new AsyncConnectorExecutor(eventLoop, Node.this.cluster, node, minSize, maxConcurrent, monitor, eventLoopCount);
                            }
                            catch (Throwable e) {
                                if (!Log.warnEnabled()) break block2;
                                Log.warn("AsyncConnectorExecutor failed: " + Util.getErrorMessage(e));
                            }
                        }
                    }
                });
                continue;
            }
            AsyncConnectorExecutor.eventLoopComplete(monitor, eventLoopCount);
        }
        monitor.waitTillComplete();
    }

    public final void refresh(Peers peers) {
        if (!this.active) {
            return;
        }
        try {
            if (this.tendConnection.isClosed()) {
                this.tendConnection = this.createConnection(null, this.cluster.connectTimeout);
                if (this.cluster.authEnabled) {
                    byte[] token = this.sessionToken;
                    if (token == null || this.shouldLogin()) {
                        this.login();
                    } else if (!AdminCommand.authenticate(this.cluster, this.tendConnection, token)) {
                        this.login();
                    }
                }
            } else if (this.cluster.authEnabled && this.shouldLogin()) {
                this.login();
            }
            String[] commands = this.cluster.rackAware ? INFO_PERIODIC_REB : INFO_PERIODIC;
            HashMap<String, String> infoMap = Info.request(this.tendConnection, commands);
            this.verifyNodeName(infoMap);
            this.verifyPeersGeneration(infoMap, peers);
            this.verifyPartitionGeneration(infoMap);
            if (this.cluster.rackAware) {
                this.verifyRebalanceGeneration(infoMap);
            }
            ++peers.refreshCount;
            if (this.failures > 0) {
                peers.genChanged = true;
                this.partitionChanged = true;
                this.rebalanceChanged = this.cluster.rackAware;
            }
            this.failures = 0;
        }
        catch (Throwable e) {
            peers.genChanged = true;
            this.refreshFailed(e);
        }
    }

    private boolean shouldLogin() {
        return this.performLogin || this.sessionExpiration > 0L && System.nanoTime() >= this.sessionExpiration;
    }

    private void login() throws IOException {
        if (Log.infoEnabled()) {
            Log.info("Login to " + String.valueOf(this));
        }
        try {
            AdminCommand.LoginCommand login = new AdminCommand.LoginCommand(this.cluster, this.tendConnection);
            this.sessionToken = login.sessionToken;
            this.sessionExpiration = login.sessionExpiration;
            this.performLogin = false;
        }
        catch (Throwable e) {
            this.performLogin = true;
            throw e;
        }
    }

    public final void signalLogin() {
        if (!this.performLogin) {
            this.performLogin = true;
            this.cluster.interruptTendSleep();
        }
    }

    private final void verifyNodeName(HashMap<String, String> infoMap) {
        String infoName = infoMap.get("node");
        if (infoName == null || infoName.length() == 0) {
            throw new AerospikeException.Parse("Node name is empty");
        }
        if (!this.name.equals(infoName)) {
            this.active = false;
            throw new AerospikeException("Node name has changed. Old=" + this.name + " New=" + infoName);
        }
    }

    private final void verifyPeersGeneration(HashMap<String, String> infoMap, Peers peers) {
        String genString = infoMap.get("peers-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("peers-generation is empty");
        }
        int gen = Integer.parseInt(genString);
        if (this.peersGeneration != gen) {
            peers.genChanged = true;
            if (this.peersGeneration > gen) {
                if (Log.infoEnabled()) {
                    Log.info("Quick node restart detected: node=" + String.valueOf(this) + " oldgen=" + this.peersGeneration + " newgen=" + gen);
                }
                this.restart();
            }
        }
    }

    private final void restart() {
        block6: {
            try {
                if (this.cluster.maxErrorRate > 0) {
                    this.resetErrorRate();
                }
                if (this.cluster.authEnabled) {
                    this.login();
                }
                this.balanceConnections();
                if (this.cluster.eventState != null) {
                    for (EventState es : this.cluster.eventState) {
                        final EventLoop eventLoop = es.eventLoop;
                        eventLoop.execute(new Runnable(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        Node.this.balanceAsyncConnections(eventLoop);
                                    }
                                    catch (Throwable e) {
                                        if (!Log.warnEnabled()) break block2;
                                        Log.warn("balanceAsyncConnections failed: " + String.valueOf(this) + " " + Util.getErrorMessage(e));
                                    }
                                }
                            }
                        });
                    }
                }
            }
            catch (Throwable e) {
                if (!Log.warnEnabled()) break block6;
                Log.warn("Node restart failed: " + String.valueOf(this) + " " + Util.getErrorMessage(e));
            }
        }
    }

    private final void verifyPartitionGeneration(HashMap<String, String> infoMap) {
        String genString = infoMap.get("partition-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("partition-generation is empty");
        }
        int gen = Integer.parseInt(genString);
        if (this.partitionGeneration != gen) {
            this.partitionChanged = true;
        }
    }

    private final void verifyRebalanceGeneration(HashMap<String, String> infoMap) {
        String genString = infoMap.get("rebalance-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("rebalance-generation is empty");
        }
        int gen = Integer.parseInt(genString);
        if (this.rebalanceGeneration != gen) {
            this.rebalanceChanged = true;
        }
    }

    protected final void refreshPeers(Peers peers) {
        if (this.failures > 0 || !this.active) {
            return;
        }
        try {
            if (Log.debugEnabled()) {
                Log.debug("Update peers for node " + String.valueOf(this));
            }
            PeerParser parser = new PeerParser(this.cluster, this.tendConnection, peers.peers);
            this.peersCount = peers.peers.size();
            boolean peersValidated = true;
            for (Peer peer : peers.peers) {
                if (Node.findPeerNode(this.cluster, peers, peer)) continue;
                boolean nodeValidated = false;
                for (Host host : peer.hosts) {
                    if (peers.hasFailed(host)) continue;
                    try {
                        NodeValidator nv = new NodeValidator();
                        nv.validateNode(this.cluster, host);
                        if (!peer.nodeName.equals(nv.name) && Log.warnEnabled()) {
                            Log.warn("Peer node " + peer.nodeName + " is different than actual node " + nv.name + " for host " + String.valueOf(host));
                        }
                        Node node = this.cluster.createNode(nv);
                        peers.nodes.put(nv.name, node);
                        nodeValidated = true;
                        if (peer.replaceNode == null) break;
                        peers.removeList.add(peer.replaceNode);
                        break;
                    }
                    catch (Throwable e) {
                        peers.fail(host);
                        if (!Log.warnEnabled()) continue;
                        Log.warn("Add node " + String.valueOf(host) + " failed: " + Util.getErrorMessage(e));
                    }
                }
                if (nodeValidated) continue;
                peersValidated = false;
            }
            if (peersValidated) {
                this.peersGeneration = parser.generation;
            }
            ++peers.refreshCount;
        }
        catch (Throwable e) {
            this.refreshFailed(e);
        }
    }

    private static boolean findPeerNode(Cluster cluster, Peers peers, Peer peer) {
        Node node = cluster.nodesMap.get(peer.nodeName);
        if (node != null) {
            if (node.failures <= 0 || node.address.getAddress().isLoopbackAddress()) {
                ++node.referenceCount;
                return true;
            }
            for (Host h : peer.hosts) {
                if (!h.equals(node.host)) continue;
                ++node.referenceCount;
                return true;
            }
            peer.replaceNode = node;
        }
        if ((node = peers.nodes.get(peer.nodeName)) != null) {
            ++node.referenceCount;
            peer.replaceNode = null;
            return true;
        }
        return false;
    }

    protected final void refreshPartitions(Peers peers) {
        if (this.failures > 0 || !this.active || this.peersCount == 0 && peers.refreshCount > 1) {
            return;
        }
        try {
            PartitionParser parser;
            if (Log.debugEnabled()) {
                Log.debug("Update partition map for node " + String.valueOf(this));
            }
            if ((parser = new PartitionParser(this.tendConnection, this, this.cluster.partitionMap, 4096)).isPartitionMapCopied()) {
                this.cluster.partitionMap = parser.getPartitionMap();
            }
            this.partitionGeneration = parser.getGeneration();
        }
        catch (Throwable e) {
            this.refreshFailed(e);
        }
    }

    protected final void refreshRacks() {
        if (this.failures > 0 || !this.active) {
            return;
        }
        try {
            if (Log.debugEnabled()) {
                Log.debug("Update racks for node " + String.valueOf(this));
            }
            RackParser parser = new RackParser(this.tendConnection);
            this.rebalanceGeneration = parser.getGeneration();
            this.racks = parser.getRacks();
        }
        catch (Throwable e) {
            this.refreshFailed(e);
        }
    }

    private final void refreshFailed(Throwable e) {
        ++this.failures;
        if (!this.tendConnection.isClosed()) {
            this.closeConnectionOnError(this.tendConnection);
        }
        if (this.cluster.tendValid && Log.warnEnabled()) {
            Log.warn("Node " + String.valueOf(this) + " refresh failed: " + Util.getErrorMessage(e));
        }
    }

    private void createConnections(Pool pool, int count) {
        while (count > 0) {
            Connection conn;
            try {
                conn = this.createConnection(pool);
            }
            catch (Throwable e) {
                if (Log.debugEnabled()) {
                    Log.debug("Failed to create connection: " + e.getMessage());
                }
                return;
            }
            if (!pool.offer(conn)) {
                this.closeIdleConnection(conn);
                break;
            }
            pool.total.getAndIncrement();
            --count;
        }
    }

    private Connection createConnection(Pool pool) {
        byte[] token;
        Connection conn = this.createConnection(pool, this.cluster.connectTimeout);
        if (this.cluster.authEnabled && (token = this.sessionToken) != null) {
            try {
                if (!AdminCommand.authenticate(this.cluster, conn, token)) {
                    throw new AerospikeException("Authentication failed");
                }
            }
            catch (AerospikeException ae) {
                this.closeConnectionOnError(conn);
                throw ae;
            }
            catch (Throwable e) {
                this.closeConnectionOnError(conn);
                throw new AerospikeException(e);
            }
        }
        return conn;
    }

    private Connection createConnection(Pool pool, int timeout) {
        Connection conn;
        if (this.cluster.metricsEnabled) {
            long begin = System.nanoTime();
            conn = this.cluster.tlsPolicy != null && !this.cluster.tlsPolicy.forLoginOnly ? new Connection(this.cluster.tlsPolicy, this.host.tlsName, this.address, timeout, this, pool) : new Connection(this.address, timeout, this, pool);
            long elapsed = System.nanoTime() - begin;
            this.metrics.addLatency(LatencyType.CONN, TimeUnit.NANOSECONDS.toMillis(elapsed));
        } else {
            conn = this.cluster.tlsPolicy != null && !this.cluster.tlsPolicy.forLoginOnly ? new Connection(this.cluster.tlsPolicy, this.host.tlsName, this.address, timeout, this, pool) : new Connection(this.address, timeout, this, pool);
        }
        this.connsOpened.getAndIncrement();
        return conn;
    }

    public final Connection getConnection(int timeoutMillis) {
        try {
            return this.getConnection(null, timeoutMillis, timeoutMillis, 0);
        }
        catch (Connection.ReadTimeout crt) {
            throw new AerospikeException.Timeout(this, timeoutMillis, timeoutMillis, timeoutMillis);
        }
    }

    public final Connection getConnection(int connectTimeout, int socketTimeout) {
        try {
            return this.getConnection(null, connectTimeout, socketTimeout, 0);
        }
        catch (Connection.ReadTimeout crt) {
            throw new AerospikeException.Timeout(this, connectTimeout, socketTimeout, socketTimeout);
        }
    }

    public final Connection getConnection(SyncCommand cmd, int connectTimeout, int socketTimeout, int timeoutDelay) {
        boolean backward;
        int initialIndex;
        int max2 = this.cluster.connPoolsPerNode;
        if (max2 == 1) {
            initialIndex = 0;
            backward = false;
        } else {
            int iter;
            if ((initialIndex = (iter = this.connectionIter++) % max2) < 0) {
                initialIndex += max2;
            }
            backward = true;
        }
        Pool pool = this.connectionPools[initialIndex];
        int queueIndex = initialIndex;
        while (true) {
            Connection conn;
            if ((conn = pool.poll()) != null) {
                if (this.cluster.isConnCurrentTran(conn.getLastUsed())) {
                    try {
                        conn.setTimeout(socketTimeout);
                        return conn;
                    }
                    catch (Throwable e) {
                        this.closeConnection(conn);
                        throw new AerospikeException.Connection(e);
                    }
                }
                pool.closeIdle(this, conn);
                continue;
            }
            if (pool.total.getAndIncrement() < pool.capacity()) {
                byte[] token;
                long startTime;
                int timeout;
                if (connectTimeout > 0) {
                    timeout = connectTimeout;
                    startTime = System.nanoTime();
                } else {
                    timeout = socketTimeout;
                    startTime = 0L;
                }
                try {
                    conn = this.createConnection(pool, timeout);
                }
                catch (Throwable e) {
                    pool.total.getAndDecrement();
                    throw e;
                }
                if (this.cluster.authEnabled && (token = this.sessionToken) != null) {
                    try {
                        if (!AdminCommand.authenticate(this.cluster, conn, token)) {
                            this.signalLogin();
                            throw new AerospikeException("Authentication failed");
                        }
                    }
                    catch (AerospikeException ae) {
                        this.closeConnection(conn);
                        throw ae;
                    }
                    catch (Connection.ReadTimeout crt) {
                        if (timeoutDelay > 0) {
                            this.cluster.recoverConnection(new ConnectionRecover(conn, this, timeoutDelay, crt, true));
                        } else {
                            this.closeConnection(conn);
                        }
                        throw crt;
                    }
                    catch (SocketTimeoutException ste) {
                        this.closeConnection(conn);
                        throw new Connection.ReadTimeout(null, 0, 0, 0);
                    }
                    catch (IOException ioe) {
                        this.closeConnection(conn);
                        throw new AerospikeException.Connection(ioe);
                    }
                    catch (Throwable e) {
                        this.closeConnection(conn);
                        throw e;
                    }
                }
                if (timeout != socketTimeout) {
                    try {
                        conn.setTimeout(socketTimeout);
                    }
                    catch (Throwable e) {
                        this.closeConnection(conn);
                        throw new AerospikeException.Connection(e);
                    }
                }
                if (connectTimeout > 0 && cmd != null) {
                    cmd.resetDeadline(startTime);
                }
                return conn;
            }
            pool.total.getAndDecrement();
            if (backward) {
                if (queueIndex > 0) {
                    --queueIndex;
                } else {
                    queueIndex = initialIndex;
                    if (++queueIndex >= max2) break;
                    backward = false;
                }
            } else if (++queueIndex >= max2) break;
            pool = this.connectionPools[queueIndex];
        }
        throw new AerospikeException.Connection(-7, "Node " + String.valueOf(this) + " max connections " + this.cluster.maxConnsPerNode + " would be exceeded.");
    }

    public final void putConnection(Connection conn) {
        if (!this.active || !conn.pool.offer(conn)) {
            this.closeConnection(conn);
        }
    }

    public final void closeConnection(Connection conn) {
        conn.pool.total.getAndDecrement();
        this.closeConnectionOnError(conn);
    }

    public final void closeConnectionOnError(Connection conn) {
        this.connsClosed.getAndIncrement();
        this.incrErrorRate();
        conn.close();
    }

    public final void closeIdleConnection(Connection conn) {
        this.connsClosed.getAndIncrement();
        conn.close();
    }

    final void balanceConnections() {
        for (Pool pool : this.connectionPools) {
            int excess = pool.excess();
            if (excess > 0) {
                pool.closeIdle(this, excess);
                continue;
            }
            if (excess >= 0 || !this.errorRateWithinLimit()) continue;
            this.createConnections(pool, -excess);
        }
    }

    public final ConnectionStats getConnectionStats() {
        int inUse = 0;
        int inPool = 0;
        for (Pool pool : this.connectionPools) {
            int tmp = pool.size();
            inPool += tmp;
            tmp = pool.total.get() - tmp;
            if (tmp < 0) {
                tmp = 0;
            }
            inUse += tmp;
        }
        return new ConnectionStats(inUse, inPool, this.connsOpened.get(), this.connsClosed.get());
    }

    public final AsyncConnection getAsyncConnection(int index2, ByteBuffer byteBuffer) {
        AsyncConnection conn;
        AsyncPool pool = this.asyncConnectionPools[index2];
        ArrayDeque<AsyncConnection> queue = pool.queue;
        while ((conn = queue.pollFirst()) != null) {
            if (!this.cluster.isConnCurrentTran(conn.getLastUsed())) {
                this.closeAsyncIdleConnection(conn, index2);
                continue;
            }
            if (!conn.isValid(byteBuffer)) {
                this.closeAsyncConnection(conn, index2);
                continue;
            }
            return conn;
        }
        if (pool.reserve()) {
            return null;
        }
        throw new AerospikeException.Connection(-7, "Max async conns reached: " + String.valueOf(this) + "," + index2 + "," + pool.total + "," + pool.queue.size() + "," + pool.maxSize);
    }

    public final boolean reserveAsyncConnectionSlot(int index2) {
        return this.asyncConnectionPools[index2].reserve();
    }

    public final void connectionOpened(int index2) {
        ++this.asyncConnectionPools[index2].opened;
    }

    public final boolean putAsyncConnection(AsyncConnection conn, int index2) {
        if (conn == null) {
            if (Log.warnEnabled()) {
                Log.warn("Async conn is null: " + String.valueOf(this) + "," + index2);
            }
            return false;
        }
        AsyncPool pool = this.asyncConnectionPools[index2];
        if (!pool.addFirst(conn)) {
            conn.close();
            if (Log.warnEnabled()) {
                Log.warn("Async conn pool is full: " + String.valueOf(this) + "," + index2 + "," + pool.total + "," + pool.queue.size() + "," + pool.maxSize);
            }
            return false;
        }
        return true;
    }

    public final void closeAsyncConnection(AsyncConnection conn, int index2) {
        this.incrErrorRate();
        this.asyncConnectionPools[index2].connectionClosed();
        conn.close();
    }

    public final void closeAsyncIdleConnection(AsyncConnection conn, int index2) {
        this.asyncConnectionPools[index2].connectionClosed();
        conn.close();
    }

    public final void decrAsyncConnection(int index2) {
        this.incrErrorRate();
        --this.asyncConnectionPools[index2].total;
    }

    public final AsyncPool getAsyncPool(int index2) {
        return this.asyncConnectionPools[index2];
    }

    public final void balanceAsyncConnections(EventLoop eventLoop) {
        AsyncPool pool = this.asyncConnectionPools[eventLoop.getIndex()];
        pool.handleRemove();
        int excess = pool.excess();
        if (excess > 0) {
            this.closeIdleAsyncConnections(pool, excess);
        } else if (excess < 0 && this.errorRateWithinLimit()) {
            new AsyncConnectorExecutor(eventLoop, this.cluster, this, -excess, 1, null, null);
        }
    }

    private final void closeIdleAsyncConnections(AsyncPool pool, int count) {
        AsyncConnection conn;
        ArrayDeque<AsyncConnection> queue = pool.queue;
        while (count > 0 && (conn = queue.peekLast()) != null && !this.cluster.isConnCurrentTrim(conn.getLastUsed())) {
            queue.pollLast();
            pool.connectionClosed();
            conn.close();
            --count;
        }
    }

    public final ConnectionStats getAsyncConnectionStats() {
        int inUse = 0;
        int inPool = 0;
        int opened = 0;
        int closed = 0;
        if (this.asyncConnectionPools != null) {
            for (AsyncPool pool : this.asyncConnectionPools) {
                int tmp = pool.queue.size();
                if (tmp < 0) {
                    tmp = 0;
                }
                inPool += tmp;
                if ((tmp = pool.total - tmp) < 0) {
                    tmp = 0;
                }
                inUse += tmp;
                opened += pool.opened;
                closed += pool.closed;
            }
        }
        return new ConnectionStats(inUse, inPool, opened, closed);
    }

    public final void enableMetrics(MetricsPolicy policy) {
        this.metrics = new NodeMetrics(policy);
    }

    public final NodeMetrics getMetrics() {
        return this.metrics;
    }

    public final void addLatency(LatencyType type2, long elapsed) {
        this.metrics.addLatency(type2, elapsed);
    }

    public final void incrErrorRate() {
        if (this.cluster.maxErrorRate > 0) {
            this.errorRateCount.getAndIncrement();
        }
    }

    public final void resetErrorRate() {
        this.errorRateCount.set(0);
    }

    public final boolean errorRateWithinLimit() {
        return this.cluster.maxErrorRate <= 0 || this.errorRateCount.get() <= this.cluster.maxErrorRate;
    }

    public final void validateErrorCount() {
        if (!this.errorRateWithinLimit()) {
            throw new AerospikeException.Backoff(-12);
        }
    }

    public void addError() {
        this.errorCount.getAndIncrement();
    }

    public void addTimeout() {
        this.timeoutCount.getAndIncrement();
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getTimeoutCount() {
        return this.timeoutCount.get();
    }

    public final Host getHost() {
        return this.host;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getName() {
        return this.name;
    }

    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public final byte[] getSessionToken() {
        return this.sessionToken;
    }

    public final int getPeersGeneration() {
        return this.peersGeneration;
    }

    public final int getPartitionGeneration() {
        return this.partitionGeneration;
    }

    public final int getRebalanceGeneration() {
        return this.rebalanceGeneration;
    }

    public final boolean hasRack(String namespace, int rackId) {
        Map<String, Integer> map = this.racks;
        if (map == null) {
            return false;
        }
        Integer r = map.get(namespace);
        if (r == null) {
            return false;
        }
        return r == rackId;
    }

    public final boolean hasQueryShow() {
        return (this.features & 2) != 0;
    }

    public final boolean hasBatchAny() {
        return (this.features & 4) != 0;
    }

    public final boolean hasPartitionQuery() {
        return (this.features & 8) != 0;
    }

    public final String toString() {
        return this.name + " " + String.valueOf(this.host);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        Node other = (Node)obj;
        return this.name.equals(other.name);
    }

    @Override
    public final void close() {
        if (this.cluster.eventLoops == null) {
            this.closeSyncConnections();
        } else {
            final AtomicInteger eventLoopCount = new AtomicInteger(this.cluster.eventState.length);
            for (final EventState state : this.cluster.eventState) {
                state.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        Node.this.closeConnections(eventLoopCount, state.index);
                    }
                });
            }
        }
    }

    public final void closeConnections(AtomicInteger eventLoopCount, int index2) {
        this.closeAsyncConnections(index2);
        if (eventLoopCount.decrementAndGet() == 0) {
            this.closeSyncConnections();
        }
    }

    public final void closeAsyncConnections(int index2) {
        AsyncPool pool = this.asyncConnectionPools[index2];
        pool.closeConnections();
    }

    public final void closeSyncConnections() {
        this.active = false;
        Connection conn = this.tendConnection;
        conn.close();
        for (Pool pool : this.connectionPools) {
            while ((conn = pool.poll()) != null) {
                conn.close();
            }
        }
    }

    public static final class AsyncPool {
        public final ArrayDeque<AsyncConnection> queue;
        public final int minSize;
        public final int maxSize;
        public int total;
        public int opened;
        public int closed;
        private boolean shouldRemove;

        private AsyncPool(int minSize, int maxSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.queue = new ArrayDeque(maxSize);
        }

        private boolean reserve() {
            if (this.total >= this.maxSize || this.queue.size() >= this.maxSize) {
                return false;
            }
            ++this.total;
            return true;
        }

        private boolean addFirst(AsyncConnection conn) {
            if (this.queue.size() < this.maxSize) {
                this.queue.addFirst(conn);
                return true;
            }
            return false;
        }

        private int excess() {
            return this.total - this.minSize;
        }

        private void connectionClosed() {
            --this.total;
            ++this.closed;
        }

        public void signalRemove() {
            this.shouldRemove = true;
        }

        public void handleRemove() {
            if (this.shouldRemove) {
                this.shouldRemove = false;
                this.removeClosed();
            }
        }

        public void removeClosed() {
            NettyConnection first;
            NettyConnection conn = first = (NettyConnection)this.queue.pollFirst();
            while (conn != null) {
                if (conn.isOpen()) {
                    this.queue.addLast(conn);
                } else {
                    this.connectionClosed();
                }
                if ((conn = (NettyConnection)this.queue.pollFirst()) != first) continue;
            }
        }

        public void closeConnections() {
            AsyncConnection conn;
            while ((conn = this.queue.pollFirst()) != null) {
                conn.close();
            }
        }
    }
}

