/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchStatus;
import com.aerospike.client.command.IBatchCommand;
import com.aerospike.client.policy.BatchPolicy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class BatchExecutor {
    public static void execute(Cluster cluster, BatchPolicy policy, IBatchCommand[] commands, BatchStatus status2) {
        cluster.addCommandCount();
        if (commands.length <= 1) {
            for (IBatchCommand command : commands) {
                try {
                    command.execute();
                }
                catch (AerospikeException ae) {
                    if (ae.getInDoubt()) {
                        command.setInDoubt();
                    }
                    status2.setException(ae);
                }
                catch (Throwable e) {
                    command.setInDoubt();
                    status2.setException(new AerospikeException(e));
                }
            }
            status2.checkException();
            return;
        }
        try (ExecutorService es = Executors.newThreadPerTaskExecutor(cluster.threadFactory);){
            for (IBatchCommand command : commands) {
                es.execute(command);
            }
        }
        status2.checkException();
    }
}

