/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Txn;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.Command;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class RecordParser {
    public final byte[] dataBuffer;
    public final int resultCode;
    public final int generation;
    public final int expiration;
    public final int fieldCount;
    public final int opCount;
    public int dataOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordParser(Connection conn, byte[] buffer) throws IOException {
        int offset;
        conn.readFully(buffer, 8, (byte)2);
        long sz = Buffer.bytesToLong(buffer, 0);
        int receiveSize = (int)(sz & 0xFFFFFFFFFFFFL);
        if (receiveSize <= 0) {
            throw new AerospikeException("Invalid receive size: " + receiveSize);
        }
        if (receiveSize > buffer.length) {
            buffer = new byte[receiveSize];
        }
        conn.readFully(buffer, receiveSize, (byte)3);
        conn.updateLastUsed();
        long type2 = sz >> 48 & 0xFFL;
        if (type2 == 3L) {
            offset = 5;
        } else {
            if (type2 == 4L) {
                int usize = (int)Buffer.bytesToLong(buffer, 0);
                byte[] buf = new byte[usize];
                Inflater inf = new Inflater();
                try {
                    int rsize;
                    inf.setInput(buffer, 8, receiveSize - 8);
                    try {
                        rsize = inf.inflate(buf);
                    }
                    catch (DataFormatException dfe) {
                        throw new AerospikeException.Serialize(dfe);
                    }
                    if (rsize != usize) {
                        throw new AerospikeException("Decompressed size " + rsize + " is not expected " + usize);
                    }
                    buffer = buf;
                    offset = 13;
                }
                finally {
                    inf.end();
                }
            }
            throw new AerospikeException("Invalid proto type: " + type2 + " Expected: 3");
        }
        this.resultCode = buffer[offset] & 0xFF;
        this.generation = Buffer.bytesToInt(buffer, ++offset);
        this.expiration = Buffer.bytesToInt(buffer, offset += 4);
        this.fieldCount = Buffer.bytesToShort(buffer, offset += 8);
        this.opCount = Buffer.bytesToShort(buffer, offset += 2);
        this.dataOffset = offset += 2;
        this.dataBuffer = buffer;
    }

    public RecordParser(byte[] buffer, int offset, int receiveSize) {
        if (receiveSize < 22) {
            throw new AerospikeException.Parse("Invalid receive size: " + receiveSize);
        }
        this.resultCode = buffer[offset += 5] & 0xFF;
        this.generation = Buffer.bytesToInt(buffer, ++offset);
        this.expiration = Buffer.bytesToInt(buffer, offset += 4);
        this.fieldCount = Buffer.bytesToShort(buffer, offset += 8);
        this.opCount = Buffer.bytesToShort(buffer, offset += 2);
        this.dataOffset = offset += 2;
        this.dataBuffer = buffer;
    }

    public void parseFields(Txn txn, Key key, boolean hasWrite) {
        if (txn == null) {
            this.skipFields();
            return;
        }
        Long version = null;
        for (int i = 0; i < this.fieldCount; ++i) {
            int len2 = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte type2 = this.dataBuffer[this.dataOffset++];
            int size = len2 - 1;
            if (type2 == 3) {
                if (size == 7) {
                    version = Buffer.versionBytesToLong(this.dataBuffer, this.dataOffset);
                } else {
                    throw new AerospikeException("Record version field has invalid size: " + size);
                }
            }
            this.dataOffset += size;
        }
        if (hasWrite) {
            txn.onWrite(key, version, this.resultCode);
        } else {
            txn.onRead(key, version);
        }
    }

    public void parseTranDeadline(Txn txn) {
        for (int i = 0; i < this.fieldCount; ++i) {
            int len2 = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte type2 = this.dataBuffer[this.dataOffset++];
            int size = len2 - 1;
            if (type2 == 6) {
                int deadline = Buffer.littleBytesToInt(this.dataBuffer, this.dataOffset);
                txn.setDeadline(deadline);
            }
            this.dataOffset += size;
        }
    }

    private void skipFields() {
        for (int i = 0; i < this.fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4 + fieldlen;
        }
    }

    public Record parseRecord(boolean isOperation) {
        if (this.opCount == 0) {
            return new Record(null, this.generation, this.expiration);
        }
        LinkedHashMap<String, Object> bins = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            if (isOperation) {
                if (bins.containsKey(name)) {
                    Command.OpResults list;
                    Object prev = bins.get(name);
                    if (prev instanceof Command.OpResults) {
                        list = (Command.OpResults)prev;
                        list.add(value);
                        continue;
                    }
                    list = new Command.OpResults();
                    list.add(prev);
                    list.add(value);
                    bins.put(name, list);
                    continue;
                }
                bins.put(name, value);
                continue;
            }
            bins.put(name, value);
        }
        return new Record(bins, this.generation, this.expiration);
    }
}

