/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaList;
import java.util.ArrayList;
import java.util.Iterator;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public final class LuaListLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaListLib(LuaInstance instance) {
        this.instance = instance;
        instance.load(new MetaLib(instance));
    }

    @Override
    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 15);
        table.setmetatable(meta);
        table.set("create", (LuaValue)new create(this.instance));
        new listcode(table, 0, "size");
        new listcode(table, 4, "iterator");
        new listcode(table, 5, "insert");
        new listcode(table, 6, "append");
        new listcode(table, 7, "prepend");
        new listcode(table, 8, "take");
        new listcode(table, 9, "remove");
        new listcode(table, 10, "drop");
        new listcode(table, 11, "trim");
        new listcode(table, 12, "clone");
        new listcode(table, 13, "concat");
        new listcode(table, 14, "merge");
        this.instance.registerPackage("list", table);
        return table;
    }

    private static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        @Override
        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            new listcode(meta, 0, "__len");
            new listcode(meta, 1, "__tostring");
            new listcode(meta, 2, "__index");
            new listcode(meta, 3, "__newindex");
            this.instance.registerPackage("List", meta);
            return meta;
        }
    }

    private static final class create
    extends VarArgFunction {
        private final LuaInstance instance;

        public create(LuaInstance instance) {
            this.instance = instance;
        }

        @Override
        public Varargs invoke(Varargs args) {
            int capacity = 32;
            if (args.isnumber(1)) {
                capacity = args.toint(1);
            }
            LuaList list = new LuaList(this.instance, new ArrayList<LuaValue>(capacity));
            if (args.istable(2)) {
                Varargs n;
                LuaTable table = args.checktable(2);
                LuaValue k = LuaValue.NIL;
                while (!(k = (n = table.next(k)).arg1()).isnil()) {
                    LuaValue v = n.arg(2);
                    list.append(v);
                }
            }
            return list;
        }
    }

    private static final class listcode
    extends VarArgFunction {
        public listcode(LuaTable table, int id, String name) {
            this.opcode = id;
            this.name = name;
            table.set(name, (LuaValue)this);
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaList list = (LuaList)args.arg(1);
            switch (this.opcode) {
                case 0: {
                    return list.size();
                }
                case 1: {
                    return list.toLuaString();
                }
                case 2: {
                    return list.get(args.arg(2));
                }
                case 3: {
                    list.set(args.arg(2), args.arg(3));
                    return NIL;
                }
                case 4: {
                    return new nextLuaValue(list.iterator());
                }
                case 5: {
                    list.insert(args.arg(2), args.arg(3));
                    return NIL;
                }
                case 6: {
                    list.append(args.arg(2));
                    return NIL;
                }
                case 7: {
                    list.prepend(args.arg(2));
                    return NIL;
                }
                case 8: {
                    return list.take(args.arg(2));
                }
                case 9: {
                    list.remove(args.arg(2));
                    return NIL;
                }
                case 10: {
                    return list.drop(args.arg(2));
                }
                case 11: {
                    list.trim(args.arg(2));
                    return NIL;
                }
                case 12: {
                    return list.clone();
                }
                case 13: {
                    list.concat((LuaList)args.arg(2));
                    return NIL;
                }
                case 14: {
                    return list.merge((LuaList)args.arg(2));
                }
            }
            return NIL;
        }
    }

    public static final class nextLuaValue
    extends ZeroArgFunction {
        private final Iterator<LuaValue> iter;

        public nextLuaValue(Iterator<LuaValue> iter) {
            this.iter = iter;
        }

        @Override
        public LuaValue call() {
            return this.iter.hasNext() ? this.iter.next() : LuaValue.NIL;
        }
    }
}

