/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaListLib;
import com.aerospike.client.lua.LuaMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public final class LuaMapLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaMapLib(LuaInstance instance) {
        this.instance = instance;
        instance.load(new MetaLib(instance));
    }

    @Override
    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 11);
        table.setmetatable(meta);
        table.set("create", (LuaValue)new create(this.instance));
        new mapcode(table, 0, "size");
        new mapcode(table, 4, "pairs");
        new mapcode(table, 5, "keys");
        new mapcode(table, 6, "values");
        new mapcode(table, 7, "remove");
        new mapcode(table, 8, "clone");
        new mapcode(table, 9, "merge");
        new mapcode(table, 10, "diff");
        this.instance.registerPackage("map", table);
        return table;
    }

    private static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        @Override
        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            new mapcode(meta, 0, "__len");
            new mapcode(meta, 1, "__tostring");
            new mapcode(meta, 2, "__index");
            new mapcode(meta, 3, "__newindex");
            this.instance.registerPackage("Map", meta);
            return meta;
        }
    }

    private static final class create
    extends VarArgFunction {
        private final LuaInstance instance;

        public create(LuaInstance instance) {
            this.instance = instance;
        }

        @Override
        public Varargs invoke(Varargs args) {
            int capacity = 32;
            if (args.isnumber(1)) {
                capacity = args.toint(1);
            }
            LuaMap map = new LuaMap(this.instance, new HashMap<LuaValue, LuaValue>(capacity));
            if (args.istable(2)) {
                Varargs n;
                LuaTable table = args.checktable(2);
                LuaValue k = LuaValue.NIL;
                while (!(k = (n = table.next(k)).arg1()).isnil()) {
                    LuaValue v = n.arg(2);
                    map.put(k, v);
                }
            }
            return map;
        }
    }

    private static final class mapcode
    extends VarArgFunction {
        public mapcode(LuaTable table, int id, String name) {
            this.opcode = id;
            this.name = name;
            table.set(name, (LuaValue)this);
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaMap map = (LuaMap)args.arg(1);
            switch (this.opcode) {
                case 0: {
                    return map.size();
                }
                case 1: {
                    return map.toLuaString();
                }
                case 2: {
                    return map.get(args.arg(2));
                }
                case 3: {
                    map.put(args.arg(2), args.arg(3));
                    return NIL;
                }
                case 4: {
                    return new nextLuaValue(map.entrySetIterator());
                }
                case 5: {
                    return new LuaListLib.nextLuaValue(map.keySetIterator());
                }
                case 6: {
                    return new LuaListLib.nextLuaValue(map.valuesIterator());
                }
                case 7: {
                    map.remove(args.arg(2));
                    return NIL;
                }
                case 8: {
                    return map.clone();
                }
                case 9: {
                    return map.merge((LuaMap)args.arg(2), (LuaFunction)args.arg(3));
                }
                case 10: {
                    return map.diff((LuaMap)args.arg(2));
                }
            }
            return NIL;
        }
    }

    private static final class nextLuaValue
    extends VarArgFunction {
        private final Iterator<Map.Entry<LuaValue, LuaValue>> iter;

        public nextLuaValue(Iterator<Map.Entry<LuaValue, LuaValue>> iter) {
            this.iter = iter;
        }

        @Override
        public Varargs invoke(Varargs args) {
            if (this.iter.hasNext()) {
                Map.Entry<LuaValue, LuaValue> entry = this.iter.next();
                return LuaValue.varargsOf(new LuaValue[]{entry.getKey(), entry.getValue()});
            }
            return NONE;
        }
    }
}

