/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.IQueryExecutor;
import com.aerospike.client.query.QueryValidate;
import com.aerospike.client.query.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class QueryExecutor
implements IQueryExecutor {
    protected final Cluster cluster;
    protected final QueryPolicy policy;
    protected final Statement statement;
    protected final long taskId;
    private final Node[] nodes;
    private final QueryThread[] threads;
    private final AtomicInteger completedCount;
    private final AtomicBoolean done;
    protected volatile Throwable exception;
    private final int maxConcurrentNodes;

    public QueryExecutor(Cluster cluster, QueryPolicy policy, Statement statement, Node[] nodes) {
        this.cluster = cluster;
        this.policy = policy;
        this.statement = statement;
        this.taskId = statement.prepareTaskId();
        this.nodes = nodes;
        this.completedCount = new AtomicInteger();
        this.done = new AtomicBoolean();
        this.threads = new QueryThread[nodes.length];
        this.maxConcurrentNodes = policy.maxConcurrentNodes == 0 || policy.maxConcurrentNodes >= this.threads.length ? this.threads.length : policy.maxConcurrentNodes;
        cluster.addCommandCount();
    }

    protected final void initializeThreads() {
        long clusterKey = this.policy.failOnClusterChange ? QueryValidate.validateBegin(this.nodes[0], this.statement.namespace, this.policy.infoTimeout) : 0L;
        boolean first = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            MultiCommand command = this.createCommand(this.nodes[i], clusterKey, first);
            this.threads[i] = new QueryThread(command);
            first = false;
        }
    }

    protected final void startThreads() {
        for (int i = 0; i < this.maxConcurrentNodes; ++i) {
            this.cluster.threadFactory.newThread(this.threads[i]).start();
        }
    }

    private final void threadCompleted() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.length) {
            int next2 = finished + this.maxConcurrentNodes - 1;
            if (next2 < this.threads.length && !this.done.get()) {
                this.threads[next2].run();
            }
        } else if (this.done.compareAndSet(false, true)) {
            this.sendCompleted();
        }
    }

    @Override
    public final void stopThreads(Throwable cause) {
        if (this.done.compareAndSet(false, true)) {
            this.exception = cause;
            for (QueryThread thread : this.threads) {
                thread.stop();
            }
            this.sendCancel();
        }
    }

    @Override
    public final void checkForException() {
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    protected abstract MultiCommand createCommand(Node var1, long var2, boolean var4);

    protected abstract void sendCancel();

    protected abstract void sendCompleted();

    private final class QueryThread
    implements Runnable {
        private final MultiCommand command;

        public QueryThread(MultiCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                if (this.command.isValid()) {
                    this.command.executeAndValidate(QueryExecutor.this.policy.infoTimeout);
                }
                QueryExecutor.this.threadCompleted();
            }
            catch (Throwable e) {
                QueryExecutor.this.stopThreads(e);
            }
        }

        public void stop() {
            this.command.stop();
        }
    }
}

