/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.Executor;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.QueryListener;
import com.aerospike.client.query.QueryListenerCommand;
import com.aerospike.client.query.Statement;
import com.aerospike.client.query.TaskGen;
import com.aerospike.client.util.Util;
import java.util.List;

public final class QueryListenerExecutor {
    public static void execute(Cluster cluster, QueryPolicy policy, Statement statement, QueryListener listener, PartitionTracker tracker) {
        cluster.addCommandCount();
        TaskGen task = new TaskGen(statement);
        long taskId = task.getId();
        while (true) {
            try {
                List<PartitionTracker.NodePartitions> list = tracker.assignPartitionsToNodes(cluster, statement.namespace);
                if (policy.maxConcurrentNodes > 0 && list.size() > 1) {
                    Executor executor = new Executor(cluster, list.size());
                    for (PartitionTracker.NodePartitions nodePartitions : list) {
                        QueryListenerCommand command = new QueryListenerCommand(cluster, policy, statement, taskId, listener, tracker, nodePartitions);
                        executor.addCommand(command);
                    }
                    executor.execute(policy.maxConcurrentNodes);
                } else {
                    for (PartitionTracker.NodePartitions nodePartitions : list) {
                        QueryListenerCommand command = new QueryListenerCommand(cluster, policy, statement, taskId, listener, tracker, nodePartitions);
                        command.execute();
                    }
                }
            }
            catch (AerospikeException ae) {
                tracker.partitionError();
                ae.setIteration(tracker.iteration);
                throw ae;
            }
            if (tracker.isComplete(cluster, policy)) {
                return;
            }
            if (policy.sleepBetweenRetries > 0) {
                Util.sleep(policy.sleepBetweenRetries);
            }
            taskId = task.nextId();
        }
    }
}

