/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.task.Task;

public final class IndexTask
extends Task {
    private final String namespace;
    private final String indexName;
    private final boolean isCreate;
    private String statusCommand;
    private String existsCommand;

    public IndexTask(Cluster cluster, Policy policy, String namespace, String indexName, boolean isCreate) {
        super(cluster, policy);
        this.namespace = namespace;
        this.indexName = indexName;
        this.isCreate = isCreate;
    }

    @Override
    public int queryStatus() {
        Node[] nodes;
        for (Node node : nodes = this.cluster.validateNodes()) {
            String response;
            int status2;
            if (this.isCreate) {
                if (this.statusCommand == null) {
                    this.statusCommand = IndexTask.buildStatusCommand(this.namespace, this.indexName);
                }
                if ((status2 = IndexTask.parseStatusResponse(this.statusCommand, response = Info.request(this.policy, node, this.statusCommand), this.isCreate)) == 2) continue;
                return status2;
            }
            if (this.existsCommand == null) {
                this.existsCommand = IndexTask.buildExistsCommand(this.namespace, this.indexName);
            }
            if ((status2 = IndexTask.parseExistsResponse(this.existsCommand, response = Info.request(this.policy, node, this.existsCommand))) == 2) continue;
            return status2;
        }
        return 2;
    }

    public static String buildStatusCommand(String namespace, String indexName) {
        return "sindex/" + namespace + "/" + indexName;
    }

    public static int parseStatusResponse(String command, String response, boolean isCreate) {
        if (isCreate) {
            int end;
            String find2 = "load_pct=";
            int index2 = response.indexOf(find2);
            if (index2 < 0) {
                Info.Error error2 = new Info.Error(response);
                if (error2.code == 201 || error2.code == 203) {
                    return 0;
                }
                throw new AerospikeException(error2.code, command + " failed: " + error2.message);
            }
            int begin = index2 + find2.length();
            String str = response.substring(begin, end = response.indexOf(59, begin));
            int pct = Integer.parseInt(str);
            if (pct != 100) {
                return 1;
            }
        } else {
            Info.Error error3 = new Info.Error(response);
            if (error3.code != 201) {
                return 1;
            }
        }
        return 2;
    }

    public static String buildExistsCommand(String namespace, String indexName) {
        return "sindex-exists:ns=" + namespace + ";indexname=" + indexName;
    }

    public static int parseExistsResponse(String command, String response) {
        if (response.equals("false")) {
            return 2;
        }
        if (response.equals("true")) {
            return 1;
        }
        throw new AerospikeException(command + " failed: " + response);
    }
}

