/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.command.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class Packer {
    private byte[] buffer;
    private int offset;

    public static byte[] pack(Value[] val) {
        try {
            Packer packer = new Packer();
            packer.packValueArray(val);
            packer.createBuffer();
            packer.packValueArray(val);
            return packer.getBuffer();
        }
        catch (Throwable e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(List<?> val) {
        try {
            Packer packer = new Packer();
            packer.packList(val);
            packer.createBuffer();
            packer.packList(val);
            return packer.getBuffer();
        }
        catch (Throwable e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(Map<?, ?> val, MapOrder order) {
        try {
            Packer packer = new Packer();
            packer.packMap(val, order);
            packer.createBuffer();
            packer.packMap(val, order);
            return packer.getBuffer();
        }
        catch (Throwable e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public static byte[] pack(List<? extends Map.Entry<?, ?>> val, MapOrder order) {
        try {
            Packer packer = new Packer();
            packer.packMap(val, order);
            packer.createBuffer();
            packer.packMap(val, order);
            return packer.getBuffer();
        }
        catch (Throwable e) {
            throw new AerospikeException.Serialize(e);
        }
    }

    public void packValueArray(Value[] values) {
        this.packArrayBegin(values.length);
        for (Value value : values) {
            value.pack(this);
        }
    }

    public void packValueList(List<Value> list) {
        this.packArrayBegin(list.size());
        for (Value value : list) {
            value.pack(this);
        }
    }

    public void packList(List<?> list) {
        this.packArrayBegin(list.size());
        for (Object obj : list) {
            this.packObject(obj);
        }
    }

    public void packArrayBegin(int size) {
        if (size < 16) {
            this.packByte(0x90 | size);
        } else if (size < 65536) {
            this.packShort(220, size);
        } else {
            this.packInt(221, size);
        }
    }

    public void packValueMap(Map<Value, Value> map) {
        MapOrder order = Value.MapValue.getMapOrder(map);
        this.packMapBegin(map.size(), order);
        for (Map.Entry<Value, Value> entry : map.entrySet()) {
            entry.getKey().pack(this);
            entry.getValue().pack(this);
        }
    }

    public void packMap(Map<?, ?> map) {
        MapOrder order = Value.MapValue.getMapOrder(map);
        this.packMap(map, order);
    }

    public void packMap(Map<?, ?> map, MapOrder order) {
        this.packMapBegin(map.size(), order);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.packObject(entry.getKey());
            this.packObject(entry.getValue());
        }
    }

    public void packMap(List<? extends Map.Entry<?, ?>> list, MapOrder order) {
        this.packMapBegin(list.size(), order);
        for (Map.Entry<?, ?> entry : list) {
            this.packObject(entry.getKey());
            this.packObject(entry.getValue());
        }
    }

    public void packMapBegin(int size, MapOrder order) {
        if (order == MapOrder.UNORDERED) {
            this.packMapBegin(size);
        } else {
            this.packMapBegin(size + 1);
            this.packByte(199);
            this.packByte(0);
            this.packByte(order.attributes);
            this.packByte(192);
        }
    }

    public void packMapBegin(int size) {
        if (size < 16) {
            this.packByte(0x80 | size);
        } else if (size < 65536) {
            this.packShort(222, size);
        } else {
            this.packInt(223, size);
        }
    }

    public void packBytes(byte[] b) {
        this.packByteArrayBegin(b.length);
        this.packByteArray(b, 0, b.length);
    }

    public void packParticleBytes(byte[] b) {
        this.packByteArrayBegin(b.length + 1);
        this.packByte(4);
        this.packByteArray(b, 0, b.length);
    }

    public void packParticleBytes(byte[] b, int type2) {
        this.packByteArrayBegin(b.length + 1);
        this.packByte(type2);
        this.packByteArray(b, 0, b.length);
    }

    public void packParticleBytes(byte[] b, int offset, int length) {
        this.packByteArrayBegin(length + 1);
        this.packByte(4);
        this.packByteArray(b, offset, length);
    }

    public void packGeoJSON(String val) {
        byte[] buffer = Buffer.stringToUtf8(val);
        this.packByteArrayBegin(buffer.length + 1);
        this.packByte(23);
        this.packByteArray(buffer, 0, buffer.length);
    }

    private void packByteArrayBegin(int size) {
        this.packStringBegin(size);
    }

    public void packObject(Object obj) {
        if (obj == null) {
            this.packNil();
            return;
        }
        if (obj instanceof Value) {
            Value value = (Value)obj;
            value.pack(this);
            return;
        }
        if (obj instanceof byte[]) {
            this.packParticleBytes((byte[])obj);
            return;
        }
        if (obj instanceof String) {
            this.packParticleString((String)obj);
            return;
        }
        if (obj instanceof Integer) {
            this.packInt((Integer)obj);
            return;
        }
        if (obj instanceof Long) {
            this.packLong((Long)obj);
            return;
        }
        if (obj instanceof List) {
            this.packList((List)obj);
            return;
        }
        if (obj instanceof Map) {
            this.packMap((Map)obj);
            return;
        }
        if (obj instanceof Double) {
            this.packDouble((Double)obj);
            return;
        }
        if (obj instanceof Float) {
            this.packFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Short) {
            this.packInt(((Short)obj).shortValue());
            return;
        }
        if (obj instanceof Boolean) {
            this.packBoolean((Boolean)obj);
            return;
        }
        if (obj instanceof Byte) {
            this.packInt((int)((Byte)obj & 0xFF));
            return;
        }
        if (obj instanceof Character) {
            this.packInt(((Character)obj).charValue());
            return;
        }
        if (obj instanceof Enum) {
            this.packString(obj.toString());
            return;
        }
        if (obj instanceof UUID) {
            this.packString(obj.toString());
            return;
        }
        if (obj instanceof ByteBuffer) {
            this.packByteBuffer((ByteBuffer)obj);
            return;
        }
        throw new AerospikeException("Unsupported type: " + obj.getClass().getName());
    }

    public void packByteBuffer(ByteBuffer bb) {
        byte[] b = bb.array();
        this.packParticleBytes(b);
    }

    public void packLong(long val) {
        if (val >= 0L) {
            if (val < 128L) {
                this.packByte((int)val);
                return;
            }
            if (val < 256L) {
                this.packByte(204, (int)val);
                return;
            }
            if (val < 65536L) {
                this.packShort(205, (int)val);
                return;
            }
            if (val < 0x100000000L) {
                this.packInt(206, (int)val);
                return;
            }
            this.packLong(207, val);
        } else {
            if (val >= -32L) {
                this.packByte(0xE0 | (int)val + 32);
                return;
            }
            if (val >= -128L) {
                this.packByte(208, (int)val);
                return;
            }
            if (val >= -32768L) {
                this.packShort(209, (int)val);
                return;
            }
            if (val >= Integer.MIN_VALUE) {
                this.packInt(210, (int)val);
                return;
            }
            this.packLong(211, val);
        }
    }

    public void packInt(int val) {
        if (val >= 0) {
            if (val < 128) {
                this.packByte(val);
                return;
            }
            if (val < 256) {
                this.packByte(204, val);
                return;
            }
            if (val < 65536) {
                this.packShort(205, val);
                return;
            }
            this.packInt(206, val);
        } else {
            if (val >= -32) {
                this.packByte(0xE0 | val + 32);
                return;
            }
            if (val >= -128) {
                this.packByte(208, val);
                return;
            }
            if (val >= Short.MIN_VALUE) {
                this.packShort(209, val);
                return;
            }
            this.packInt(210, val);
        }
    }

    public void packString(String val) {
        int size = Buffer.estimateSizeUtf8(val);
        this.packStringBegin(size);
        if (this.buffer == null) {
            this.offset += size;
            return;
        }
        this.offset += Buffer.stringToUtf8(val, this.buffer, this.offset);
    }

    public void packParticleString(String val) {
        int size = Buffer.estimateSizeUtf8(val) + 1;
        this.packStringBegin(size);
        if (this.buffer == null) {
            this.offset += size;
            return;
        }
        this.buffer[this.offset++] = 3;
        this.offset += Buffer.stringToUtf8(val, this.buffer, this.offset);
    }

    private void packStringBegin(int size) {
        if (size < 32) {
            this.packByte(0xA0 | size);
        } else if (size < 256) {
            this.packByte(217, size);
        } else if (size < 65536) {
            this.packShort(218, size);
        } else {
            this.packInt(219, size);
        }
    }

    public void packByteArray(byte[] src, int srcOffset, int srcLength) {
        if (this.buffer == null) {
            this.offset += srcLength;
            return;
        }
        System.arraycopy(src, srcOffset, this.buffer, this.offset, srcLength);
        this.offset += srcLength;
    }

    public void packDouble(double val) {
        if (this.buffer == null) {
            this.offset += 9;
            return;
        }
        this.buffer[this.offset++] = -53;
        Buffer.longToBytes(Double.doubleToLongBits(val), this.buffer, this.offset);
        this.offset += 8;
    }

    public void packFloat(float val) {
        if (this.buffer == null) {
            this.offset += 5;
            return;
        }
        this.buffer[this.offset++] = -54;
        Buffer.intToBytes(Float.floatToIntBits(val), this.buffer, this.offset);
        this.offset += 4;
    }

    private void packLong(int type2, long val) {
        if (this.buffer == null) {
            this.offset += 9;
            return;
        }
        this.buffer[this.offset++] = (byte)type2;
        Buffer.longToBytes(val, this.buffer, this.offset);
        this.offset += 8;
    }

    private void packInt(int type2, int val) {
        if (this.buffer == null) {
            this.offset += 5;
            return;
        }
        this.buffer[this.offset++] = (byte)type2;
        Buffer.intToBytes(val, this.buffer, this.offset);
        this.offset += 4;
    }

    private void packShort(int type2, int val) {
        if (this.buffer == null) {
            this.offset += 3;
            return;
        }
        this.buffer[this.offset++] = (byte)type2;
        Buffer.shortToBytes(val, this.buffer, this.offset);
        this.offset += 2;
    }

    private void packByte(int type2, int val) {
        if (this.buffer == null) {
            this.offset += 2;
            return;
        }
        this.buffer[this.offset++] = (byte)type2;
        this.buffer[this.offset++] = (byte)val;
    }

    public void packBoolean(boolean val) {
        if (this.buffer == null) {
            ++this.offset;
            return;
        }
        this.buffer[this.offset++] = val ? -61 : -62;
    }

    public void packNil() {
        if (this.buffer == null) {
            ++this.offset;
            return;
        }
        this.buffer[this.offset++] = -64;
    }

    public void packInfinity() {
        if (this.buffer == null) {
            this.offset += 3;
            return;
        }
        this.buffer[this.offset++] = -44;
        this.buffer[this.offset++] = -1;
        this.buffer[this.offset++] = 1;
    }

    public void packWildcard() {
        if (this.buffer == null) {
            this.offset += 3;
            return;
        }
        this.buffer[this.offset++] = -44;
        this.buffer[this.offset++] = -1;
        this.buffer[this.offset++] = 0;
    }

    public void packByte(int val) {
        if (this.buffer == null) {
            ++this.offset;
            return;
        }
        this.buffer[this.offset++] = (byte)val;
    }

    public void createBuffer() {
        this.buffer = new byte[this.offset];
        this.offset = 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }
}

