/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.jce.params;

import gnu.crypto.jce.params.DEREncodingException;
import java.math.BigInteger;

class DERReader {
    static final int UNIVERSAL = 1;
    static final int APPLICATION = 2;
    static final int CONTEXT_SPECIFIC = 3;
    static final int PRIVATE = 4;
    byte[] source;
    int pos;

    public void init(String source) {
        this.init(source.getBytes());
    }

    public void init(byte[] source) {
        this.source = source;
        this.pos = 0;
    }

    public boolean hasMorePrimitives() {
        boolean bl = false;
        if (this.pos < this.source.length) {
            bl = true;
        }
        return bl;
    }

    public BigInteger getBigInteger() throws DEREncodingException {
        return new BigInteger(this.getPrimitive());
    }

    private final byte[] getPrimitive() throws DEREncodingException {
        byte identifier;
        int tmp = this.pos;
        if ((0x20 & (identifier = this.source[tmp++])) != 0) {
            throw new DEREncodingException();
        }
        int type2 = this.translateLeadIdentifierByte(identifier);
        int tag = 0x1F & identifier;
        int len2 = this.source[tmp];
        long length = 0x7F & len2;
        if ((0x80 & len2) != 0) {
            len2 = (byte)(len2 & 0x7F);
            length = 0L;
            int i = 0;
            while (i < len2) {
                length <<= 8;
                length += (long)(this.source[++tmp] < 0 ? 256 + this.source[tmp] : this.source[tmp]);
                ++i;
            }
            ++tmp;
        } else {
            ++tmp;
        }
        byte[] tmpb = new byte[(int)length];
        System.arraycopy(this.source, tmp, tmpb, 0, (int)length);
        this.pos = (int)((long)tmp + length);
        return tmpb;
    }

    private final int translateLeadIdentifierByte(byte b) {
        if ((0x3F & b) == b) {
            return 1;
        }
        if ((0x7F & b) == b) {
            return 2;
        }
        if ((0xBF & b) == b) {
            return 3;
        }
        return 4;
    }

    private final int getIdentifier(int tpos) {
        while ((0x80 & this.source[tpos]) != 0) {
            ++tpos;
        }
        return tpos;
    }

    public DERReader() {
        this.source = null;
        this.pos = 0;
    }

    public DERReader(byte[] source) {
        this.init(source);
    }
}

