/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.jce.sig;

import gnu.crypto.jce.sig.KeyPairGeneratorAdapter;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;

public class RSAKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter {
    public void initialize(int keysize, SecureRandom random2) {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("gnu.crypto.rsa.L", new Integer(keysize));
        if (random2 != null) {
            attributes.put("gnu.crypto.rsa.prng", random2);
        }
        this.adaptee.setup(attributes);
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random2) throws InvalidAlgorithmParameterException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (params != null) {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params");
            }
            attributes.put("gnu.crypto.rsa.params", params);
        }
        if (random2 != null) {
            attributes.put("gnu.crypto.rsa.prng", random2);
        }
        this.adaptee.setup(attributes);
    }

    public RSAKeyPairGeneratorSpi() {
        super("rsa");
    }
}

