/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.BatchReadPolicy;
import com.aerospike.client.policy.Policy;

public final class BatchRead
extends BatchRecord {
    public final BatchReadPolicy policy;
    public final String[] binNames;
    public final Operation[] ops;
    public final boolean readAllBins;

    public BatchRead(Key key, String[] binNames) {
        super(key, false);
        this.policy = null;
        this.binNames = binNames;
        this.ops = null;
        this.readAllBins = false;
    }

    public BatchRead(Key key, boolean readAllBins) {
        super(key, false);
        this.policy = null;
        this.binNames = null;
        this.ops = null;
        this.readAllBins = readAllBins;
    }

    public BatchRead(Key key, Operation[] ops) {
        super(key, false);
        this.policy = null;
        this.binNames = null;
        this.ops = ops;
        this.readAllBins = false;
    }

    public BatchRead(BatchReadPolicy policy, Key key, String[] binNames) {
        super(key, false);
        this.policy = policy;
        this.binNames = binNames;
        this.ops = null;
        this.readAllBins = false;
    }

    public BatchRead(BatchReadPolicy policy, Key key, boolean readAllBins) {
        super(key, false);
        this.policy = policy;
        this.binNames = null;
        this.ops = null;
        this.readAllBins = readAllBins;
    }

    public BatchRead(BatchReadPolicy policy, Key key, Operation[] ops) {
        super(key, false);
        this.policy = policy;
        this.binNames = null;
        this.ops = ops;
        this.readAllBins = false;
    }

    @Override
    public BatchRecord.Type getType() {
        return BatchRecord.Type.BATCH_READ;
    }

    @Override
    public boolean equals(BatchRecord obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchRead other = (BatchRead)obj;
        return this.binNames == other.binNames && this.ops == other.ops && this.policy == other.policy && this.readAllBins == other.readAllBins;
    }

    @Override
    public int size(Policy parentPolicy) {
        int size;
        block5: {
            block4: {
                size = 0;
                if (this.policy != null && this.policy.filterExp != null) {
                    size += this.policy.filterExp.size();
                }
                if (this.binNames == null) break block4;
                for (String binName : this.binNames) {
                    size += Buffer.estimateSizeUtf8(binName) + 8;
                }
                break block5;
            }
            if (this.ops == null) break block5;
            for (Operation op : this.ops) {
                if (op.type.isWrite) {
                    throw new AerospikeException(4, "Write operations not allowed in batch read");
                }
                size += Buffer.estimateSizeUtf8(op.binName) + 8;
                size += op.value.estimateSize();
            }
        }
        return size;
    }
}

