/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class Txn {
    private static AtomicLong randomState = new AtomicLong(System.nanoTime());
    private final long id;
    private final ConcurrentHashMap<Key, Long> reads;
    private final Set<Key> writes;
    private State state;
    private String namespace;
    private int timeout;
    private int deadline;
    private boolean writeInDoubt;
    private boolean inDoubt;

    public Txn() {
        this.id = Txn.createId();
        this.reads = new ConcurrentHashMap();
        this.writes = ConcurrentHashMap.newKeySet();
        this.state = State.OPEN;
    }

    public Txn(int readsCapacity, int writesCapacity) {
        if (readsCapacity < 16) {
            readsCapacity = 16;
        }
        if (writesCapacity < 16) {
            writesCapacity = 16;
        }
        this.id = Txn.createId();
        this.reads = new ConcurrentHashMap(readsCapacity);
        this.writes = ConcurrentHashMap.newKeySet(writesCapacity);
        this.state = State.OPEN;
    }

    private static long createId() {
        long newState;
        long oldState;
        do {
            newState = oldState = randomState.get();
            newState ^= newState >>> 12;
            newState ^= newState << 25;
        } while (!randomState.compareAndSet(oldState, newState ^= newState >>> 27));
        return newState * 2685821657736338717L;
    }

    public long getId() {
        return this.id;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    void prepareRead(String ns) {
        this.verifyCommand();
        this.setNamespace(ns);
    }

    void prepareRead(Key[] keys) {
        this.verifyCommand();
        this.setNamespace(keys);
    }

    void prepareRead(List<BatchRead> records) {
        this.verifyCommand();
        this.setNamespace(records);
    }

    public void verifyCommand() {
        if (this.state != State.OPEN) {
            throw new AerospikeException("Command not allowed in current MRT state: " + String.valueOf((Object)this.state));
        }
    }

    public void onRead(Key key, Long version) {
        if (version != null) {
            this.reads.put(key, version);
        }
    }

    public Long getReadVersion(Key key) {
        return this.reads.get(key);
    }

    public Set<Map.Entry<Key, Long>> getReads() {
        return this.reads.entrySet();
    }

    public void onWrite(Key key, Long version, int resultCode) {
        if (version != null) {
            this.reads.put(key, version);
        } else if (resultCode == 0) {
            this.reads.remove(key);
            this.writes.add(key);
        }
    }

    public void onWriteInDoubt(Key key) {
        this.writeInDoubt = true;
        this.reads.remove(key);
        this.writes.add(key);
    }

    public Set<Key> getWrites() {
        return this.writes;
    }

    public void setNamespace(String ns) {
        if (this.namespace == null) {
            this.namespace = ns;
        } else if (!this.namespace.equals(ns)) {
            throw new AerospikeException("Namespace must be the same for all commands in the MRT. orig: " + this.namespace + " new: " + ns);
        }
    }

    private void setNamespace(Key[] keys) {
        for (Key key : keys) {
            this.setNamespace(key.namespace);
        }
    }

    private void setNamespace(List<BatchRead> records) {
        for (BatchRead br : records) {
            this.setNamespace(br.key.namespace);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setDeadline(int deadline) {
        this.deadline = deadline;
    }

    public int getDeadline() {
        return this.deadline;
    }

    public boolean closeMonitor() {
        return this.deadline != 0 && !this.writeInDoubt;
    }

    public boolean monitorExists() {
        return this.deadline != 0;
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public void setInDoubt(boolean inDoubt) {
        this.inDoubt = inDoubt;
    }

    public boolean getInDoubt() {
        return this.inDoubt;
    }

    public void clear() {
        this.namespace = null;
        this.deadline = 0;
        this.reads.clear();
        this.writes.clear();
    }

    public static enum State {
        OPEN,
        VERIFIED,
        COMMITTED,
        ABORTED;

    }
}

