/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncWriteCommand;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class ExecuteCommand
extends SyncWriteCommand {
    private final String packageName;
    private final String functionName;
    private final Value[] args;
    private Record record;

    public ExecuteCommand(Cluster cluster, WritePolicy writePolicy, Key key, String packageName, String functionName, Value[] args) {
        super(cluster, writePolicy, key);
        this.packageName = packageName;
        this.functionName = functionName;
        this.args = args;
    }

    @Override
    protected void writeBuffer() {
        this.setUdf(this.writePolicy, this.key, this.packageName, this.functionName, this.args);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        RecordParser rp = new RecordParser(conn, this.dataBuffer);
        rp.parseFields(this.policy.txn, this.key, true);
        if (rp.resultCode == 0) {
            this.record = rp.parseRecord(false);
            return;
        }
        if (rp.resultCode == 100) {
            this.record = rp.parseRecord(false);
            this.handleUdfError(rp.resultCode);
            return;
        }
        if (rp.resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(rp.resultCode);
            }
            return;
        }
        throw new AerospikeException(rp.resultCode);
    }

    private void handleUdfError(int resultCode) {
        String message;
        int code;
        String ret = (String)this.record.bins.get("FAILURE");
        if (ret == null) {
            throw new AerospikeException(resultCode);
        }
        try {
            String[] list = ret.split(":");
            code = Integer.parseInt(list[2].trim());
            message = list[0] + ":" + list[1] + " " + list[3];
        }
        catch (Throwable e) {
            throw new AerospikeException(resultCode, ret);
        }
        throw new AerospikeException(code, message);
    }

    public Record getRecord() {
        return this.record;
    }
}

