/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.MultiCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class Executor {
    private final List<ExecutorThread> threads;
    private final ThreadFactory threadFactory;
    private volatile Throwable exception;
    private final AtomicBoolean done;
    private final AtomicInteger completedCount;
    private int maxConcurrentThreads;

    public Executor(Cluster cluster, int capacity) {
        this.threads = new ArrayList<ExecutorThread>(capacity);
        this.threadFactory = cluster.threadFactory;
        this.done = new AtomicBoolean();
        this.completedCount = new AtomicInteger();
    }

    public void addCommand(MultiCommand command) {
        this.threads.add(new ExecutorThread(command));
    }

    public void execute(int maxConcurrent) {
        this.maxConcurrentThreads = maxConcurrent == 0 || maxConcurrent >= this.threads.size() ? this.threads.size() : maxConcurrent;
        try (ExecutorService es = Executors.newThreadPerTaskExecutor(this.threadFactory);){
            for (int i = 0; i < this.maxConcurrentThreads; ++i) {
                es.execute(this.threads.get(i));
            }
        }
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    private void threadCompleted() {
        int next;
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.size() && (next = finished + this.maxConcurrentThreads - 1) < this.threads.size() && !this.done.get()) {
            this.threads.get(next).run();
        }
    }

    private void stopThreads(Throwable cause) {
        if (this.done.compareAndSet(false, true)) {
            this.exception = cause;
            for (ExecutorThread thread : this.threads) {
                thread.stop();
            }
        }
    }

    private final class ExecutorThread
    implements Runnable {
        private final MultiCommand command;

        public ExecutorThread(MultiCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
                Executor.this.threadCompleted();
            }
            catch (Throwable e) {
                Executor.this.stopThreads(e);
            }
        }

        public void stop() {
            this.command.stop();
        }
    }
}

